/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt.db;

import com.mysql.grt.Grt;
import com.mysql.grt.GrtObject;
import com.mysql.grt.db.DatabaseObject;
import com.mysql.grt.db.RoutineGroupList;
import com.mysql.grt.db.RoutineList;
import com.mysql.grt.db.SchemaData;
import com.mysql.grt.db.SchemaDataGlobal;
import com.mysql.grt.db.SchemaDataLocal;
import com.mysql.grt.db.SequenceList;
import com.mysql.grt.db.StructuredDatatypeList;
import com.mysql.grt.db.SynonymList;
import com.mysql.grt.db.TableList;
import com.mysql.grt.db.ViewList;

public class Schema
extends DatabaseObject {
    protected Schema() {
    }

    public Schema(Object object) {
        if (object == null || object instanceof GrtObject) {
            this.data = new SchemaDataLocal(this);
            this.data.setOwner((GrtObject)object);
            Grt.getInstance().addToObjectCache(this);
        } else if (object instanceof String) {
            this.data = new SchemaDataGlobal((String)object);
        }
    }

    public String getDefaultCharacterSetName() {
        return ((SchemaData)this.data).getDefaultCharacterSetName();
    }

    public String setDefaultCharacterSetName(String string) {
        ((SchemaData)this.data).setDefaultCharacterSetName(string);
        return this.getDefaultCharacterSetName();
    }

    public String getDefaultCollationName() {
        return ((SchemaData)this.data).getDefaultCollationName();
    }

    public String setDefaultCollationName(String string) {
        ((SchemaData)this.data).setDefaultCollationName(string);
        return this.getDefaultCollationName();
    }

    public TableList getTables() {
        return ((SchemaData)this.data).getTables();
    }

    public TableList setTables(TableList tableList) {
        ((SchemaData)this.data).setTables(tableList);
        return this.getTables();
    }

    public ViewList getViews() {
        return ((SchemaData)this.data).getViews();
    }

    public ViewList setViews(ViewList viewList) {
        ((SchemaData)this.data).setViews(viewList);
        return this.getViews();
    }

    public RoutineList getRoutines() {
        return ((SchemaData)this.data).getRoutines();
    }

    public RoutineList setRoutines(RoutineList routineList) {
        ((SchemaData)this.data).setRoutines(routineList);
        return this.getRoutines();
    }

    public RoutineGroupList getRoutineGroups() {
        return ((SchemaData)this.data).getRoutineGroups();
    }

    public RoutineGroupList setRoutineGroups(RoutineGroupList routineGroupList) {
        ((SchemaData)this.data).setRoutineGroups(routineGroupList);
        return this.getRoutineGroups();
    }

    public SynonymList getSynonyms() {
        return ((SchemaData)this.data).getSynonyms();
    }

    public SynonymList setSynonyms(SynonymList synonymList) {
        ((SchemaData)this.data).setSynonyms(synonymList);
        return this.getSynonyms();
    }

    public StructuredDatatypeList getStructuredTypes() {
        return ((SchemaData)this.data).getStructuredTypes();
    }

    public StructuredDatatypeList setStructuredTypes(StructuredDatatypeList structuredDatatypeList) {
        ((SchemaData)this.data).setStructuredTypes(structuredDatatypeList);
        return this.getStructuredTypes();
    }

    public SequenceList getSequences() {
        return ((SchemaData)this.data).getSequences();
    }

    public SequenceList setSequences(SequenceList sequenceList) {
        ((SchemaData)this.data).setSequences(sequenceList);
        return this.getSequences();
    }

    public StringBuffer getGrtXmlMembers(StringBuffer stringBuffer) {
        super.getGrtXmlMembers(stringBuffer);
        if (this.getDefaultCharacterSetName() != null) {
            stringBuffer.append("<value type=\"string\" key=\"defaultCharacterSetName\">" + Grt.escapeStringForXml(this.getDefaultCharacterSetName()) + "</value>\n");
        }
        if (this.getDefaultCollationName() != null) {
            stringBuffer.append("<value type=\"string\" key=\"defaultCollationName\">" + Grt.escapeStringForXml(this.getDefaultCollationName()) + "</value>\n");
        }
        if (this.getTables() != null) {
            this.getTables().getGrtXml(stringBuffer, " key=\"tables\"");
        }
        if (this.getViews() != null) {
            this.getViews().getGrtXml(stringBuffer, " key=\"views\"");
        }
        if (this.getRoutines() != null) {
            this.getRoutines().getGrtXml(stringBuffer, " key=\"routines\"");
        }
        if (this.getRoutineGroups() != null) {
            this.getRoutineGroups().getGrtXml(stringBuffer, " key=\"routineGroups\"");
        }
        if (this.getSynonyms() != null) {
            this.getSynonyms().getGrtXml(stringBuffer, " key=\"synonyms\"");
        }
        if (this.getStructuredTypes() != null) {
            this.getStructuredTypes().getGrtXml(stringBuffer, " key=\"structuredTypes\"");
        }
        if (this.getSequences() != null) {
            this.getSequences().getGrtXml(stringBuffer, " key=\"sequences\"");
        }
        return stringBuffer;
    }
}

