/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt;

import com.mysql.grt.Grt;
import com.mysql.grt.GrtHashMap;
import com.mysql.grt.GrtObject;
import com.mysql.grt.db.Column;
import com.mysql.grt.db.ColumnList;
import com.mysql.grt.db.SimpleDatatype;
import com.mysql.grt.modules.JavaTestModule;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class GrtTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run(GrtTest.class);
    }

    public void testPrepareGrtXml() {
        StringBuffer stringBuffer = new StringBuffer("<value type=\"string\">test</value>");
        String string = Grt.prepareGrtXmlFooter(Grt.prepareGrtXmlHeader().append(stringBuffer)).toString();
        Assert.assertEquals((String)string, (String)("<?xml version=\"1.0\"?>\n<data>\n" + stringBuffer + "</data>\n"));
    }

    public void testGetObjectsFromGrtXml() {
        StringBuffer stringBuffer = Grt.prepareGrtXmlHeader().append("<value type=\"dict\">\n<value type=\"dict\" struct-name=\"db.SimpleDatatype\" key=\"simpleType\">\n<value type=\"string\" key=\"_id\">423423:89734566:746345234</value>\n<value type=\"string\" key=\"name\">VARCHAR</value>\n<value type=\"int\" key=\"characterMaximumLength\">255</value>\n<value type=\"int\" key=\"characterOctetLength\">0</value>\n<value type=\"int\" key=\"numericPrecision\">0</value>\n<value type=\"int\" key=\"numericPrecisionRadix\">0</value>\n<value type=\"int\" key=\"numericScale\">0</value>\n<value type=\"int\" key=\"dateTimePrecision\">0</value>\n</value>\n<value type=\"list\" content-type=\"dict\" content-struct-name=\"db.Column\" key=\"columns\">\n<value type=\"dict\" struct-name=\"db.Column\">\n<value type=\"string\" key=\"_id\">328758:2732734:32434234</value>\n<value type=\"string\" key=\"name\">Host</value>\n<value type=\"int\" key=\"precision\">0</value>\n<value type=\"int\" key=\"scale\">0</value>\n<value type=\"int\" key=\"isNullable\">1</value>\n<value type=\"int\" key=\"length\">30</value>\n<value type=\"string\" key=\"datatypeName\">varchar</value>\n<value type=\"string\" key=\"defaultValue\">testing</value>\n<value type=\"string\" key=\"characterSetName\">default</value>\n<value type=\"string\" key=\"collationName\">default</value>\n<value type=\"string\" option=\"ref\" key=\"simpleType\">423423:89734566:746345234</value>\n</value>\n</value>\n</value>\n");
        String string = Grt.prepareGrtXmlFooter(stringBuffer).toString();
        GrtHashMap grtHashMap = (GrtHashMap)Grt.getObjectsFromGrtXml(string);
        Assert.assertNotNull((Object)grtHashMap);
        Object object = grtHashMap.getObject("columns");
        Assert.assertNotNull((Object)object);
        Assert.assertEquals((String)object.getClass().getName(), (String)"com.mysql.grt.db.ColumnList");
        ColumnList columnList = (ColumnList)object;
        Column column = columnList.get(0);
        Assert.assertEquals((String)column.getDatatypeName(), (String)"varchar");
        SimpleDatatype simpleDatatype = column.getSimpleType();
        Assert.assertEquals((int)simpleDatatype.getCharacterMaximumLength(), (int)255);
        Assert.assertEquals((String)Grt.prepareGrtXmlFooter(grtHashMap.getGrtXml(Grt.prepareGrtXmlHeader(), "")).toString(), (String)string);
    }

    public void testCallModuleFunctionNonExistingFunction() {
        String string = Grt.callModuleFunction(JavaTestModule.class, "nonExistingFuntion", "", "");
        GrtHashMap grtHashMap = (GrtHashMap)Grt.getObjectsFromGrtXml(string);
        Assert.assertNotNull((Object)grtHashMap.getObject("error"));
        Assert.assertNotNull((Object)grtHashMap.getObject("detail"));
    }

    public void testException() {
        String string = Grt.callModuleFunction(JavaTestModule.class, "throwException", "", "");
        GrtHashMap grtHashMap = (GrtHashMap)Grt.getObjectsFromGrtXml(string);
        Assert.assertNotNull((Object)grtHashMap.getObject("error"));
        Assert.assertNotNull((Object)grtHashMap.getObject("detail"));
        Assert.assertEquals((Object)grtHashMap.getObject("error"), (Object)"Exception Test");
    }

    public void testGetGlobalObjects() {
        Grt.getInstance().setCallback("GrtCallbackTest", "");
        GrtObject grtObject = Grt.getInstance().getGrtGlobalAsGrtObject("/testObject");
        Assert.assertEquals((String)grtObject.getName(), (String)"TestObject");
        Assert.assertEquals((String)grtObject.get_id(), (String)"123456789");
        Column column = (Column)Grt.getInstance().getGrtGlobalAsGrtObject("/column");
        Assert.assertEquals((String)column.getName(), (String)"TestColumn");
        SimpleDatatype simpleDatatype = column.getSimpleType();
        SimpleDatatype simpleDatatype2 = (SimpleDatatype)Grt.getInstance().getGrtGlobalAsGrtObject("/simpleDatatype");
        Assert.assertEquals((String)simpleDatatype2.getName(), (String)"VARCHAR");
        Assert.assertEquals((int)simpleDatatype2.getCharacterMaximumLength(), (int)255);
        Assert.assertTrue((simpleDatatype2 != simpleDatatype ? 1 : 0) != 0);
    }
}

