/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt;

import com.mysql.grt.GrtCallback;
import com.mysql.grt.GrtHashMap;
import com.mysql.grt.GrtList;
import com.mysql.grt.GrtMessage;
import com.mysql.grt.GrtObject;
import com.mysql.grt.GrtStringHashMap;
import com.mysql.grt.GrtStringList;
import com.mysql.grt.GrtXml;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Grt {
    static Grt instance;
    private long myxGrtPointer = 0L;
    private GrtCallback callback = null;
    private String applicationPath;
    private String applicationDataPath = "";
    private HashMap objects = new HashMap();
    private Vector msgs = new Vector();
    private int doJava2GrtXmlLogging = 0;
    public static final int MYX_INT_VALUE = 1;
    public static final int MYX_REAL_VALUE = 2;
    public static final int MYX_STRING_VALUE = 3;
    public static final int MYX_LIST_VALUE = 4;
    public static final int MYX_DICT_VALUE = 5;
    public static final int MYX_UNKNOWN_VALUE = -1;
    public static final String GrtPackagePrefix = "com.mysql.grt.";
    public static final String GrtModulePackagePrefix = "com.mysql.grt.modules.";

    private Grt() {
        this.setMyxGrtPointer(0L);
    }

    public static Grt getInstance() {
        if (instance == null) {
            instance = new Grt();
        }
        return instance;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.equals("")) {
            String string4 = "Can not perform replace. orig: \"" + string + "\"" + " searchFor: \"" + string2 + "\"" + " replacement: \"" + string3;
            throw new IllegalArgumentException(string4);
        }
        int n = string.length() + string3.length() + 20;
        StringBuffer stringBuffer = new StringBuffer(n);
        Grt.replaceInner(stringBuffer, string, string2, string3);
        return stringBuffer.toString();
    }

    private static void replaceInner(StringBuffer stringBuffer, String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            stringBuffer.append(string);
            return;
        }
        String string4 = string.substring(0, n);
        stringBuffer.append(string4);
        stringBuffer.append(string3);
        String string5 = string.substring(n + string2.length());
        Grt.replaceInner(stringBuffer, string5, string2, string3);
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = Grt.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public void setCallback(String string, String string2) {
        if (this.callback == null) {
            GrtCallback grtCallback;
            try {
                Class<?> clazz = Class.forName(GrtPackagePrefix + string);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                grtCallback = (GrtCallback)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                return;
            }
            this.callback = grtCallback;
            this.applicationPath = string2;
            grtCallback.setApplicationPath(string2);
        }
    }

    public GrtCallback getCallback() {
        if (this.callback == null) {
            throw new RuntimeException("The callback object is not set.");
        }
        return this.callback;
    }

    public void java2GrtXmlLogging(int n) {
        this.doJava2GrtXmlLogging = n == 1 ? 1 : 0;
    }

    public int java2GrtXmlLogging() {
        return this.doJava2GrtXmlLogging;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public String getApplicationDataPath() {
        if (this.applicationDataPath == "") {
            this.applicationDataPath = (String)Grt.getInstance().callGrtFunction("Base", "getAppDataDir", null);
        }
        return this.applicationDataPath;
    }

    private long getMyxGrtPointer() {
        return this.myxGrtPointer;
    }

    private void setMyxGrtPointer(long l) {
        this.myxGrtPointer = l;
    }

    public void addToObjectCache(GrtObject grtObject) {
        if (!this.objects.containsKey(grtObject.get_id())) {
            this.objects.put(grtObject.get_id(), grtObject);
        }
    }

    protected void removeFromObjectCache(GrtObject grtObject) {
        if (this.objects.containsKey(grtObject.get_id())) {
            this.objects.remove(grtObject.get_id());
        }
    }

    protected void clearObjectCache() {
        Grt.getInstance().objects.clear();
    }

    public GrtObject getObjectByRefId(String string) {
        if (string == null) {
            return null;
        }
        GrtObject grtObject = (GrtObject)this.objects.get(string);
        if (grtObject == null && this.getCallback() != null) {
            grtObject = (GrtObject)this.getCallback().getGrtGlobalById(this.getMyxGrtPointer(), string);
        }
        return grtObject;
    }

    public static Object getGrtClassInstance(String string, Object object) {
        try {
            Class<?> clazz = Class.forName(GrtPackagePrefix + string);
            Constructor<?> constructor = clazz.getConstructor(Object.class);
            GrtObject grtObject = (GrtObject)constructor.newInstance(object);
            return grtObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GrtMessage addMsg(String string) {
        GrtMessage grtMessage = new GrtMessage(string, 0);
        this.msgs.add(grtMessage);
        return grtMessage;
    }

    public GrtMessage addProgress(String string, int n) {
        GrtMessage grtMessage = new GrtMessage(string, 2, n);
        this.msgs.add(grtMessage);
        return grtMessage;
    }

    public GrtMessage addErr(String string) {
        GrtMessage grtMessage = new GrtMessage(string, 1);
        this.msgs.add(grtMessage);
        return grtMessage;
    }

    public void addMsgDetail(String string) {
        if (this.msgs.size() > 0) {
            GrtMessage grtMessage = (GrtMessage)this.msgs.get(this.msgs.size() - 1);
            this.addMsgDetail(grtMessage, string);
        }
    }

    public void addMsgDetail(GrtMessage grtMessage, String string) {
        grtMessage.addMessageDetail(string);
    }

    public Vector getMessages() {
        return this.msgs;
    }

    public int flushMessages() {
        int n = 0;
        if (this.msgs.size() > 0 && this.callback != null) {
            GrtList grtList = new GrtList("GrtMessage");
            for (int i = 0; i < this.msgs.size(); ++i) {
                grtList.addObject(this.msgs.get(i));
            }
            this.msgs.clear();
            this.getCallback().processMessages(this.getMyxGrtPointer(), grtList.getGrtXml(new StringBuffer()).toString());
            n = this.getCallback().processStatusQuery(this.getMyxGrtPointer());
        }
        return n;
    }

    public static int getValueTypeFromString(String string) {
        if (string.compareTo("int") == 0) {
            return 1;
        }
        if (string.compareTo("real") == 0) {
            return 2;
        }
        if (string.compareTo("string") == 0) {
            return 3;
        }
        if (string.compareTo("list") == 0) {
            return 4;
        }
        if (string.compareTo("dict") == 0) {
            return 5;
        }
        return -1;
    }

    public static StringBuffer prepareGrtXmlHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\"?>\n<data>\n");
        if (string != null && !string.equals("")) {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public static StringBuffer prepareGrtXmlHeader() {
        return Grt.prepareGrtXmlHeader(null);
    }

    protected static StringBuffer prepareGrtXmlFooter(StringBuffer stringBuffer) {
        stringBuffer.append("</data>\n");
        return stringBuffer;
    }

    public static String prepareGrtXml(StringBuffer stringBuffer) {
        return Grt.prepareGrtXmlFooter(stringBuffer).toString();
    }

    private static boolean checkSameClass(Class clazz, Class clazz2) {
        String string = clazz.getName();
        String string2 = clazz2.getName();
        if (string.equals("int")) {
            string = "java.lang.Integer";
        }
        if (string2.equals("int")) {
            string2 = "java.lang.Integer";
        }
        return string.equals(string2);
    }

    private static boolean assignGrtListToGrtObject(GrtObject grtObject, Method method, GrtList grtList, Class clazz) {
        try {
            Constructor constructor = clazz.getConstructor(GrtObject.class);
            GrtList grtList2 = (GrtList)constructor.newInstance(grtObject);
            Class<?> clazz2 = Class.forName(GrtPackagePrefix + grtList2.getContentStructName());
            Class<?> clazz3 = Class.forName(GrtPackagePrefix + grtList.getContentStructName());
            if (clazz2.isAssignableFrom(clazz3)) {
                for (int i = 0; i < grtList.size(); ++i) {
                    grtList2.addObject(grtList.getObject(i));
                }
                method.invoke((Object)grtObject, grtList2);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static Object getDictFromGrtXmlNode(Node node, Object object) {
        String string = ((Element)node).getAttribute("struct-name");
        String string2 = ((Element)node).getAttribute("content-type");
        String string3 = ((Element)node).getAttribute("content-struct-name");
        String string4 = ((Element)node).getAttribute("global-object-path");
        if (string != null && string != "") {
            try {
                GrtObject grtObject;
                Object object2;
                Class<?> clazz = Class.forName(GrtPackagePrefix + string);
                if (string4.equals("")) {
                    object2 = clazz.getConstructor(Object.class);
                    grtObject = (GrtObject)((Constructor)object2).newInstance(new Object[]{null});
                } else {
                    object2 = clazz.getConstructor(String.class);
                    grtObject = (GrtObject)((Constructor)object2).newInstance(string4);
                }
                object2 = node.getChildNodes();
                block2: for (int i = 0; i < object2.getLength(); ++i) {
                    Object object3;
                    Node node2 = object2.item(i);
                    if (node2.getNodeType() != 1 || !((Element)node2).getTagName().equals("value") || (object3 = Grt.getObjectsFromGrtXmlNode(node2, grtObject)) == null) continue;
                    String string5 = ((Element)node2).getAttribute("key");
                    String string6 = ((Element)node2).getAttribute("option");
                    String string7 = ((Element)node2).getAttribute("type");
                    if (string5.length() == 0) continue;
                    string5 = string5.length() == 1 ? string5.toUpperCase() : Character.toUpperCase(string5.charAt(0)) + string5.substring(1);
                    string5 = "set" + string5;
                    if (string6 != null && string6.equals("ref") && !string7.equalsIgnoreCase("list")) {
                        string5 = string5 + "ById";
                    }
                    Method[] methodArray = clazz.getMethods();
                    for (int j = 0; j < methodArray.length; ++j) {
                        if (!methodArray[j].getName().equals(string5) || methodArray[j].getParameterTypes().length <= 0) continue;
                        if (GrtList.class.isAssignableFrom(object3.getClass()) && GrtList.class.isAssignableFrom(methodArray[j].getParameterTypes()[0]) && Grt.assignGrtListToGrtObject(grtObject, methodArray[j], (GrtList)object3, methodArray[j].getParameterTypes()[0])) continue block2;
                        if (!Grt.checkSameClass(methodArray[j].getParameterTypes()[0], object3.getClass())) continue;
                        methodArray[j].invoke((Object)grtObject, object3);
                        continue block2;
                    }
                }
                return grtObject;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        GrtHashMap grtHashMap = string2.equals("string") ? new GrtStringHashMap(string4) : new GrtHashMap(string3, string4);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object4;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1 || !((Element)node3).getTagName().equals("value") || (object4 = Grt.getObjectsFromGrtXmlNode(node3, grtHashMap)) == null) continue;
            grtHashMap.addObject(((Element)node3).getAttribute("key"), object4);
        }
        return grtHashMap;
    }

    private static Object getListFromGrtXmlNode(Node node, Object object) {
        Object object2;
        GrtList grtList = null;
        String string = ((Element)node).getAttribute("content-type");
        String string2 = ((Element)node).getAttribute("content-struct-name");
        String string3 = ((Element)node).getAttribute("global-object-path");
        int n = Grt.getValueTypeFromString(string);
        boolean bl = false;
        if (string3 != null && !string3.equals("") && n == 3 && string2 != null && string2 != "") {
            n = 5;
        } else if ((string3 == null || string3.equals("")) && n == 3 && string2 != null && string2 != "") {
            n = 5;
            bl = true;
        }
        if (n == 5 && string2 != null && string2 != "") {
            try {
                Constructor constructor;
                object2 = Class.forName(GrtPackagePrefix + string2 + "List");
                if (string3.equals("")) {
                    constructor = ((Class)object2).getConstructor(String.class);
                    grtList = (GrtList)constructor.newInstance(string2);
                }
                constructor = ((Class)object2).getConstructor(String.class, String.class);
                grtList = (GrtList)constructor.newInstance(string2, string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        } else if (string.equals("string")) {
            grtList = new GrtStringList(string3);
        } else {
            grtList = new GrtList(string2, string3);
            grtList.setContentType(string);
        }
        object2 = node.getChildNodes();
        for (int i = 0; i < object2.getLength(); ++i) {
            Node node2 = object2.item(i);
            if (node2.getNodeType() != 1 || !((Element)node2).getTagName().equals("value")) continue;
            Object object3 = Grt.getObjectsFromGrtXmlNode(node2, grtList);
            if (bl) {
                object3 = Grt.getInstance().getObjectByRefId((String)object3);
            }
            if (object3 == null) continue;
            grtList.addObject(object3);
        }
        if (grtList != null) {
            grtList.setOwner(object);
        }
        return grtList;
    }

    private static Object getObjectsFromGrtXmlNode(Node node, Object object) {
        int n = Grt.getValueTypeFromString(((Element)node).getAttribute("type"));
        if (n == 3) {
            for (Node node2 = node.getChildNodes().item(0); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 3) continue;
                String string = ((Text)node2).getData();
                if (string.startsWith("global::")) {
                    return Grt.getInstance().getGrtGlobalAsObject(string.substring(8));
                }
                return string;
            }
            return "";
        }
        if (n == 1) {
            Node node3 = node.getChildNodes().item(0);
            do {
                if (node3.getNodeType() != 3) continue;
                return new Integer(Integer.parseInt(((Text)node3).getData()));
            } while ((node3 = node3.getNextSibling()) != null);
            return new Integer(0);
        }
        if (n == 2) {
            Node node4 = node.getChildNodes().item(0);
            do {
                if (node4.getNodeType() != 3) continue;
                return new Double(Double.parseDouble(((Text)node4).getData()));
            } while ((node4 = node4.getNextSibling()) != null);
            return new Double(0.0);
        }
        if (n == 5) {
            return Grt.getDictFromGrtXmlNode(node, object);
        }
        if (n == 4) {
            return Grt.getListFromGrtXmlNode(node, object);
        }
        return null;
    }

    public static Object getObjectsFromGrtXml(String string) {
        ByteArrayInputStream byteArrayInputStream;
        Object object = null;
        if (string == null) {
            return null;
        }
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("value")) continue;
                object = Grt.getObjectsFromGrtXmlNode(node, null);
                break;
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public static StringBuffer getObjectAsXml(StringBuffer stringBuffer, Object object) {
        return Grt.getObjectAsXml(stringBuffer, object, "");
    }

    public static StringBuffer getObjectAsXml(StringBuffer stringBuffer, Object object, String string) {
        if (object != null) {
            if (object instanceof GrtXml) {
                ((GrtXml)object).getGrtXml(stringBuffer, string);
            } else if (object.getClass() == String.class) {
                stringBuffer.append("<value type=\"string\"" + string + ">" + Grt.escapeStringForXml(object.toString()) + "</value>\n");
            } else if (object.getClass() == Integer.class) {
                stringBuffer.append("<value type=\"int\"" + string + ">" + object.toString() + "</value>\n");
            } else if (object.getClass() == Double.class) {
                stringBuffer.append("<value type=\"real\"" + string + ">" + object.toString() + "</value>\n");
            }
        }
        return stringBuffer;
    }

    public static String escapeStringForXml(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("\u0000", "");
    }

    public static String getModuleInfoXml(Class clazz, String string) {
        StringBuffer stringBuffer = Grt.prepareGrtXmlHeader("<value type=\"dict\">\n  <value key=\"name\" type=\"string\">" + clazz.getName() + "</value>" + "  <value key=\"functions\" type=\"list\" content-type=\"string\">\n");
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isStatic(methodArray[i].getModifiers()) || methodArray[i].getName().equals("getModuleInfo")) continue;
            stringBuffer.append("    <value type=\"string\">" + methodArray[i].getName() + ":(");
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                if (classArray[j].getName().equals("int")) {
                    stringBuffer.append("int;");
                }
                if (classArray[j].getName().equals("double")) {
                    stringBuffer.append("double;");
                    continue;
                }
                stringBuffer.append("L" + classArray[j].getName().replace('.', '/') + ";");
            }
            stringBuffer.append("):</value>\n");
        }
        stringBuffer.append("</value>\n");
        if (!string.equals("")) {
            stringBuffer.append("  <value key=\"extends\" type=\"string\">" + string + "</value>\n");
        }
        stringBuffer.append("</value>\n");
        return Grt.prepareGrtXmlFooter(stringBuffer).toString();
    }

    public static String moduleFunctionError(String string) {
        GrtHashMap grtHashMap = new GrtHashMap();
        grtHashMap.addObject("error", string);
        return Grt.prepareGrtXmlFooter(Grt.getObjectAsXml(Grt.prepareGrtXmlHeader(), grtHashMap)).toString();
    }

    public static String moduleFunctionError(Throwable throwable) {
        GrtHashMap grtHashMap = new GrtHashMap();
        String string = throwable.getMessage();
        if (string == null && (string = (throwable = throwable.getCause()).getMessage()) == null) {
            string = throwable.getClass().getName();
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = "";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string2 = string2 + stackTraceElementArray[i].toString() + "\n";
        }
        grtHashMap.addObject("error", string);
        grtHashMap.addObject("detail", string2);
        return Grt.prepareGrtXmlFooter(Grt.getObjectAsXml(Grt.prepareGrtXmlHeader(), grtHashMap)).toString();
    }

    public static String callModuleFunction(Class clazz, String string, String string2, String string3) {
        GrtXml grtXml;
        Object object;
        Object object2;
        int n;
        if (string2.startsWith("(") && (n = string2.indexOf(41)) >= 0) {
            string2 = string2.substring(1, n);
        }
        Class[] classArray = null;
        if (!string2.equals("") && !string2.equals("()")) {
            object2 = string2.split(";");
            classArray = new Class[((String[])object2).length];
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = ((String)object2[i]).substring(1).replace('/', '.');
                try {
                    classArray[i] = Class.forName((String)object);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Grt.moduleFunctionError(classNotFoundException.getMessage());
                }
            }
        }
        object2 = null;
        try {
            object2 = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return Grt.moduleFunctionError(exception);
        }
        Object[] objectArray = null;
        if (classArray != null) {
            object = Grt.getObjectsFromGrtXml(string3);
            if (classArray.length == 1 && !(object instanceof GrtList)) {
                objectArray = new Object[]{object};
            } else if (object instanceof GrtList) {
                grtXml = (GrtList)object;
                if (classArray.length != ((GrtList)grtXml).size()) {
                    return Grt.moduleFunctionError("The number of submitted parameters does not match the number of parameters of the java function.");
                }
                objectArray = new Object[((GrtList)grtXml).size()];
                for (int i = 0; i < ((GrtList)grtXml).size(); ++i) {
                    objectArray[i] = ((GrtList)grtXml).getObject(i);
                }
            } else {
                return Grt.moduleFunctionError("If the function has more than one parameter these parameters have to be passed in a list.");
            }
        }
        object = null;
        try {
            object = ((Method)object2).invoke(null, objectArray);
        }
        catch (Exception exception) {
            return Grt.moduleFunctionError(exception);
        }
        grtXml = new GrtHashMap();
        ((GrtHashMap)grtXml).addObject("value", object);
        String string4 = Grt.prepareGrtXmlFooter(Grt.getObjectAsXml(Grt.prepareGrtXmlHeader(), grtXml)).toString();
        if (Grt.getInstance().doJava2GrtXmlLogging == 1) {
            try {
                boolean bl = false;
                File file = new File(Grt.getInstance().getApplicationDataPath() + "log");
                bl = file.exists() && file.isDirectory() ? true : file.mkdir();
                if (bl) {
                    FileWriter fileWriter = new FileWriter(Grt.getInstance().getApplicationDataPath() + "log/Java2Grt_" + clazz.getName() + "." + string + ".xml");
                    fileWriter.write(string4);
                    fileWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Grt.getInstance().clearObjectCache();
        Grt.getInstance().flushMessages();
        return string4;
    }

    public Object callGrtFunction(String string, String string2, Object object) throws RuntimeException {
        String string3 = Grt.prepareGrtXmlFooter(Grt.getObjectAsXml(Grt.prepareGrtXmlHeader(), object)).toString();
        String string4 = this.getCallback().callGrtFunction(this.getMyxGrtPointer(), string, string2, string3);
        Object object2 = Grt.getObjectsFromGrtXml(string4);
        if (object2 instanceof GrtHashMap) {
            Object object3 = ((GrtHashMap)object2).getObject("value");
            if (object3 != null) {
                return object3;
            }
            object3 = ((GrtHashMap)object2).getObject("error");
            String string5 = object3 instanceof String ? "The function " + string + ":" + string2 + "() " + "returned the following error:\n" + (String)object3 : "The function " + string + ":" + string2 + "() " + "returned an error.";
            throw new RuntimeException(string5);
        }
        return null;
    }

    public GrtObject getGrtGlobalAsGrtObject(String string) {
        return (GrtObject)this.getGrtGlobalAsObject(string);
    }

    public Object getGrtGlobalAsObject(String string) {
        return this.getCallback().getGrtGlobalAsObject(this.getMyxGrtPointer(), string);
    }

    public String getGrtGlobalAsString(String string) {
        return this.getCallback().getGrtGlobalAsString(this.getMyxGrtPointer(), string);
    }

    public int getGrtGlobalAsInt(String string) {
        return this.getCallback().getGrtGlobalAsInt(this.getMyxGrtPointer(), string);
    }

    public double getGrtGlobalAsReal(String string) {
        return this.getCallback().getGrtGlobalAsReal(this.getMyxGrtPointer(), string);
    }

    public void setGrtGlobalFromObject(String string, Object object) {
        this.getCallback().setGrtGlobalFromObject(this.getMyxGrtPointer(), string, object);
    }

    public void setGrtGlobalFromString(String string, String string2) {
        this.getCallback().setGrtGlobalFromString(this.getMyxGrtPointer(), string, string2);
    }

    public void setGrtGlobalFromInt(String string, int n) {
        this.getCallback().setGrtGlobalFromInt(this.getMyxGrtPointer(), string, n);
    }

    public void setGrtGlobalFromReal(String string, double d) {
        this.getCallback().setGrtGlobalFromReal(this.getMyxGrtPointer(), string, d);
    }

    public int getGrtGlobalListSize(String string) {
        return this.getCallback().getGrtGlobalListSize(this.getMyxGrtPointer(), string);
    }

    public Object getGrtGlobalListItem(String string, int n) {
        return this.getCallback().getGrtGlobalListItem(this.getMyxGrtPointer(), string, n);
    }

    public void addGrtGlobalListItem(String string, Object object) {
        this.getCallback().addGrtGlobalListItem(this.getMyxGrtPointer(), string, object);
    }

    public void removeGrtGlobalListItem(String string, int n) {
        this.getCallback().removeGrtGlobalListItem(this.getMyxGrtPointer(), string, n);
    }

    public Object getGrtGlobalDictItem(String string, String string2) {
        return this.getCallback().getGrtGlobalDictItem(this.getMyxGrtPointer(), string, string2);
    }

    public void addGrtGlobalDictItem(String string, String string2, Object object) {
        this.getCallback().addGrtGlobalDictItem(this.getMyxGrtPointer(), string, string2, object);
    }

    public void removeGrtGlobalDictItem(String string, String string2) {
        this.getCallback().removeGrtGlobalDictItem(this.getMyxGrtPointer(), string, string2);
    }

    public int getGrtGlobalDictKeyCount(String string) {
        return this.getCallback().getGrtGlobalDictKeyCount(this.getMyxGrtPointer(), string);
    }

    public String getGrtGlobalDictKey(String string, int n) {
        return this.getCallback().getGrtGlobalDictKey(this.getMyxGrtPointer(), string, n);
    }

    public void setBridgeDataObject(String string, Object object) {
        this.getCallback().setBridgeDataObject(this.getMyxGrtPointer(), string, object);
    }

    public Object getBridgeDataObject(String string) {
        return this.getCallback().getBridgeDataObject(this.getMyxGrtPointer(), string);
    }
}

