/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.printf;

import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.printf.FormatException;
import com.sap.dbtech.util.printf.Formatter;
import com.sap.dbtech.util.printf.OArrayEnumeration;
import com.sap.dbtech.util.printf.PrintfArgumentMismatch;

abstract class DataFormatter
extends Formatter {
    protected char kind;
    protected int width = -1;
    protected int precision = -1;
    protected boolean alignRight = false;
    protected char padChar = (char)32;
    protected static final int defaultValue_C = -1;
    protected static final int dynamicValue_C = -2;

    protected DataFormatter(String string) throws FormatException {
        this.parseFormatString(string);
    }

    String format(OArrayEnumeration oArrayEnumeration) throws PrintfArgumentMismatch {
        Object object;
        int n = this.width;
        int n2 = this.precision;
        try {
            Number number;
            if (this.width == -2) {
                number = (Number)oArrayEnumeration.nextElement();
                n = number.intValue();
            }
            if (this.precision == -2) {
                number = (Number)oArrayEnumeration.nextElement();
                n2 = number.intValue();
            }
            object = oArrayEnumeration.nextElement();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PrintfArgumentMismatch(MessageTranslator.translate("error.format.toofewargs"));
        }
        String string = this.formatObject(object, this.kind, n, n2, this.alignRight, this.padChar);
        return string;
    }

    protected abstract String formatObject(Object var1, int var2, int var3, int var4, boolean var5, char var6) throws PrintfArgumentMismatch;

    protected String formatString(String string, int n, int n2, int n3, boolean bl, char c) {
        if (n2 > string.length()) {
            string = bl ? StringUtil.padLeft(string, n2, c) : StringUtil.padRight(string, n2, c);
        } else if (n3 >= 0 && n3 < string.length()) {
            string = string.substring(0, n3);
        }
        return string;
    }

    private void parseFormatString(String string) throws FormatException {
        int n;
        boolean bl = true;
        int n2 = 1;
        int n3 = 0;
        if (string.charAt(0) != '%') {
            throw new FormatException(MessageTranslator.translate("error.format.percent"));
        }
        block7: while (bl) {
            n2 = string.charAt(++n3);
            switch (n2) {
                case 45: {
                    this.alignRight = true;
                    continue block7;
                }
                case 43: {
                    continue block7;
                }
                case 32: {
                    continue block7;
                }
                case 35: {
                    continue block7;
                }
                case 48: {
                    this.padChar = (char)48;
                    continue block7;
                }
            }
            bl = false;
        }
        if (n2 == 42) {
            this.width = -2;
            n2 = string.charAt(++n3);
        } else {
            n = 0;
            while (48 <= n2 && n2 <= 57) {
                n *= 10;
                n += n2 - 48;
                n2 = string.charAt(++n3);
            }
            if (n != 0) {
                this.width = n;
            }
        }
        if (n2 == 46) {
            if ((n2 = (int)string.charAt(++n3)) == 42) {
                this.width = -2;
                n2 = string.charAt(++n3);
            } else {
                n = 0;
                while (48 <= n2 && n2 <= 57) {
                    n *= 10;
                    n += n2 - 48;
                    n2 = string.charAt(++n3);
                }
                if (n != 0) {
                    this.precision = n;
                }
            }
        }
        this.kind = (char)n2;
    }
}

