/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.io.UnsupportedEncodingException;

public class UnicodeUtil {
    public static final int CharWidthC = 2;
    private static boolean encodingAvailable = true;

    private UnicodeUtil() {
    }

    public static char[] bigUnicode2Chars(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 / 2];
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = byArray[n + 2 * i];
            if (n5 < 0) {
                n5 += 256;
            }
            if ((n4 = byArray[n + (2 * i + 1)]) < 0) {
                n4 += 256;
            }
            int n6 = (n5 << 8) + n4;
            cArray[i] = (char)n6;
        }
        return cArray;
    }

    public static char[] bigUnicode2Chars(byte[] byArray) {
        return UnicodeUtil.bigUnicode2Chars(byArray, 0, byArray.length);
    }

    public static String bigUnicode2String(byte[] byArray) {
        String string;
        if (encodingAvailable) {
            try {
                string = new String(byArray, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(UnicodeUtil.bigUnicode2Chars(byArray));
                encodingAvailable = false;
            }
        } else {
            string = new String(UnicodeUtil.bigUnicode2Chars(byArray));
        }
        return string;
    }

    public static byte[] char2BigUnicode(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 2];
        UnicodeUtil.charIntoBytes(cArray, byArray, 0);
        return byArray;
    }

    public static byte[] bytes2BigUnicode(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byArray2[i * 2 + 1] = byArray[i];
        }
        return byArray2;
    }

    public static void charIntoBytes(char[] cArray, byte[] byArray, int n) {
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            byArray[i * 2 + n] = (byte)(c / 256);
            byArray[i * 2 + n + 1] = (byte)(c % 256);
        }
    }
}

