/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt.db;

import com.mysql.grt.Grt;
import com.mysql.grt.GrtObject;
import com.mysql.grt.db.ColumnList;
import com.mysql.grt.db.DatabaseObject;
import com.mysql.grt.db.ForeignKeyList;
import com.mysql.grt.db.Index;
import com.mysql.grt.db.IndexList;
import com.mysql.grt.db.StructuredDatatype;
import com.mysql.grt.db.TableData;
import com.mysql.grt.db.TableDataGlobal;
import com.mysql.grt.db.TableDataLocal;
import com.mysql.grt.db.TriggerList;

public class Table
extends DatabaseObject {
    protected Table() {
    }

    public Table(Object object) {
        if (object == null || object instanceof GrtObject) {
            this.data = new TableDataLocal(this);
            this.data.setOwner((GrtObject)object);
            Grt.getInstance().addToObjectCache(this);
        } else if (object instanceof String) {
            this.data = new TableDataGlobal((String)object);
        }
    }

    public int getIsTemporary() {
        return ((TableData)this.data).getIsTemporary();
    }

    public int setIsTemporary(int n) {
        ((TableData)this.data).setIsTemporary(n);
        return this.getIsTemporary();
    }

    public int getIsSystem() {
        return ((TableData)this.data).getIsSystem();
    }

    public int setIsSystem(int n) {
        ((TableData)this.data).setIsSystem(n);
        return this.getIsSystem();
    }

    public String getTemporaryScope() {
        return ((TableData)this.data).getTemporaryScope();
    }

    public String setTemporaryScope(String string) {
        ((TableData)this.data).setTemporaryScope(string);
        return this.getTemporaryScope();
    }

    public StructuredDatatype getTemplate() {
        return ((TableData)this.data).getTemplate();
    }

    public StructuredDatatype setTemplate(StructuredDatatype structuredDatatype) {
        ((TableData)this.data).setTemplate(structuredDatatype);
        return this.getTemplate();
    }

    public ColumnList getColumns() {
        return ((TableData)this.data).getColumns();
    }

    public ColumnList setColumns(ColumnList columnList) {
        ((TableData)this.data).setColumns(columnList);
        return this.getColumns();
    }

    public IndexList getIndices() {
        return ((TableData)this.data).getIndices();
    }

    public IndexList setIndices(IndexList indexList) {
        ((TableData)this.data).setIndices(indexList);
        return this.getIndices();
    }

    public ForeignKeyList getForeignKeys() {
        return ((TableData)this.data).getForeignKeys();
    }

    public ForeignKeyList setForeignKeys(ForeignKeyList foreignKeyList) {
        ((TableData)this.data).setForeignKeys(foreignKeyList);
        return this.getForeignKeys();
    }

    public TriggerList getTriggers() {
        return ((TableData)this.data).getTriggers();
    }

    public TriggerList setTriggers(TriggerList triggerList) {
        ((TableData)this.data).setTriggers(triggerList);
        return this.getTriggers();
    }

    public Index getPrimaryKey() {
        return ((TableData)this.data).getPrimaryKey();
    }

    public Index setPrimaryKey(Index index) {
        ((TableData)this.data).setPrimaryKey(index);
        return this.getPrimaryKey();
    }

    public String getPrimaryKeyById() {
        return ((TableData)this.data).getPrimaryKeyById();
    }

    public void setPrimaryKeyById(String string) {
        ((TableData)this.data).setPrimaryKeyById(string);
    }

    public StringBuffer getGrtXmlMembers(StringBuffer stringBuffer) {
        super.getGrtXmlMembers(stringBuffer);
        stringBuffer.append("<value type=\"int\" key=\"isTemporary\">" + Integer.toString(this.getIsTemporary()) + "</value>\n");
        stringBuffer.append("<value type=\"int\" key=\"isSystem\">" + Integer.toString(this.getIsSystem()) + "</value>\n");
        if (this.getTemporaryScope() != null) {
            stringBuffer.append("<value type=\"string\" key=\"temporaryScope\">" + Grt.escapeStringForXml(this.getTemporaryScope()) + "</value>\n");
        }
        if (this.getColumns() != null) {
            this.getColumns().getGrtXml(stringBuffer, " key=\"columns\"");
        }
        if (this.getIndices() != null) {
            this.getIndices().getGrtXml(stringBuffer, " key=\"indices\"");
        }
        if (this.getForeignKeys() != null) {
            this.getForeignKeys().getGrtXml(stringBuffer, " key=\"foreignKeys\"");
        }
        if (this.getTriggers() != null) {
            this.getTriggers().getGrtXml(stringBuffer, " key=\"triggers\"");
        }
        if (this.getTemplate() != null) {
            this.getTemplate().getGrtXml(stringBuffer, " key=\"template\"");
        }
        if (this.getPrimaryKey() != null) {
            stringBuffer.append("<value type=\"string\" option=\"ref\" key=\"primaryKey\">" + this.getPrimaryKeyById() + "</value>\n");
        }
        return stringBuffer;
    }
}

