/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt;

import com.mysql.grt.Grt;
import com.mysql.grt.GrtObject;
import com.mysql.grt.GrtXml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrtList
implements GrtXml {
    protected boolean isGlobalObject = false;
    protected String globalObjectPath;
    protected List list;
    protected Map nameLookupMap;
    private String contentType = "";
    private String contentStructName = "";
    private Object owner;

    public GrtList() {
    }

    public GrtList(GrtObject grtObject) {
        this();
        this.owner = grtObject;
    }

    public GrtList(String string) {
        this();
        if (!string.equals("")) {
            this.contentType = "dict";
            this.contentStructName = string;
        }
    }

    public GrtList(String string, String string2) {
        this(string);
        this.isGlobalObject = !string2.equals("");
        this.globalObjectPath = string2;
    }

    protected boolean getIsGlobalObject() {
        return this.isGlobalObject;
    }

    protected String getGlobalObjectPath() {
        return this.globalObjectPath;
    }

    public int size() {
        if (this.getIsGlobalObject()) {
            return Grt.getInstance().getGrtGlobalListSize(this.getGlobalObjectPath());
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        return this.list.size();
    }

    public Object addObject(Object object) {
        if (this.getIsGlobalObject()) {
            Grt.getInstance().addGrtGlobalListItem(this.getGlobalObjectPath(), object);
        } else {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.list.add(object);
        }
        return this.getObject(this.size() - 1);
    }

    public Object getObject(int n) {
        if (this.getIsGlobalObject()) {
            Object object = Grt.getInstance().getGrtGlobalListItem(this.getGlobalObjectPath(), n);
            if (this.contentType == "dict" && object.getClass() == String.class) {
                object = Grt.getInstance().getObjectByRefId((String)object);
            }
            return object;
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        return this.list.get(n);
    }

    public GrtList remove(int n) {
        if (this.getIsGlobalObject()) {
            Grt.getInstance().removeGrtGlobalListItem(this.getGlobalObjectPath(), n);
        } else {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.list.remove(n);
        }
        return this;
    }

    public int getIndexOfName(String string) {
        Integer n;
        if (this.nameLookupMap == null) {
            this.nameLookupMap = new HashMap();
            for (int i = 0; i < this.size(); ++i) {
                String string2;
                Object object = this.getObject(i);
                if (!(object instanceof GrtObject) || (string2 = ((GrtObject)object).getName()) == null) continue;
                this.nameLookupMap.put(string2, new Integer(i));
            }
        }
        if ((n = (Integer)this.nameLookupMap.get(string)) != null) {
            return n;
        }
        return -1;
    }

    public boolean contains(Object object) {
        if (this.getIsGlobalObject()) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.getObject(i).equals(object)) continue;
                return true;
            }
            return false;
        }
        if (this.list == null) {
            this.list = new ArrayList();
        }
        return this.list.contains(object);
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContentStructName() {
        return this.contentStructName;
    }

    public void setContentStructName(String string) {
        this.contentStructName = string;
    }

    public StringBuffer getGrtXml(StringBuffer stringBuffer) {
        return this.getGrtXml(stringBuffer, "");
    }

    public StringBuffer getGrtXml(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<value type=\"list\"");
        if (!this.getContentType().equals("")) {
            stringBuffer.append(" content-type=\"" + this.getContentType() + "\"");
        }
        if (!this.getContentStructName().equals("")) {
            stringBuffer.append(" content-struct-name=\"" + this.getContentStructName() + "\"");
        }
        if (this.getIsGlobalObject()) {
            stringBuffer.append(" global-object-path=\"" + Grt.escapeStringForXml(this.getGlobalObjectPath()) + "\"");
        }
        stringBuffer.append(string + ">\n");
        for (int i = 0; i < this.size(); ++i) {
            Grt.getObjectAsXml(stringBuffer, this.getObject(i), "");
        }
        stringBuffer.append("</value>\n");
        return stringBuffer;
    }

    public StringBuffer getGrtRefXml(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<value type=\"list\" option=\"ref\"");
        if (this.getContentType() != "") {
            stringBuffer.append(" content-type=\"string\"");
        }
        if (this.getContentStructName() != "") {
            stringBuffer.append(" content-struct-name=\"" + this.getContentStructName() + "\"");
        }
        stringBuffer.append(string + ">\n");
        for (int i = 0; i < this.size(); ++i) {
            Object object = this.getObject(i);
            if (!GrtObject.class.isAssignableFrom(object.getClass())) continue;
            stringBuffer.append("<value type=\"string\" option=\"ref\">" + Grt.escapeStringForXml(((GrtObject)object).get_id()) + "</value>\n");
        }
        stringBuffer.append("</value>\n");
        return stringBuffer;
    }
}

