/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt;

import com.mysql.grt.Grt;
import com.mysql.grt.GrtObject;
import com.mysql.grt.GrtXml;
import java.util.HashMap;

public class GrtHashMap
implements GrtXml {
    protected boolean isGlobalObject = false;
    protected String globalObjectPath;
    protected HashMap map;
    private String contentType = "";
    private String contentStructName = "";

    public GrtHashMap() {
    }

    public GrtHashMap(GrtObject grtObject) {
        this();
    }

    public GrtHashMap(String string) {
        this();
        if (!string.equals("")) {
            this.contentType = "dict";
            this.contentStructName = string;
        }
    }

    public GrtHashMap(String string, String string2) {
        this(string);
        this.isGlobalObject = !string2.equals("");
        this.globalObjectPath = string2;
    }

    protected boolean getIsGlobalObject() {
        return this.isGlobalObject;
    }

    protected String getGlobalObjectPath() {
        return this.globalObjectPath;
    }

    public Object addObject(String string, Object object) {
        if (this.getIsGlobalObject()) {
            Grt.getInstance().addGrtGlobalDictItem(this.getGlobalObjectPath(), string, object);
        } else {
            if (this.map == null) {
                this.map = new HashMap();
            }
            this.map.put(string, object);
        }
        return this.getObject(string);
    }

    public Object getObject(String string) {
        if (this.getIsGlobalObject()) {
            return Grt.getInstance().getGrtGlobalDictItem(this.getGlobalObjectPath(), string);
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.get(string);
    }

    public void remove(String string) {
        if (this.getIsGlobalObject()) {
            Grt.getInstance().removeGrtGlobalDictItem(this.getGlobalObjectPath(), string);
        } else {
            if (this.map == null) {
                this.map = new HashMap();
            }
            this.map.remove(string);
        }
    }

    public String[] getKeys() {
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (this.getIsGlobalObject()) {
            this.map.clear();
            int n = Grt.getInstance().getGrtGlobalDictKeyCount(this.getGlobalObjectPath());
            for (int i = 0; i < n; ++i) {
                String string = Grt.getInstance().getGrtGlobalDictKey(this.getGlobalObjectPath(), i);
                Object object = this.getObject(string);
                this.map.put(string, object);
            }
        }
        return this.map.keySet().toArray(new String[this.map.keySet().size()]);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContentStructName() {
        return this.contentStructName;
    }

    public void setContentStructName(String string) {
        this.contentStructName = string;
    }

    public StringBuffer getGrtXml(StringBuffer stringBuffer) {
        return this.getGrtXml(stringBuffer, "");
    }

    public StringBuffer getGrtXml(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<value type=\"dict\"" + string);
        if (!this.getContentType().equals("")) {
            stringBuffer.append(" content-type=\"" + this.getContentType() + "\"");
        }
        if (!this.getContentStructName().equals("")) {
            stringBuffer.append(" content-struct-name=\"" + this.getContentStructName() + "\"");
        }
        if (this.getIsGlobalObject()) {
            stringBuffer.append(" global-object-path=\"" + Grt.escapeStringForXml(this.getGlobalObjectPath()) + "\"");
        }
        stringBuffer.append(">\n");
        if (this.map != null) {
            for (String string2 : this.map.keySet()) {
                Grt.getObjectAsXml(stringBuffer, this.getObject(string2), " key=\"" + string2 + "\"");
            }
        }
        stringBuffer.append("</value>\n");
        return stringBuffer;
    }
}

