/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.grt;

import com.mysql.grt.Grt;
import com.mysql.grt.GrtCallback;
import com.mysql.grt.GrtHashMap;
import com.mysql.grt.GrtList;
import com.mysql.grt.GrtObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class GrtCallbackSnapshot
implements GrtCallback {
    private Map objPathCache = new HashMap();
    private Map objIdCache = new HashMap();
    private Object rootValue;

    public void setApplicationPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            bufferedReader.close();
            fileInputStream.close();
            this.rootValue = Grt.getObjectsFromGrtXml(stringBuffer.toString());
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string + ".txt"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "utf8"));
            this.buildObjCaches(bufferedWriter, this.rootValue, "");
            bufferedWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("The file " + string + " cannot be found.");
            this.rootValue = null;
        }
    }

    private void buildObjCaches(BufferedWriter bufferedWriter, Object object, String string) throws IOException {
        bufferedWriter.write(string + " - ");
        if (object instanceof GrtObject) {
            bufferedWriter.write(((GrtObject)object).getName() + "\r\n");
            Class<?> clazz = object.getClass();
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                try {
                    if (!methodArray[i].getName().startsWith("get") || methodArray[i].getName().equals("getGrtXml") || methodArray[i].getName().equals("getGrtXmlMembers")) continue;
                    String string2 = string + "/" + methodArray[i].getName().substring(3, 4).toLowerCase() + methodArray[i].getName().substring(4);
                    Object object2 = methodArray[i].invoke(object, null);
                    if (object2 == null) continue;
                    this.buildObjCachesField(bufferedWriter, object2, string2);
                    continue;
                }
                catch (Exception exception) {
                    bufferedWriter.write("The following exception occured while adding a value by calling " + ((GrtObject)object).getName() + "." + methodArray[i].getName() + " to the objPathCache (" + exception.getMessage() + ").\r\n");
                }
            }
        } else if (object instanceof GrtList) {
            bufferedWriter.write("List\r\n");
            GrtList grtList = (GrtList)object;
            for (int i = 0; i < grtList.size(); ++i) {
                String string3 = string + "/" + Integer.toString(i);
                Object object3 = grtList.getObject(i);
                this.buildObjCachesField(bufferedWriter, object3, string3);
            }
        } else if (object instanceof GrtHashMap) {
            bufferedWriter.write("Map\r\n");
            GrtHashMap grtHashMap = (GrtHashMap)object;
            String[] stringArray = grtHashMap.getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = string + "/" + stringArray[i];
                Object object4 = grtHashMap.getObject(stringArray[i]);
                this.buildObjCachesField(bufferedWriter, object4, string4);
            }
        } else {
            bufferedWriter.write(object.getClass().getName() + " = " + object.toString() + "\r\n");
        }
    }

    private void buildObjCachesField(BufferedWriter bufferedWriter, Object object, String string) throws IOException {
        this.objPathCache.put(string, object);
        if (object instanceof GrtObject) {
            this.objIdCache.put(((GrtObject)object).get_id(), object);
        }
        this.buildObjCaches(bufferedWriter, object, string);
    }

    public String callGrtFunction(long l, String string, String string2, String string3) {
        return null;
    }

    public Object getGrtGlobalById(long l, String string) {
        return this.objIdCache.get(string);
    }

    public Object getGrtGlobalAsObject(long l, String string) {
        return this.objPathCache.get(string);
    }

    public String getGrtGlobalAsString(long l, String string) {
        return (String)this.getGrtGlobalAsObject(l, string);
    }

    public int getGrtGlobalAsInt(long l, String string) {
        return (Integer)this.getGrtGlobalAsObject(l, string);
    }

    public double getGrtGlobalAsReal(long l, String string) {
        return (Double)this.getGrtGlobalAsObject(l, string);
    }

    public void setGrtGlobalFromObject(long l, String string, Object object) {
    }

    public void setGrtGlobalFromString(long l, String string, String string2) {
    }

    public void setGrtGlobalFromInt(long l, String string, int n) {
    }

    public void setGrtGlobalFromReal(long l, String string, double d) {
    }

    public int getGrtGlobalListSize(long l, String string) {
        GrtList grtList = (GrtList)this.objPathCache.get(string);
        return grtList.size();
    }

    public Object getGrtGlobalListItem(long l, String string, int n) {
        return this.getGrtGlobalAsObject(l, string + "/" + Integer.toString(n));
    }

    public void addGrtGlobalListItem(long l, String string, Object object) {
    }

    public void removeGrtGlobalListItem(long l, String string, int n) {
    }

    public Object getGrtGlobalDictItem(long l, String string, String string2) {
        return this.getGrtGlobalAsObject(l, string + "/" + string2);
    }

    public void addGrtGlobalDictItem(long l, String string, String string2, Object object) {
    }

    public void removeGrtGlobalDictItem(long l, String string, String string2) {
    }

    public void processMessages(long l, String string) {
    }

    public int processStatusQuery(long l) {
        return 0;
    }

    public int getGrtGlobalDictKeyCount(long l, String string) {
        return 0;
    }

    public String getGrtGlobalDictKey(long l, String string, int n) {
        return "";
    }

    public void setBridgeDataObject(long l, String string, Object object) {
    }

    public Object getBridgeDataObject(long l, String string) {
        return null;
    }
}

