﻿DROP DATABASE IF EXISTS db_config;

CREATE DATABASE db_config
    CHARACTER SET 'utf8'
    COLLATE 'utf8_general_ci';

USE db_config;

CREATE TABLE tbl_access_pc (
  access_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  access_db BIGINT(20) NOT NULL DEFAULT '0',
  access_mac VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  access_uid VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  access_pc VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (access_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_activation (
  active_id BIGINT(11) NOT NULL AUTO_INCREMENT,
  active_host VARCHAR(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  active_desc VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  active_sort BIGINT(11) NOT NULL DEFAULT '0',
  active_pro_type BIGINT(11) NOT NULL DEFAULT '0',
  active_license VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  active_serial BIGINT(11) NOT NULL DEFAULT '0',
  active_mac_code VARCHAR(30) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  active_reg_code VARCHAR(30) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  active_feature VARCHAR(30) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  active_expiry DATE NOT NULL DEFAULT '0000-00-00',
  active_last_time DATETIME DEFAULT NULL,
  PRIMARY KEY (active_id)
)ENGINE=MyISAM
AUTO_INCREMENT=2 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_currency (
  cu_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  cu_ucode VARCHAR(3) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_code VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_name VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_name_latin VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL,
  cu_country VARCHAR(50) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_gender BIGINT(20) NOT NULL DEFAULT '0',
  cu_single VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_plural VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_frac_single VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_frac_plural VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cu_fracs_unit INTEGER(3) NOT NULL DEFAULT '0',
  cu_frac_gender BIGINT(20) NOT NULL DEFAULT '0',
  cu_equal DOUBLE(15,5) NOT NULL DEFAULT '0.00000',
  cu_sort BIGINT(20) NOT NULL DEFAULT '0',
  cu_notice VARCHAR(255) COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (cu_id)
)ENGINE=MyISAM
AUTO_INCREMENT=19 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_databases (
  da_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  da_cat_id BIGINT(20) NOT NULL DEFAULT '0',
  da_sort BIGINT(20) NOT NULL DEFAULT '0',
  da_name VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  da_title VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  da_sysdate TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  da_program_type INTEGER(1) NOT NULL DEFAULT '0',
  da_backup_schedule TINYINT(1) NOT NULL DEFAULT '0',
  da_server VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  da_user_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT 'root',
  da_user_pass VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT 'OQVsu+IvGkrEND',
  da_server_port BIGINT(20) NOT NULL DEFAULT '0',
  da_archive TINYINT(1) NOT NULL DEFAULT '0',
  da_sync TINYINT(1) NOT NULL DEFAULT '0',
  da_online TINYINT(1) NOT NULL DEFAULT '0',
  da_size BIGINT(21) NOT NULL DEFAULT '0',
  PRIMARY KEY (da_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_databases_cat (
  cl_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  cl_id_parent BIGINT(20) NOT NULL DEFAULT '0',
  cl_sort BIGINT(20) NOT NULL DEFAULT '0',
  cl_code VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cl_name VARCHAR(60) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  cl_desc VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (cl_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_desktop (
  dk_id_prog SMALLINT(6) NOT NULL DEFAULT '0',
  dk_id BIGINT(20) NOT NULL DEFAULT '0',
  dk_id_parent BIGINT(20) NOT NULL DEFAULT '0',
  dk_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  dk_type TINYINT(1) NOT NULL DEFAULT '0',
  dk_pos_X SMALLINT(6) NOT NULL DEFAULT '0',
  dk_pos_Y SMALLINT(6) NOT NULL DEFAULT '0',
  dk_command VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  dk_icon_id SMALLINT(6) NOT NULL DEFAULT '0',
  dk_width SMALLINT(6) NOT NULL DEFAULT '0',
  dk_height SMALLINT(6) NOT NULL DEFAULT '0',
  dk_icon_guid VARCHAR(40) COLLATE utf8_general_ci DEFAULT '',
  dk_icon_file VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (dk_id, dk_id_prog),
  KEY ix_dk_id (dk_id),
  KEY ix_dk_id_parent (dk_id_parent),
  KEY ix_dk_prog_id (dk_id_prog)
)ENGINE=MyISAM
AUTO_INCREMENT=0 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_dic_silang (
  fld_id BIGINT(11) NOT NULL AUTO_INCREMENT,
  fld_type BIGINT(11) DEFAULT NULL,
  fld_form VARCHAR(250) COLLATE utf8_general_ci DEFAULT NULL,
  fld_basic VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_arabic VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_english VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_france VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_german VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_turkish VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_kurdish VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_persian VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_sewedish VARCHAR(1000) COLLATE utf8_general_ci DEFAULT NULL,
  fld_group_id BIGINT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (fld_id),
  KEY ix_fld_arabic (fld_arabic(250)),
  KEY ix_fld_english (fld_english(250))
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_form_storage (
  frm_auto_id BIGINT(21) NOT NULL AUTO_INCREMENT,
  frm_user_id BIGINT(21) NOT NULL DEFAULT '0',
  frm_quid_id VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  frm_type_id BIGINT(20) NOT NULL DEFAULT '0',
  frm_state BIGINT(20) NOT NULL DEFAULT '0',
  frm_left BIGINT(20) NOT NULL DEFAULT '0',
  frm_top BIGINT(20) NOT NULL DEFAULT '0',
  frm_width BIGINT(20) NOT NULL DEFAULT '0',
  frm_height BIGINT(20) NOT NULL DEFAULT '0',
  frm_focused VARCHAR(40) COLLATE utf8_general_ci DEFAULT NULL,
  frm_sysdate TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (frm_auto_id),
  UNIQUE KEY ix_frm_unique (frm_user_id, frm_type_id, frm_quid_id),
  KEY ix_frm_user_id (frm_user_id),
  KEY ix_frm_type_id (frm_type_id),
  KEY ix_frm_quid_id (frm_quid_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_grid_desgin (
  t_id BIGINT(21) NOT NULL AUTO_INCREMENT,
  t_type_const BIGINT(11) NOT NULL DEFAULT '0',
  t_type_id BIGINT(11) NOT NULL DEFAULT '0',
  t_lang_id BIGINT(11) NOT NULL DEFAULT '0',
  t_lang_trans TINYINT(1) NOT NULL DEFAULT '0',
  t_reset TINYINT(1) NOT NULL DEFAULT '0',
  t_name VARCHAR(40) COLLATE utf8_general_ci DEFAULT NULL,
  t_row_height_title BIGINT(11) NOT NULL DEFAULT '0',
  t_row_height_data BIGINT(11) NOT NULL DEFAULT '0',
  t_title_color BIGINT(11) NOT NULL DEFAULT '0',
  t_alter_color BIGINT(11) NOT NULL DEFAULT '0',
  t_alter_font_color BIGINT(11) NOT NULL DEFAULT '0',
  t_title_font_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  t_title_font_size BIGINT(11) NOT NULL DEFAULT '0',
  t_title_font_style BIGINT(11) NOT NULL DEFAULT '0',
  t_title_font_color BIGINT(11) NOT NULL DEFAULT '0',
  t_color BIGINT(11) NOT NULL DEFAULT '0',
  t_font_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  t_font_size BIGINT(11) NOT NULL DEFAULT '0',
  t_font_style BIGINT(11) NOT NULL DEFAULT '0',
  t_font_color BIGINT(11) NOT NULL DEFAULT '0',
  t_auto_width TINYINT(1) NOT NULL DEFAULT '0',
  t_auto_width_index BIGINT(11) NOT NULL DEFAULT '0',
  t_word_warp TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (t_id),
  KEY ix_t_type_const (t_type_const),
  KEY ix_t_type_id (t_type_id),
  KEY ix_t_lang_id (t_lang_id)
)ENGINE=MyISAM
AUTO_INCREMENT=209 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_grid_desgin_det (
  tc_id BIGINT(21) NOT NULL AUTO_INCREMENT,
  tc_list_id BIGINT(21) NOT NULL DEFAULT '0',
  tc_field_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  tc_caption VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  tc_width BIGINT(11) NOT NULL DEFAULT '0',
  tc_visible TINYINT(1) NOT NULL DEFAULT '0',
  tc_title_align BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_color VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  tc_title_font_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  tc_title_font_size BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_font_style BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_font_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_align BIGINT(11) NOT NULL DEFAULT '0',
  tc_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_font_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  tc_font_size BIGINT(11) NOT NULL DEFAULT '0',
  tc_font_style BIGINT(11) NOT NULL DEFAULT '0',
  tc_font_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_assigned_values BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_layout BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_rot_angle BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_word_warp TINYINT(1) NOT NULL DEFAULT '0',
  tc_title_bidimode BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_transparent TINYINT(1) NOT NULL DEFAULT '0',
  tc_title_line_width BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_line_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_title_pos BIGINT(11) NOT NULL DEFAULT '0',
  tc_layout BIGINT(11) NOT NULL DEFAULT '0',
  tc_rot_angle BIGINT(11) NOT NULL DEFAULT '0',
  tc_word_warp TINYINT(1) NOT NULL DEFAULT '0',
  tc_bidimode BIGINT(11) NOT NULL DEFAULT '0',
  tc_transparent TINYINT(1) NOT NULL DEFAULT '0',
  tc_line_width BIGINT(11) NOT NULL DEFAULT '0',
  tc_line_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_line_pos BIGINT(11) NOT NULL DEFAULT '0',
  tc_cond_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_cond_font_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  tc_cond_font_size BIGINT(11) NOT NULL DEFAULT '0',
  tc_cond_font_style BIGINT(11) NOT NULL DEFAULT '0',
  tc_cond_font_color BIGINT(11) NOT NULL DEFAULT '0',
  tc_cond_condition VARCHAR(255) COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (tc_id),
  KEY ix_tc_list_id (tc_list_id)
)ENGINE=MyISAM
AUTO_INCREMENT=923 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_help (
  hl_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  hl_id_parent BIGINT(20) NOT NULL DEFAULT '0',
  hl_name VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL,
  hl_class VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL,
  hl_const BIGINT(20) NOT NULL DEFAULT '0',
  hl_desc LONGBLOB,
  hl_sort BIGINT(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (hl_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_host (
  host_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  host_name VARCHAR(50) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  host_desc VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  host_sort BIGINT(20) NOT NULL DEFAULT '0',
  host_check TINYINT(1) NOT NULL DEFAULT '0',
  host_mac VARCHAR(60) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  host_reg_key VARCHAR(30) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  host_prog_type BIGINT(20) NOT NULL DEFAULT '0',
  host_last_time DATETIME DEFAULT NULL,
  PRIMARY KEY (host_id),
  KEY ix_host_prog_type (host_prog_type),
  KEY ix_host_mac (host_mac),
  KEY ix_host_name (host_name)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_last_databases (
  la_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  la_database VARCHAR(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  la_computer VARCHAR(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  la_program_type BIGINT(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (la_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_option (
  op_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  op_type BIGINT(20) NOT NULL DEFAULT '0',
  op_const VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  op_value MEDIUMTEXT,
  op_desc VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL,
  op_computer VARCHAR(255) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  op_userid BIGINT(20) NOT NULL DEFAULT '0',
  op_datetime TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  op_blob LONGBLOB,
  PRIMARY KEY (op_id)
)ENGINE=MyISAM
AUTO_INCREMENT=2 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_quid (
  quid_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  quid_value VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (quid_id),
  KEY ix_tbl_quid_autoinc (quid_id),
  KEY ix_quid_value (quid_value)
)ENGINE=MyISAM
AUTO_INCREMENT=1001 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_register_list (
  reg_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  reg_ide VARCHAR(20) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  reg_guid VARCHAR(36) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  reg_key VARCHAR(36) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  reg_prog BIGINT(20) NOT NULL DEFAULT '0',
  reg_os MEDIUMTEXT,
  reg_date TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (reg_id),
  UNIQUE KEY reg_index (reg_guid, reg_key, reg_prog)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_report_controls (
  rc_id BIGINT(21) NOT NULL AUTO_INCREMENT,
  rc_list_id BIGINT(21) NOT NULL DEFAULT '0',
  rc_parent BIGINT(11) NOT NULL DEFAULT '0',
  rc_type BIGINT(11) NOT NULL DEFAULT '0',
  rc_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  rc_guid VARCHAR(40) COLLATE utf8_general_ci DEFAULT NULL,
  rc_left DECIMAL(10,0) NOT NULL DEFAULT '0',
  rc_top DECIMAL(10,0) NOT NULL DEFAULT '0',
  rc_width DECIMAL(10,0) NOT NULL DEFAULT '0',
  rc_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  rc_align BIGINT(11) NOT NULL DEFAULT '0',
  rc_printable TINYINT(1) NOT NULL DEFAULT '0',
  rc_value_text VARCHAR(60) COLLATE utf8_general_ci DEFAULT NULL,
  rc_value_int BIGINT(11) NOT NULL DEFAULT '0',
  rc_back_color BIGINT(11) NOT NULL DEFAULT '0',
  rc_border_color BIGINT(11) NOT NULL DEFAULT '0',
  rc_border_sides BIGINT(11) NOT NULL DEFAULT '0',
  rc_border_width BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_font VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  rc_text_size BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_style BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_color BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_h_alig BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_v_align BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_bidi BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_rotation BIGINT(11) NOT NULL DEFAULT '0',
  rc_text_warp TINYINT(1) NOT NULL DEFAULT '0',
  rc_autosize TINYINT(1) NOT NULL DEFAULT '0',
  rc_data_field_1 VARCHAR(40) COLLATE utf8_general_ci DEFAULT NULL,
  rc_data_field_2 VARCHAR(40) COLLATE utf8_general_ci DEFAULT NULL,
  rc_table_sync TINYINT(1) NOT NULL DEFAULT '0',
  rc_image_center TINYINT(1) NOT NULL DEFAULT '0',
  rc_image_proportion TINYINT(1) NOT NULL DEFAULT '0',
  rc_image_stretch TINYINT(1) NOT NULL DEFAULT '0',
  rc_arraw_cap TINYINT(1) NOT NULL DEFAULT '0',
  rc_arraw_tail TINYINT(1) NOT NULL DEFAULT '0',
  rc_arraw_size BIGINT(11) NOT NULL DEFAULT '0',
  rc_arraw_tilt TINYINT(1) NOT NULL DEFAULT '0',
  rc_line_style BIGINT(11) NOT NULL DEFAULT '0',
  rc_fill_style BIGINT(11) NOT NULL DEFAULT '0',
  rc_corner_angle BIGINT(11) NOT NULL DEFAULT '0',
  rc_show_caption TINYINT(1) NOT NULL DEFAULT '0',
  rc_style BIGINT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (rc_id)
)ENGINE=MyISAM
AUTO_INCREMENT=876 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_reports_list (
  r_id BIGINT(21) NOT NULL AUTO_INCREMENT,
  r_type_const BIGINT(11) NOT NULL DEFAULT '0',
  r_type_id BIGINT(11) NOT NULL DEFAULT '0',
  r_lang_id BIGINT(11) NOT NULL DEFAULT '0',
  r_lang_trans TINYINT(1) NOT NULL DEFAULT '0',
  r_reset TINYINT(1) NOT NULL DEFAULT '0',
  r_name VARCHAR(40) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  r_global_header TINYINT(1) NOT NULL DEFAULT '0',
  r_rep_header TINYINT(1) NOT NULL DEFAULT '0',
  r_rep_footer TINYINT(1) NOT NULL DEFAULT '0',
  r_page_header TINYINT(1) NOT NULL DEFAULT '0',
  r_page_footer TINYINT(1) NOT NULL DEFAULT '0',
  r_rep_detail BIGINT(11) NOT NULL DEFAULT '0',
  r_rep_barcode_column BIGINT(11) NOT NULL DEFAULT '0',
  r_page_color BIGINT(11) NOT NULL DEFAULT '0',
  r_page_image_style BIGINT(11) NOT NULL DEFAULT '0',
  r_page_image_print TINYINT(1) NOT NULL DEFAULT '0',
  r_rep_roll_print TINYINT(1) NOT NULL DEFAULT '0',
  r_rep_details_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_rep_header_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_rep_footer_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_header_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_footer_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_margine BIGINT(11) NOT NULL DEFAULT '0',
  r_page_margine_left DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_margine_top DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_margine_right DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_margine_bottom DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_direction BIGINT(11) NOT NULL DEFAULT '0',
  r_page_size BIGINT(11) NOT NULL DEFAULT '0',
  r_page_size_width DECIMAL(10,0) NOT NULL DEFAULT '0',
  r_page_size_height DECIMAL(10,0) NOT NULL DEFAULT '0',
  PRIMARY KEY (r_id)
)ENGINE=MyISAM
AUTO_INCREMENT=209 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_topic (
  form_name VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL,
  comp_name VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL,
  topic_details VARCHAR(255) COLLATE utf8_general_ci DEFAULT NULL,
  topic_hint VARCHAR(100) COLLATE utf8_general_ci DEFAULT NULL
)ENGINE=MyISAM
AUTO_INCREMENT=0 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_update_blob (
  pro_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  pro_type BIGINT(20) NOT NULL DEFAULT '0',
  pro_plug BIGINT(20) NOT NULL DEFAULT '0',
  pro_val LONGBLOB,
  pro_ver BIGINT(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (pro_id)
)ENGINE=InnoDB
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_update_config (
  up_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  up_number BIGINT(20) NOT NULL DEFAULT '0',
  up_name VARCHAR(255) COLLATE utf8_general_ci DEFAULT NULL,
  up_date TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (up_id),
  UNIQUE KEY up_number (up_number)
)ENGINE=MyISAM
AUTO_INCREMENT=58 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_update_config_crystal (
  up_id BIGINT(11) NOT NULL AUTO_INCREMENT,
  up_number BIGINT(11) NOT NULL DEFAULT '0',
  up_name VARCHAR(255) COLLATE utf8_general_ci DEFAULT NULL,
  up_date TIMESTAMP(0) NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (up_id),
  UNIQUE KEY up_number (up_number)
)ENGINE=MyISAM
AUTO_INCREMENT=38 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE TABLE tbl_users (
  us_id BIGINT(20) NOT NULL AUTO_INCREMENT,
  us_order BIGINT(20) NOT NULL DEFAULT '0',
  us_login_name VARCHAR(50) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  us_full_name VARCHAR(50) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  us_password VARCHAR(100) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  us_admin TINYINT(1) NOT NULL DEFAULT '0',
  us_admin_main TINYINT(1) NOT NULL DEFAULT '0',
  us_enabled TINYINT(1) NOT NULL DEFAULT '0',
  us_access_count BIGINT(20) NOT NULL DEFAULT '0',
  us_created_date DATE DEFAULT NULL,
  us_created_time TIME DEFAULT NULL,
  us_las_access_date DATE DEFAULT NULL,
  us_las_access_time TIME DEFAULT NULL,
  us_permission MEDIUMTEXT,
  us_short_cuts MEDIUMTEXT,
  us_menu_hide MEDIUMTEXT,
  us_freeze TINYINT(1) NOT NULL DEFAULT '0',
  us_host_all TINYINT(1) NOT NULL DEFAULT '1',
  us_access_count_mail BIGINT(20) NOT NULL DEFAULT '0',
  us_lang_id BIGINT(20) NOT NULL DEFAULT '0',
  us_pos_only TINYINT(1) NOT NULL DEFAULT '0',
  us_cash_acc_id BIGINT(21) NOT NULL DEFAULT '0',
  us_cash_def_acc_id BIGINT(21) NOT NULL DEFAULT '0',
  us_hot_prem VARCHAR(30) COLLATE utf8_general_ci NOT NULL DEFAULT '00000000000000000000000000000',
  us_res_prem VARCHAR(30) COLLATE utf8_general_ci NOT NULL DEFAULT '00000000000000000000000000000',
  us_update TINYINT(1) NOT NULL DEFAULT '0',
  us_security_id BIGINT(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (us_id)
)ENGINE=MyISAM
AUTO_INCREMENT=1 ROW_FORMAT=DYNAMIC 
CHARACTER SET 'utf8' COLLATE 'utf8_general_ci'
COMMENT='';

CREATE FUNCTION sys_exec RETURNS INTEGER SONAME "lib_mysqludf_sys.dll";

CREATE FUNCTION sys_eval RETURNS STRING SONAME "lib_mysqludf_sys.dll";

CREATE FUNCTION FileExist RETURNS INTEGER SONAME "CSCompressUDF.dll";

CREATE FUNCTION FileDelete RETURNS INTEGER SONAME "CSCompressUDF.dll";

CREATE FUNCTION FolderCreate RETURNS INTEGER SONAME "CSCompressUDF.dll";

CREATE FUNCTION FolderListFiles RETURNS STRING SONAME "CSCompressUDF.dll";

CREATE FUNCTION ArchiveAdd RETURNS INTEGER SONAME "CSCompressUDF.dll";

CREATE FUNCTION ArchiveListFiles RETURNS STRING SONAME "CSCompressUDF.dll";

CREATE FUNCTION ArchiveFinalize RETURNS STRING SONAME "CSCompressUDF.dll";

CREATE FUNCTION ArchiveDeleteFile RETURNS INTEGER SONAME "CSCompressUDF.dll";

INSERT INTO tbl_activation (active_id, active_host, active_desc, active_sort, active_pro_type, active_license, active_serial, active_mac_code, active_reg_code, active_feature, active_expiry, active_last_time) VALUES
  (1,'DESKTOP-FE1RIN5','',0,2,'HPC',57744974,'X393E89D16E7341D2','FAC16021E9E9FFEC','3145726','1899-12-30','2018-06-13 13:38:40');
COMMIT;

INSERT INTO tbl_currency (cu_id, cu_ucode, cu_code, cu_name, cu_name_latin, cu_country, cu_gender, cu_single, cu_plural, cu_frac_single, cu_frac_plural, cu_fracs_unit, cu_frac_gender, cu_equal, cu_sort, cu_notice) VALUES
  (1,'SYR','ل.س','ليرة','','سورية',1,'ليرة','ليرات','قرش','قروش',100,0,1.00000,0,''),
  (2,'2','ل.ل','ليرة','','لبنانية',1,'ليرة','ليرات','قرش','قروش',100,0,1.00000,0,''),
  (3,'3','د.ا','دينار','','أردني',0,'دينار','دنانير','فلس','فلوس',100,0,1.00000,0,''),
  (4,'4','د.ع','دينار','','عراقي',0,'دينار','دنانير','فلس','فلوس',100,0,1.00000,0,''),
  (5,'5','ر.س','ريال','','سعودي',0,'ريال','ريالات','هللة','هللات',100,0,1.00000,0,''),
  (6,'6','د.ا','درهم','','إماراتي',0,'درهم','دراهم','فلس','فلوس',100,0,1.00000,0,''),
  (7,'7','ج.م','جنيه','','مصري',0,'جنيه','جنيهات','قرش','قروش',100,0,1.00000,0,''),
  (8,'8','د.ك','دينار','','كويتي',0,'دينار','دنانير','فلس','فلوس',100,0,1.00000,0,''),
  (9,'9','د.ق','درهم','','قطري',0,'ريال','ريالات','درهم','دراهم',100,0,1.00000,0,''),
  (10,'10','د.ل','درهم','','ليبي',0,'دينار','دنانير','درهم','دراهم',100,0,1.00000,0,''),
  (11,'11','د.ج','دينار','','جزائري',0,'دينار','دنانير','سنتيم','سنتيمات',100,0,1.00000,0,''),
  (12,'USA','$','دولار','','أمريكي',0,'دولار','دولارات','سنت','سنتات',100,0,1.00000,0,''),
  (13,'13','يورو','يورو','','أوروبي',0,'يورو','يوروهات','سنت','سنتات',100,0,1.00000,0,''),
  (14,'14','مارك','مارك','','ألماني',0,'مارك','مارك','بنس','بنسات',100,0,1.00000,0,''),
  (15,'15','جنيه','جنيه','','استرليني',0,'جنيه','جنيهات','بنس','بنسات',100,0,1.00000,0,''),
  (16,'16','Y.R','ريال','','يمني',0,'ريال','ريالات','فلس','فلوس',100,0,1.00000,0,''),
  (17,'17','ش.ج','شيكل','','فلسطيني',1,'شيكل','شواكل','اغورة','اغورات',100,0,1.00000,0,''),
  (18,'18','ل.ت','ليرة',NULL,'تركية',1,'ليرة','ليرات','قرش','قروش',100,0,1.00000,0,NULL);
COMMIT;

INSERT INTO tbl_desktop (dk_id_prog, dk_id, dk_id_parent, dk_name, dk_type, dk_pos_X, dk_pos_Y, dk_command, dk_icon_id, dk_width, dk_height, dk_icon_guid, dk_icon_file) VALUES
  (1,2,0,'خروج',0,353,7,'mnu_FileExit',205,66,72,'ABEA34FF-2E41-4BC8-9599-1136759A47EC','system.asi'),
  (1,4,0,'بطاقة مادة',0,94,894,'mnu_cpu_card_item',7,66,72,'8A6BB71F-C4DA-42A9-B3AF-FC20FE0467F0','system.asi'),
  (1,5,0,'بطاقة موظف',0,177,894,'mnu_cpu_payroll_emp_card',228,66,72,'D3174E4F-B760-4D50-9D9B-4011D868D3E2','system.asi'),
  (1,7,0,'بطاقة زبون',0,12,813,'mnu_cpu_card_cust',169,66,72,'750FB718-9821-4347-BB30-89DF18BF39D7','system.asi'),
  (1,8,0,'بطاقة شحن',0,178,817,'mnu_card_discharge',153,66,72,'83B85233-A89B-46A1-8717-624DE23B19DC','system.asi'),
  (1,11,0,'بطاقة صيانة',0,13,732,'mnu_cpu_maintains_card',206,66,72,'4A56C353-69CF-4B04-9605-C375903A8E64','system.asi'),
  (1,12,0,'بطاقة صيانة خارجية',0,95,733,'mnu_cpu_maintains_card_out',164,66,75,'747C0B86-CC94-4765-BE29-29935EC85248','system.asi'),
  (1,13,0,'بحث الصيانة',0,179,735,'mnu_cpu_maintains_search',182,66,72,'4A13AC8E-BACC-4DB2-8A78-6FEF0B03DBA5','system.asi'),
  (1,15,0,'الحاسبة',0,13,86,'mnu_calc',128,69,74,'E5BCAAF8-F452-4184-9209-FA480E29F446','system.asi'),
  (1,19,0,'بطاقة مورد',0,94,815,'mnu_cpu_card_vendors',213,66,72,'EBA79311-327E-459A-9090-2A893EA5D8B4','system.asi'),
  (1,20,0,'تبديل المستخدم',0,252,8,'mnu_file_change_user',27,69,76,'728F843A-9C9C-4CA0-8287-066FF6CB0221','system.asi'),
  (1,25,0,'نسخ احتياطي فوري',0,92,83,'mnu_backup_live',139,70,77,'4A83EE93-01EF-45E9-9039-5029F7E8087F','System.asi'),
  (1,26,0,'اعدادات الطباعة',0,13,893,'mnu_print_setting',31,66,76,'FC2EA8D9-F876-4AAA-A54E-4B38F071D661','system.asi'),
  (1,27,0,'خيارات الملف',0,172,9,'mnu_Options',215,66,72,'940BCAE6-ED2D-42ED-A3E6-AF923B1ACB02','system.asi'),
  (1,28,0,'جهاز الكمبيوتر',0,13,9,'external_tools_201',187,66,72,'B593794F-04DE-4A8B-9CE5-A679D30F1998','system.asi'),
  (1,29,0,'Internet Explorer',0,91,9,'external_tools_205',217,67,76,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','system.asi'),
  (2,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (2,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (2,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (2,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (2,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (2,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (2,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (2,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (2,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (2,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (2,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (2,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (2,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (2,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (2,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (2,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (2,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (2,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (2,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (2,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (2,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (2,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (2,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (2,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (2,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (2,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (2,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (2,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (2,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (2,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (2,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (2,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (2,45,0,'حركة اجمالي المواد',0,103,483,'mnu_item_summary',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (2,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (2,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (2,48,0,'كاش',0,3,403,'mnu_point_sell_list_17',-2,70,90,'3271C3D1-29EC-49AB-BE82-A96AEF805092','system.asi'),
  (11,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (11,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (11,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (11,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (11,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (11,7,0,'دليل الحسابات',0,403,565,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (11,8,0,'بطاقة زبون',0,403,328,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (11,9,0,'بطاقة مورد',0,403,407,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (11,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (11,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (11,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (11,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (11,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (11,17,0,'ادخال سلفة',0,306,644,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (11,21,0,'ارصدة الحسابات',0,402,249,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (11,22,0,'كشف حساب',0,403,486,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (11,24,0,'الحاسبة',0,6,242,'mnu_calc',-2,66,88,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (11,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (11,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (11,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,67,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (11,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (11,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (11,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (11,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (11,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (11,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (11,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (11,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (11,45,0,'حركة اجمالي المواد',0,103,483,'mnu_item_summary',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (11,46,0,'جرد المواد',0,104,405,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (11,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (11,48,0,'كاش',0,3,403,'mnu_point_sell_list_17',-2,70,90,'3271C3D1-29EC-49AB-BE82-A96AEF805092','system.asi'),
  (11,50,0,'ارشيف الادوية',0,201,802,'mnu_drugs_chart',-2,74,86,'F2435714-1925-41D6-8BE3-583CE91F3582','System.asi'),
  (11,51,0,'صلاحية المواد',0,105,321,'mnu_item_expiry_date',-2,75,90,'0F2833B2-0434-48CD-AB03-6330C960E981','System.asi'),
  (11,52,0,'دليل المجموعات',0,203,722,'mnu_item_group_chart',-2,72,84,'D5C59A26-3F12-4774-BBCE-62080003AD82','System.asi'),
  (14,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (14,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (14,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (14,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (14,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (14,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (14,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (14,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (14,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (14,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (14,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (14,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (14,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (14,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (14,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (14,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (14,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (14,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (14,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (14,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (14,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (14,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (14,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (14,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (14,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (14,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (14,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (14,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (14,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (14,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (14,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (14,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (14,45,0,'حركة اجمالي المواد',0,103,483,'mnu_item_summary',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (14,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (14,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (14,48,0,'كاش',0,3,403,'mnu_point_sell_list_17',-2,70,90,'3271C3D1-29EC-49AB-BE82-A96AEF805092','system.asi'),
  (15,1,0,'بطاقة عميل',0,106,448,'mnu_customers',-2,66,72,'310E7B76-F21D-4347-AD7A-B144C7942CD8','System.asi'),
  (15,3,0,'صنف سيارات',0,194,330,'mnu_category',-2,66,72,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','System.asi'),
  (15,4,0,'بطاقة سيارة',0,107,330,'mnu_cars',-2,66,72,'0D49F3F8-1FD6-4E08-A886-C4C957EC88E3','System.asi'),
  (15,5,0,'عقد سيارة',0,104,562,'mnu_contract',-2,66,72,'2FE73E39-428A-4EE2-B0AB-BFFF890E428B','System.asi'),
  (15,6,0,'تقرير مفصل',0,191,562,'mnu_rep_security1',-2,66,72,'78B7AB21-26E1-454C-8B63-317F7B34BFED','System.asi'),
  (15,7,0,'خروج',0,353,7,'mnu_FileExit',205,66,72,'ABEA34FF-2E41-4BC8-9599-1136759A47EC','system.asi'),
  (15,8,0,'الحاسبة',0,13,86,'mnu_calc',128,69,74,'E5BCAAF8-F452-4184-9209-FA480E29F446','system.asi'),
  (15,9,0,'تبديل المستخدم',0,252,8,'mnu_file_change_user',27,69,76,'728F843A-9C9C-4CA0-8287-066FF6CB0221','system.asi'),
  (15,10,0,'نسخ احتياطي فوري',0,92,83,'mnu_backup_live',139,70,77,'4A83EE93-01EF-45E9-9039-5029F7E8087F','System.asi'),
  (15,11,0,'اعدادات الطباعة',0,13,893,'mnu_print_setting',31,66,76,'FC2EA8D9-F876-4AAA-A54E-4B38F071D661','system.asi'),
  (15,12,0,'خيارات الملف',0,172,9,'mnu_Options',215,66,72,'940BCAE6-ED2D-42ED-A3E6-AF923B1ACB02','system.asi'),
  (15,13,0,'جهاز الكمبيوتر',0,13,9,'external_tools_201',187,66,72,'B593794F-04DE-4A8B-9CE5-A679D30F1998','system.asi'),
  (15,14,0,'Internet Explorer',0,91,9,'external_tools_205',217,67,76,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','system.asi'),
  (20,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (20,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (20,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (20,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (20,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (20,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (20,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (20,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (20,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (20,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (20,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (20,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (20,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (20,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (20,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (20,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (20,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (20,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (20,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (20,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (20,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (20,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (20,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (20,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (20,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (20,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (20,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (20,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (20,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (20,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (20,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (20,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (20,45,0,'حركة اجمالي المواد',0,103,483,'mnu_item_summary',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (20,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (20,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (20,48,0,'كاش',0,3,403,'mnu_point_sell_list_17',-2,70,90,'3271C3D1-29EC-49AB-BE82-A96AEF805092','system.asi'),
  (25,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (25,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (25,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (25,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (25,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (25,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (25,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (25,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (25,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (25,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (25,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (25,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (25,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (25,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (25,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (25,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (25,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (25,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (25,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (25,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (25,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (25,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (25,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (25,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (25,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (25,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (25,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (25,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (25,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (25,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (25,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (25,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (25,45,0,'حركة اجمالي المواد',0,103,483,'mnu_item_summary',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (25,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (25,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (25,48,0,'كاش',0,3,403,'mnu_point_sell_list_17',-2,70,90,'3271C3D1-29EC-49AB-BE82-A96AEF805092','system.asi'),
  (31,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'C150D5EE-DC7D-432A-BB58-1C0C667A9486','System.asi'),
  (31,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (31,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (31,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'20045532-348B-4E3B-AF98-DF04DDFC8F66','System.asi'),
  (31,6,0,'خروج',0,303,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (31,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (31,8,0,'بطاقة زبون',0,403,403,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (31,9,0,'بطاقة مورد',0,403,323,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (31,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (31,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (31,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (31,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'C37A31DD-714F-4CA5-92F8-E58ABD3322CC','System.asi'),
  (31,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'2F1F700D-C504-47EF-8030-4120B36BCB5D','System.asi'),
  (31,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'4E75D4EF-E697-456B-B626-94D2BBF5F080','System.asi'),
  (31,16,0,'احتساب الرواتب',0,3,403,'mnu_emp_payroll',-2,70,90,'ED86631C-200D-4243-964D-175AFB2FC078','System.asi'),
  (31,17,0,'ادخال سلفة',0,3,563,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (31,18,0,'تسديد سلفة',0,3,483,'mnu_emp_advance_paying',-2,70,90,'8DE06B05-6832-48C4-9B3F-95033D5A9867','System.asi'),
  (31,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (31,20,0,'دفتر الاستاذ',0,203,483,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (31,21,0,'ارصدة الحسابات',0,203,403,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (31,22,0,'كشف حساب',0,203,323,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (31,24,0,'الحاسبة',0,103,163,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (31,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (31,27,0,'اطفاء الكمبيوتر',0,403,3,'external_tools_204',-2,70,90,'805B1B2F-3BC0-4D38-AE18-77F8DF43EAC3','System.asi'),
  (31,28,0,'Microsoft Excel',0,3,243,'external_tools_202',-2,70,90,'D648AE91-ACEF-4B07-9972-AC9283E31E9D','System.asi'),
  (31,29,0,'Microsoft Word',0,3,163,'external_tools_203',-2,70,90,'3D8DF853-67A8-4B07-98C7-3CA6AB2B0BA9','System.asi'),
  (31,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (31,31,0,'مكافآت الموظفين',0,3,643,'mnu_Emp_Reward',-2,70,90,'C2E52881-6A46-488F-B26F-11CB23E33C3B','System.asi'),
  (31,32,0,'خصميات الموظفين',0,2,723,'mnu_Emp_Deduction',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (31,33,0,'ميزان المراجعة',0,303,403,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (31,34,0,'الحسابات الختامية',0,303,323,'mnu_acc_rep_budget',-2,70,90,'D5CCD423-391F-4AEE-A01E-D1B3C273D9DD','System.asi'),
  (31,35,0,'اختصارات القوائم',0,103,243,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (32,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (32,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (32,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (32,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (32,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (32,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (32,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (32,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (32,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (32,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (32,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (32,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (32,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (32,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (32,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (32,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (32,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (32,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (32,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (32,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (32,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (32,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (32,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (32,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (32,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (32,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (32,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (32,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (32,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (32,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (32,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (32,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (32,45,0,'حركة اجمالي المواد',0,103,483,'mnu_item_summary',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (32,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (32,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (32,48,0,'كاش',0,3,403,'mnu_point_sell_list_17',-2,70,90,'3271C3D1-29EC-49AB-BE82-A96AEF805092','system.asi'),
  (33,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (33,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (33,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (33,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (33,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (33,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (33,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (33,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (33,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (33,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (33,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (33,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (33,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (33,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (33,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (33,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (33,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (33,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (33,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (33,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (33,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (33,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (33,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (33,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (33,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (33,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (33,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (33,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (33,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (33,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (33,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (33,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (33,45,0,'حركة اجمالي المواد',0,103,483,'mnu_inventory_item_movement_sum',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (33,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (33,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi'),
  (34,1,0,'بطاقة مشترك',0,23,919,'mnu_payroll_emp_card',-2,66,72,'05C66AC5-9650-40D2-B7E9-2DA1D7F60253','System.asi'),
  (34,6,0,'الحاسبة',0,4,256,'mnu_calc',-2,66,72,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (34,8,0,'تبديل المستخدم',0,232,6,'mnu_file_change_user',-2,63,83,'728F843A-9C9C-4CA0-8287-066FF6CB0221','System.asi'),
  (34,9,0,'خروج',0,391,14,'mnu_FileExit',-2,50,72,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (34,12,0,'نسخ احتياطي فوري',0,116,95,'mnu_backup_live',-2,63,81,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (34,13,0,'نسخ احتياطي الى ملف',0,116,12,'mnu_backup_to_file',-2,70,82,'4A83EE93-01EF-45E9-9039-5029F7E8087F','System.asi'),
  (34,14,0,'فتح ملف',0,233,86,'mnu_FileOpen',-2,55,67,'0396B9BC-1310-4067-9E76-AC4537C81C74','System.asi'),
  (34,15,0,'اختصارات القوائم',0,4,175,'mnu_ShortCut',-2,70,83,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (34,16,0,'جهاز الكمبيوتر',0,3,10,'external_tools_201',-2,64,77,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (34,17,0,'I&nternet Explorer',0,4,88,'external_tools_205',-2,69,81,'644AFCA1-CD1E-44EC-8A01-11671E582F0C','System.asi'),
  (34,20,0,'قراءة الحضور',0,288,925,'mnu_Emp_Log',-2,66,72,'9B81AD5C-A450-45FF-87EA-B5CEB295D753','Attendance.asi'),
  (34,22,0,'اجهزة القراءة',0,111,756,'mnu_Emp_Devices',-2,66,72,'ADE64039-1CE7-48FB-AC0B-347F3679AAAD','Attendance.asi'),
  (40,1,0,'بطاقة موظف',0,23,919,'mnu_payroll_emp_card',-2,66,72,'05C66AC5-9650-40D2-B7E9-2DA1D7F60253','System.asi'),
  (40,2,0,'أنواع التأخير',0,192,835,'mnu_Emp_Calc_Type_delay',-2,66,72,'6F7B06AB-8914-4555-A6BD-A91D633E4776','Attendance.asi'),
  (40,3,0,'أنواع الإضافي',0,191,923,'mnu_Emp_Calc_Type_over',-2,66,72,'22C1836C-CD4C-4CC6-B189-DC01BD70CD27','Attendance.asi'),
  (40,5,0,'أنواع الغياب',0,194,758,'mnu_Emp_Calc_Type_absence',-2,65,74,'761F7BDD-13D4-4C2D-996F-D1170594772E','Attendance.asi'),
  (40,6,0,'الحاسبة',0,4,256,'mnu_calc',-2,66,72,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (40,8,0,'تبديل المستخدم',0,232,6,'mnu_file_change_user',-2,63,83,'728F843A-9C9C-4CA0-8287-066FF6CB0221','System.asi'),
  (40,9,0,'خروج',0,391,14,'mnu_FileExit',-2,50,72,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (40,12,0,'نسخ احتياطي فوري',0,116,95,'mnu_backup_live',-2,63,81,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (40,13,0,'نسخ احتياطي الى ملف',0,116,12,'mnu_backup_to_file',-2,70,82,'4A83EE93-01EF-45E9-9039-5029F7E8087F','System.asi'),
  (40,14,0,'فتح ملف',0,233,86,'mnu_FileOpen',-2,55,67,'0396B9BC-1310-4067-9E76-AC4537C81C74','System.asi'),
  (40,15,0,'اختصارات القوائم',0,4,175,'mnu_ShortCut',-2,70,83,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (40,16,0,'جهاز الكمبيوتر',0,3,10,'external_tools_201',-2,64,77,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (40,17,0,'I&nternet Explorer',0,4,88,'external_tools_205',-2,69,81,'644AFCA1-CD1E-44EC-8A01-11671E582F0C','System.asi'),
  (40,19,0,'الحركة اليومية',0,289,836,'mnu_Emp_DailyMove',-2,71,74,'BAEF8F18-C874-4CAA-B5DA-40AFCB2B3C60','Attendance.asi'),
  (40,20,0,'قراءة الحضور',0,288,925,'mnu_Emp_Log',-2,66,72,'9B81AD5C-A450-45FF-87EA-B5CEB295D753','Attendance.asi'),
  (40,21,0,'تقرير الدوام',0,290,760,'mnu_Emp_Attend_Rep',-2,66,73,'B8C9EAAB-069D-4BE1-99AF-113A75578C02','Attendance.asi'),
  (40,22,0,'اجهزة القراءة',0,111,756,'mnu_Emp_Devices',-2,66,72,'ADE64039-1CE7-48FB-AC0B-347F3679AAAD','Attendance.asi'),
  (40,23,0,'تعريف الدوام',0,107,921,'mnu_Emp_Group_def',-2,66,72,'965EF089-E4BE-431B-8773-83031E8ED19D','Attendance.asi'),
  (41,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'C150D5EE-DC7D-432A-BB58-1C0C667A9486','System.asi'),
  (41,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (41,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (41,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'20045532-348B-4E3B-AF98-DF04DDFC8F66','System.asi'),
  (41,6,0,'خروج',0,303,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (41,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (41,8,0,'بطاقة زبون',0,403,403,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (41,9,0,'بطاقة مورد',0,403,323,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (41,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (41,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (41,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (41,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'C37A31DD-714F-4CA5-92F8-E58ABD3322CC','System.asi'),
  (41,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'2F1F700D-C504-47EF-8030-4120B36BCB5D','System.asi'),
  (41,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'4E75D4EF-E697-456B-B626-94D2BBF5F080','System.asi'),
  (41,16,0,'احتساب الرواتب',0,3,403,'mnu_emp_payroll',-2,70,90,'ED86631C-200D-4243-964D-175AFB2FC078','System.asi'),
  (41,17,0,'ادخال سلفة',0,3,563,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (41,18,0,'تسديد سلفة',0,3,483,'mnu_emp_advance_paying',-2,70,90,'8DE06B05-6832-48C4-9B3F-95033D5A9867','System.asi'),
  (41,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (41,20,0,'دفتر الاستاذ',0,203,483,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (41,21,0,'ارصدة الحسابات',0,203,403,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (41,22,0,'كشف حساب',0,203,323,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (41,24,0,'الحاسبة',0,103,163,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (41,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (41,27,0,'اطفاء الكمبيوتر',0,403,3,'external_tools_204',-2,70,90,'805B1B2F-3BC0-4D38-AE18-77F8DF43EAC3','System.asi'),
  (41,28,0,'Microsoft Excel',0,3,243,'external_tools_202',-2,70,90,'D648AE91-ACEF-4B07-9972-AC9283E31E9D','System.asi'),
  (41,29,0,'Microsoft Word',0,3,163,'external_tools_203',-2,70,90,'3D8DF853-67A8-4B07-98C7-3CA6AB2B0BA9','System.asi'),
  (41,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (41,31,0,'مكافآت الموظفين',0,3,643,'mnu_Emp_Reward',-2,70,90,'C2E52881-6A46-488F-B26F-11CB23E33C3B','System.asi'),
  (41,32,0,'خصميات الموظفين',0,2,723,'mnu_Emp_Deduction',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (41,33,0,'ميزان المراجعة',0,303,403,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (41,34,0,'الحسابات الختامية',0,303,323,'mnu_acc_rep_budget',-2,70,90,'D5CCD423-391F-4AEE-A01E-D1B3C273D9DD','System.asi'),
  (41,35,0,'اختصارات القوائم',0,103,243,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (43,2,0,'خروج',0,353,7,'mnu_FileExit',205,66,72,'ABEA34FF-2E41-4BC8-9599-1136759A47EC','system.asi'),
  (43,4,0,'بطاقة مادة',0,94,894,'mnu_cpu_card_item',7,66,72,'8A6BB71F-C4DA-42A9-B3AF-FC20FE0467F0','system.asi'),
  (43,5,0,'بطاقة موظف',0,177,894,'mnu_cpu_payroll_emp_card',228,66,72,'D3174E4F-B760-4D50-9D9B-4011D868D3E2','system.asi'),
  (43,7,0,'بطاقة زبون',0,12,813,'mnu_cpu_card_cust',169,66,72,'750FB718-9821-4347-BB30-89DF18BF39D7','system.asi'),
  (43,8,0,'بطاقة شحن',0,178,817,'mnu_card_discharge',153,66,72,'83B85233-A89B-46A1-8717-624DE23B19DC','system.asi'),
  (43,11,0,'بطاقة صيانة',0,13,732,'mnu_cpu_maintains_card',206,66,72,'4A56C353-69CF-4B04-9605-C375903A8E64','system.asi'),
  (43,12,0,'بطاقة صيانة خارجية',0,95,733,'mnu_cpu_maintains_card_out',164,66,75,'747C0B86-CC94-4765-BE29-29935EC85248','system.asi'),
  (43,13,0,'بحث الصيانة',0,179,735,'mnu_cpu_maintains_search',182,66,72,'4A13AC8E-BACC-4DB2-8A78-6FEF0B03DBA5','system.asi'),
  (43,15,0,'الحاسبة',0,13,86,'mnu_calc',128,69,74,'E5BCAAF8-F452-4184-9209-FA480E29F446','system.asi'),
  (43,19,0,'بطاقة مورد',0,94,815,'mnu_cpu_card_vendors',213,66,72,'EBA79311-327E-459A-9090-2A893EA5D8B4','system.asi'),
  (43,20,0,'تبديل المستخدم',0,252,8,'mnu_file_change_user',27,69,76,'728F843A-9C9C-4CA0-8287-066FF6CB0221','system.asi'),
  (43,25,0,'نسخ احتياطي فوري',0,92,83,'mnu_backup_live',139,70,77,'4A83EE93-01EF-45E9-9039-5029F7E8087F','System.asi'),
  (43,26,0,'اعدادات الطباعة',0,13,893,'mnu_print_setting',31,66,76,'FC2EA8D9-F876-4AAA-A54E-4B38F071D661','system.asi'),
  (43,27,0,'خيارات الملف',0,172,9,'mnu_Options',215,66,72,'940BCAE6-ED2D-42ED-A3E6-AF923B1ACB02','system.asi'),
  (43,28,0,'جهاز الكمبيوتر',0,13,9,'external_tools_201',187,66,72,'B593794F-04DE-4A8B-9CE5-A679D30F1998','system.asi'),
  (43,29,0,'Internet Explorer',0,91,9,'external_tools_205',217,67,76,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','system.asi'),
  (49,1,0,'فتح ملف',0,203,83,'mnu_FileOpen',-2,70,90,'0396B9BC-1310-4067-9E76-AC4537C81C74','system.asi'),
  (49,2,0,'تبديل المستخدم',0,203,3,'mnu_file_change_user',-2,70,90,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730','System.asi'),
  (49,3,0,'نسخ احتياطي فوري',0,103,83,'mnu_backup_live',-2,70,90,'2048F81C-DB75-4A9D-A91C-17CF691BA018','System.asi'),
  (49,4,0,'نسخ احتياطي الى ملف',0,103,3,'mnu_backup_to_file',-2,70,90,'4A83EE93-01EF-45E9-9039-5029F7E8087F','system.asi'),
  (49,6,0,'خروج',0,403,3,'mnu_FileExit',-2,70,90,'741A0ABE-DC28-4668-9BBD-4F732A69B65A','System.asi'),
  (49,7,0,'دليل الحسابات',0,403,483,'mnu_tree_account',-2,70,90,'AC589025-2C51-44F2-A0C2-6379922B93ED','System.asi'),
  (49,8,0,'بطاقة زبون',0,303,323,'mnu_card_cust',-2,70,90,'750FB718-9821-4347-BB30-89DF18BF39D7','System.asi'),
  (49,9,0,'بطاقة مورد',0,303,403,'mnu_card_vendors',-2,70,90,'EBA79311-327E-459A-9090-2A893EA5D8B4','System.asi'),
  (49,10,0,'سند قيد',0,303,643,'mnu_batch_list_10',-2,70,90,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298','System.asi'),
  (49,11,0,'سند قبض',0,303,723,'mnu_batch_list_14',-2,70,90,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B','System.asi'),
  (49,12,0,'سند دفع',0,303,803,'mnu_batch_list_15',-2,70,90,'77DEBFB5-7843-4226-99DC-F9E54DC53A78','System.asi'),
  (49,13,0,'يومية الصندوق',0,403,643,'mnu_batch_list_16',-2,70,90,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427','system.asi'),
  (49,14,0,'مقبوضات الصندوق',0,403,723,'mnu_batch_list_17',-2,70,90,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD','system.asi'),
  (49,15,0,'مدفوعات الصندوق',0,403,803,'mnu_batch_list_18',-2,70,90,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801','system.asi'),
  (49,17,0,'ادخال سلفة',0,203,803,'mnu_emp_advance_input',-2,70,90,'601EF76D-33CC-437F-A199-4B9D8B708AAF','System.asi'),
  (49,19,0,'دفتر اليومية',0,303,483,'mnu_acc_rep_journal',-2,70,90,'A7E5134B-178D-4416-ADD9-B045223CC6A7','System.asi'),
  (49,20,0,'دفتر الاستاذ',0,403,403,'mnu_acc_rep_ledger',-2,70,90,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D','System.asi'),
  (49,21,0,'ارصدة الحسابات',0,303,243,'mnu_acc_rep_balancing',-2,70,90,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9','System.asi'),
  (49,22,0,'كشف حساب',0,403,243,'mnu_mnu_account_report_cust',-2,70,90,'19A13C97-C083-4285-9D18-50D66747ECB0','System.asi'),
  (49,24,0,'الحاسبة',0,7,243,'mnu_calc',-2,70,90,'E5BCAAF8-F452-4184-9209-FA480E29F446','System.asi'),
  (49,26,0,'جهاز الكمبيوتر',0,3,3,'external_tools_201',-2,70,90,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772','System.asi'),
  (49,30,0,'Internet Explorer',0,3,83,'external_tools_205',-2,70,90,'B509D398-1DAB-41BA-B241-1AA56B53A5B5','System.asi'),
  (49,33,0,'ميزان المراجعة',0,403,323,'mnu_acc_rep_trial_balance',-2,70,90,'C75484EE-B375-48BC-A7F2-99D83D0409E5','System.asi'),
  (49,35,0,'اختصارات القوائم',0,5,163,'mnu_ShortCut',-2,70,90,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B','System.asi'),
  (49,36,0,'شراء',0,3,723,'mnu_invoice_list_9',-2,70,90,'D35CD46E-0D53-4939-B387-9D42CC878C25','system.asi'),
  (49,37,0,'مبيع',0,3,643,'mnu_invoice_list_2',-2,70,90,'5B3B3035-BC11-4DCE-AAB2-48712264E474','system.asi'),
  (49,38,0,'مرتجع شراء',0,3,563,'mnu_invoice_list_4',-2,70,90,'1FE4680F-18B6-432E-A48B-FC48C0C1F578','system.asi'),
  (49,39,0,'مرتجع مبيع',0,3,483,'mnu_invoice_list_3',-2,70,90,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B','system.asi'),
  (49,40,0,'بحث الفواتير',0,3,803,'mnu_Bills_Process',-2,70,90,'0CCB349A-F603-46CA-B33E-817D7288550A','system.asi'),
  (49,41,0,'بطاقة مادة',0,103,803,'mnu_card_item',-2,70,90,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F','system.asi'),
  (49,42,0,'دليل المواد',0,103,723,'mnu_tree_classes',-2,70,90,'EE9698A2-3597-4884-A1AD-BC6043FFB548','system.asi'),
  (49,44,0,'حركة مادة',0,103,563,'mnu_inventory_item_movement',-2,70,90,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575','system.asi'),
  (49,45,0,'حركة اجمالي المواد',0,103,483,'mnu_inventory_item_movement_sum',-2,70,90,'3811099C-EEA3-4F9C-ACBD-6011962D264E','system.asi'),
  (49,46,0,'جرد المواد',0,103,403,'mnu_inventory_check_list',-2,70,90,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432','system.asi'),
  (49,47,0,'ارباح الفواتير',0,103,643,'mnu_invoice_win_rep',-2,70,90,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA','system.asi');
COMMIT;

INSERT INTO tbl_grid_desgin (t_id, t_type_const, t_type_id, t_lang_id, t_lang_trans, t_reset, t_name, t_row_height_title, t_row_height_data, t_title_color, t_alter_color, t_alter_font_color, t_title_font_name, t_title_font_size, t_title_font_style, t_title_font_color, t_color, t_font_name, t_font_size, t_font_style, t_font_color, t_auto_width, t_auto_width_index, t_word_warp) VALUES
  (121,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (124,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (125,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (126,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (127,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (128,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (134,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (135,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (136,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (137,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (138,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (139,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (140,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (141,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (144,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (145,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (146,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (147,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (150,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (151,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (152,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (153,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (154,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (155,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (156,127,0,0,0,0,'',31,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (157,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (158,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (159,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (160,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (161,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (162,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (163,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (165,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (166,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (169,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (170,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (180,127,0,0,0,0,'',30,26,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (182,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (183,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (185,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (186,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (187,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (188,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (190,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (191,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (201,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (202,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (203,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (204,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (205,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (206,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (207,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0),
  (208,127,0,0,0,0,'',22,22,12632256,536870911,536870911,'Tahoma',8,0,-16777208,16777215,'Tahoma',8,0,-16777208,0,-1,0);
COMMIT;

INSERT INTO tbl_grid_desgin_det (tc_id, tc_list_id, tc_field_name, tc_caption, tc_width, tc_visible, tc_title_align, tc_title_color, tc_title_font_name, tc_title_font_size, tc_title_font_style, tc_title_font_color, tc_align, tc_color, tc_font_name, tc_font_size, tc_font_style, tc_font_color, tc_assigned_values, tc_title_layout, tc_title_rot_angle, tc_title_word_warp, tc_title_bidimode, tc_title_transparent, tc_title_line_width, tc_title_line_color, tc_title_pos, tc_layout, tc_rot_angle, tc_word_warp, tc_bidimode, tc_transparent, tc_line_width, tc_line_color, tc_line_pos, tc_cond_color, tc_cond_font_name, tc_cond_font_size, tc_cond_font_style, tc_cond_font_color, tc_cond_condition) VALUES
  (1,121,'auto_id','#',34,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (2,121,'in_det_item_code','رمز المادة',85,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (3,121,'in_det_item_name','اسم المادة',142,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (4,121,'in_det_item_unit','الوحدة',53,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (5,121,'in_det_qty_rec','الكمية',49,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (6,121,'in_det_price','السعر',78,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (7,121,'in_det_discount','نسبة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (8,121,'in_det_discount_val','قيمة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (9,121,'in_det_total_val','السعر الاجمالي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (10,121,'in_det_total_net','الاجمالي',100,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (11,121,'in_det_gift','هدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (12,121,'in_det_store_name','المستودع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (13,121,'in_det_barcode','الباركود',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (14,121,'in_det_date_mfg','تاريخ الانتاج',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (15,121,'in_det_date_exp','تاريخ الصلاحية',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (16,121,'in_det_length','الطول',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (17,121,'in_det_width','العرض',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (18,121,'in_det_height','الارتفاع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (19,121,'in_det_gold_type','العيار',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (20,121,'in_det_gold_addon','كلفة اضافية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (21,121,'in_det_win','الربح',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (22,121,'in_det_notice','ملاحظة',168,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (23,121,'in_det_breakdown_id','العطل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (24,121,'in_det_item_latin','الاسم اللاتيني',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (25,121,'in_det_item_source','المصدر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (26,121,'in_det_item_company','الشركة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (27,121,'in_det_qty_equal','التعادل',-1,0,0,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (28,121,'in_det_addition_per','نسبة الاضافة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (29,121,'in_det_addition','قيمة مضافة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (30,121,'in_det_tax_per','نسبة الضريبة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (31,121,'in_det_tax','ضريبة مضافة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (32,121,'in_det_cost','تكلفة افرادية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (33,121,'in_det_cost_total','تكلفة اجمالية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (34,121,'in_det_date_exp_hij','تاريخ الصلاحية هجري',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (35,121,'in_det_win_perc','نسبة الربح',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (36,121,'in_det_one_serial','السيريال',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (37,121,'in_det_qty','الكمية الاساسية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (38,121,'calc_it_location','الموقع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (39,121,'in_det_price_one','سعر الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (40,121,'in_det_item_warranty','الكفالة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (41,121,'it_cl_name','الفئة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (42,121,'item_qty_now','الكمية الحالية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (43,121,'it_desc','المواصفات',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (44,121,'it_un_price_sell_a','سعر المبيع العام',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (45,121,'it_un_price_sell_b','سعر الجملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (46,121,'it_un_price_sell_c','سعر نصف الجملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (47,121,'it_un_price_sell_d','سعر التصدير',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (48,121,'it_un_price_sell_e','سعر المستهلك',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (49,121,'it_measure','القياس',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (50,121,'calc_qty_remain','الكمية المتبقية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (51,121,'calc_qty_delivery','الكمية المسلمة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (52,121,'in_det_ref','المرجع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (53,124,'auto_id','م',43,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (54,124,'gl_account_name','الحساب',186,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (55,124,'gl_debit','مدين',76,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (56,124,'gl_credit','دائن',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (57,124,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (58,124,'gl_currency_val','التعادل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (59,124,'currency_total','قيمة العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (60,124,'gl_cost_center','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (61,124,'gl_desc','البيان',338,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (62,124,'gl_doc','وثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (63,124,'gl_qty','الكمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (64,124,'gl_price','السعر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (65,124,'gl_orgin_name','المصدر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (66,125,'emp_employee_id','الرقم',42,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (67,125,'emp_firstname','الاسم',106,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (68,125,'emp_lastname','اسم العائلة',81,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (69,125,'emp_cellphone','هاتف جوال',73,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (70,125,'emp_homephone','هاتف منزل',94,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (71,125,'emp_father_name','اسم الاب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (72,125,'emp_mother_name','اسم الام',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (73,125,'emp_sex','الجنس',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (74,125,'emp_city','المدينة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (75,125,'emp_state','المنطقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (76,125,'emp_address','العنوان',217,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (77,125,'emp_address2','العنوان 2',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (78,125,'emp_email','بريد الكتروني',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (79,125,'emp_comment','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (80,125,'emp_gr_name','القسم',100,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (81,126,'auto_id','م',51,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (82,126,'gl_account_name','الحساب',222,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (83,126,'gl_debit','مدين',76,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (84,126,'gl_credit','دائن',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (85,126,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (86,126,'gl_currency_val','التعادل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (87,126,'currency_total','قيمة العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (88,126,'gl_cost_center','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (89,126,'gl_desc','البيان',287,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (90,126,'gl_doc','وثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (91,126,'gl_qty','الكمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (92,126,'gl_price','السعر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (93,126,'gl_note_id','ورقة مالية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (94,126,'gl_orgin_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (95,127,'ba_list_id','ba_list_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (96,127,'ba_list_xid','ba_list_xid',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (97,127,'ba_list_number','ba_list_number',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (98,127,'ba_list_attached','ba_list_attached',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (99,127,'ba_list_type','ba_list_type',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (100,127,'ba_list_type_id','ba_list_type_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (101,127,'ba_list_branch_id','ba_list_branch_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (102,127,'ba_list_debit','ba_list_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (103,127,'ba_list_credit','ba_list_credit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (104,127,'ba_list_desc','ba_list_desc',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (105,127,'ba_list_date','ba_list_date',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (106,127,'ba_list_reference','ba_list_reference',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (107,127,'ba_list_currency_id','ba_list_currency_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (108,127,'ba_list_currency_val','ba_list_currency_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (109,127,'ba_list_post','ba_list_post',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (110,127,'ba_list_post_user','ba_list_post_user',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (111,127,'ba_list_user_id','ba_list_user_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (112,127,'gl_const','gl_const',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (113,127,'gl_ac_id','gl_ac_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (114,127,'account_name','account_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (115,127,'gl_costcenter_id','gl_costcenter_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (116,127,'cost_center_name','cost_center_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (117,127,'currency_name','currency_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (118,127,'gl_is_equal','gl_is_equal',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (119,127,'gl_dev_value','gl_dev_value',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (120,127,'temp_zero','temp_zero',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (121,127,'gl_ac_id_debit','gl_ac_id_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (122,127,'account_name_debit','account_name_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (123,127,'gl_costcenter_id_debit','gl_costcenter_id_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (124,127,'cost_center_name_debit','cost_center_name_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (125,127,'discount_val','discount_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (126,127,'batch_val','batch_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (127,127,'ba_list_branch_name','ba_list_branch_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (128,127,'ba_list_total','ba_list_total',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (129,127,'cheque_val','cheque_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (130,128,'ba_list_id','ba_list_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (131,128,'ba_list_xid','ba_list_xid',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (132,128,'ba_list_number','ba_list_number',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (133,128,'ba_list_attached','ba_list_attached',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (134,128,'ba_list_type','ba_list_type',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (135,128,'ba_list_type_id','ba_list_type_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (136,128,'ba_list_branch_id','ba_list_branch_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (137,128,'ba_list_debit','ba_list_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (138,128,'ba_list_credit','ba_list_credit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (139,128,'ba_list_desc','ba_list_desc',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (140,128,'ba_list_date','ba_list_date',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (141,128,'ba_list_reference','ba_list_reference',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (142,128,'ba_list_currency_id','ba_list_currency_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (143,128,'ba_list_currency_val','ba_list_currency_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (144,128,'ba_list_post','ba_list_post',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (145,128,'ba_list_post_user','ba_list_post_user',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (146,128,'ba_list_user_id','ba_list_user_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (147,128,'gl_const','gl_const',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (148,128,'gl_ac_id','gl_ac_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (149,128,'account_name','account_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (150,128,'gl_costcenter_id','gl_costcenter_id',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (151,128,'cost_center_name','cost_center_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (152,128,'currency_name','currency_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (153,128,'gl_is_equal','gl_is_equal',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (154,128,'gl_dev_value','gl_dev_value',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (155,128,'temp_zero','temp_zero',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (156,128,'gl_ac_id_debit','gl_ac_id_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (157,128,'account_name_debit','account_name_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (158,128,'gl_costcenter_id_debit','gl_costcenter_id_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (159,128,'cost_center_name_debit','cost_center_name_debit',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (160,128,'discount_val','discount_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (161,128,'batch_val','batch_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (162,128,'ba_list_branch_name','ba_list_branch_name',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (163,128,'ba_list_total','ba_list_total',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (164,128,'cheque_val','cheque_val',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,128,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (165,134,'auto_id','#',38,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (166,134,'in_list_number','الرقم',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (167,134,'in_type_name','النوع',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (168,134,'in_list_date','التاريخ',72,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (169,134,'in_list_payment_type','طريقة الدفع',80,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (170,134,'cu_name','العميل',145,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (171,134,'in_list_total','المجموع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (172,134,'in_list_discount_total','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (173,134,'in_list_payment','دفعة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (174,134,'in_list_net','الصافي',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (175,134,'in_list_desc','البيان',136,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (176,134,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (177,134,'st_name','المستودع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (178,134,'currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (179,134,'in_det_currency_val','تعادل العملة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (180,134,'in_list_reference','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (181,134,'in_list_post','مرحلة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (182,134,'in_list_checked','مدققة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (183,134,'in_list_checked_user_name','المدقق',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (184,134,'in_list_time','الوقت',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (185,134,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (186,134,'in_list_remain','الباقي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (187,134,'us_full_name','المستخدم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (188,134,'in_list_print_count','نسخ الطباعة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (189,134,'in_list_cust_name','عميل نقدي',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (190,134,'in_list_build_inv_count','الفواتير المرتبطة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (191,135,'auto_id','م',28,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (192,135,'in_det_item_code','رمز المادة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (193,135,'in_det_item_name','اسم المادة',143,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (194,135,'in_det_item_unit','الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (195,135,'in_det_qty_rec','الكمية',46,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (196,135,'in_det_price','السعر الافرادي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (197,135,'in_det_discount','نسبة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (198,135,'in_det_discount_val','قيمة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (199,135,'in_det_total_val','الاجمالي',65,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (200,135,'in_det_gift','هدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (201,135,'in_det_store_name','المستودع',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (202,135,'in_det_barcode','الباركود',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (203,135,'in_det_date_mfg','تاريخ الانتاج',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (204,135,'in_det_date_exp','تاريخ الصلاحية',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (205,135,'in_det_length','الطول',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (206,135,'in_det_width','العرض',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (207,135,'in_det_height','الارتفاع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (208,135,'in_det_gold_type','العيار',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (209,135,'in_det_gold_addon','كلفة اضافية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (210,135,'in_det_win','الربح',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (211,135,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (212,135,'in_det_breakdown_id','العطل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (213,135,'in_det_item_latin','الاسم اللاتيني',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (214,135,'in_det_item_source','المصدر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (215,135,'in_det_item_company','الشركة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (216,135,'in_det_qty_equal','التعادل',-1,0,0,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (217,135,'in_det_addition_per','نسبة الاضافة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (218,135,'in_det_addition','قيمة مضافة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (219,135,'in_det_tax_per','نسبة الضريبة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (220,135,'in_det_tax','ضريبة مضافة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (221,135,'in_det_total_net','الصافي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (222,135,'in_det_cost','تكلفة افرادية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (223,135,'in_det_cost_total','تكلفة اجمالية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (224,135,'in_det_date_exp_hij','تاريخ الصلاحية هجري',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (225,135,'in_det_win_perc','نسبة الربح',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (226,135,'in_det_one_serial','السيريال',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (227,135,'in_det_qty','الكمية الاساسية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (228,135,'calc_it_location','الموقع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (229,135,'in_det_price_one','سعر الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (230,135,'in_det_item_warranty','الكفالة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (231,135,'it_cl_name','الفئة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (232,135,'item_qty_now','الكمية الحالية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (233,135,'it_desc','المواصفات',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (234,135,'it_un_price_sell_a','سعر المبيع العام',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (235,135,'it_un_price_sell_b','سعر الجملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (236,135,'it_un_price_sell_c','سعر نصف الجملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (237,135,'it_un_price_sell_d','سعر التصدير',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (238,135,'it_un_price_sell_e','سعر المستهلك',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (239,135,'it_measure','القياس',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (240,135,'calc_qty_remain','الكمية المتبقية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (241,135,'calc_qty_delivery','الكمية المسلمة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (242,135,'in_det_ref','المرجع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (243,136,'auto_id','مسلسل',63,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,920,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (244,136,'account_name','الموظف',220,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,920,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (245,136,'emp_payroll_det_salary','الراتب',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,408,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (246,136,'emp_payroll_det_advance','السلف',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,408,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (247,136,'emp_payroll_det_paid','الصافي للدفع',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,408,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (248,136,'currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,408,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (249,136,'emp_payroll_det_cur_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,408,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (250,136,'emp_payroll_det_notice','ملاحظة',235,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,920,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (251,136,'emp_payroll_det_doc','وثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,408,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (252,136,'emp_payroll_det_over_minute','الاضافي',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (253,136,'emp_payroll_det_over_value','قيمة الاضافي',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (254,136,'emp_payroll_det_delay_minute','التاخير',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (255,136,'emp_payroll_det_delay_value','قيمة التاخير',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (256,136,'emp_payroll_det_absence_minute','الغياب',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (257,136,'emp_payroll_det_absence_value','قيمة الغياب',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (258,136,'emp_payroll_det_salary_attend','الراتب المستحق',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (259,136,'emp_payroll_det_reward','المكافآت',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (260,136,'emp_payroll_det_deduction','الحسميات',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (261,137,'gl_source','النوع',92,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (262,137,'ba_list_xid','الرقم',50,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (263,137,'ba_list_date','التاريخ',70,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (264,137,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (265,137,'ac_code','رمز الحساب',61,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (266,137,'ac_name','اسم الحساب',114,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,656,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (267,137,'ac_full_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (268,137,'gl_currency_debit_main','مدين',80,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (269,137,'gl_currency_credit_main','دائن',80,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (270,137,'gl_desc','البيان',167,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (271,137,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (272,137,'gl_debit','العملة مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (273,137,'gl_credit','العملة دائن',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (274,137,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (275,137,'ba_list_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (276,138,'ba_list_xid','الرقم العام',48,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (277,138,'ac_full_name','الحساب',182,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (278,138,'ba_list_number','رقم السند',51,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (279,138,'gl_source','النوع',85,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (280,138,'batch_date','التاريخ',72,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (281,138,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (282,138,'gl_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (283,138,'ac_code','رمز الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (284,138,'ac_name','اسم الحساب',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (285,138,'gl_currency_debit_main','مدين',67,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (286,138,'gl_currency_credit_main','دائن',65,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (287,138,'gl_desc','البيان',134,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (288,138,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (289,138,'gl_debit','العملة مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (290,138,'gl_credit','العملة دائن',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (291,138,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (292,138,'gl_balance','الرصيد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (293,139,'ac_full_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (294,139,'ac_code','رمز الحساب',96,1,2,'12632256','Tahoma',8,0,-16777208,1,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (295,139,'ac_name','اسم الحساب',236,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,656,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (296,139,'gl_currency_debit_main','مجموع مدين',90,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (297,139,'gl_currency_credit_main','مجموع دائن',90,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (298,139,'gl_debit_temp','مجموع رصيد مدين',90,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (299,139,'gl_credit_temp','مجموع رصيد دائن',90,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (300,140,'ba_list_xid','الرقم العام',61,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (301,140,'batch_id','رقم السند',58,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (302,140,'gl_source','النوع',97,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (303,140,'ba_list_date','التاريخ',70,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (304,140,'gl_currency_debit_main','مدين',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (305,140,'gl_currency_credit_main','دائن',68,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (306,140,'gl_desc','البيان',185,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (307,140,'gl_balance','الرصيد',104,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (308,140,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (309,140,'gl_debit','العملة مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (310,140,'gl_credit','العملة دائن',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (311,140,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (312,140,'ba_list_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (313,140,'in_det_item_name','اسم المادة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (314,140,'in_det_unit_name','الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (315,140,'in_det_qty_rec','الكمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (316,140,'in_det_price','السعر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (317,140,'in_det_discount','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (318,140,'in_det_total','المجموع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (319,140,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (320,140,'in_det_gift','الهدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (321,140,'gl_ac_id_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (322,140,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (323,140,'gl_ac_id_opp_name','الحساب المقابل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (324,140,'gl_doc','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (325,140,'gl_qty','كمية - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (326,140,'gl_price','سعر - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (327,140,'gl_balance_currnecy','رصيد عملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (328,140,'percent_pay','%المبلغ الى الرصيد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (329,141,'ba_list_xid','الرقم العام',54,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (330,141,'batch_id','رقم السند',50,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (331,141,'gl_source','النوع',115,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (332,141,'ba_list_date','التاريخ',70,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (333,141,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (334,141,'gl_currency_debit_main','مدين',78,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (335,141,'gl_currency_credit_main','دائن',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (336,141,'gl_desc','البيان',171,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (337,141,'gl_balance','الرصيد',94,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (338,141,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (339,141,'gl_debit','العملة مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (340,141,'gl_credit','العملة دائن',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (341,141,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (342,141,'ba_list_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (343,141,'in_det_item_name','اسم المادة',131,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (344,141,'in_det_unit_name','الوحدة',34,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (345,141,'in_det_qty_rec','الكمية',51,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (346,141,'in_det_price','السعر',58,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (347,141,'in_det_discount','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (348,141,'in_det_total','المجموع',74,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (349,141,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (350,141,'in_det_gift','الهدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (351,141,'percent_pay','%المبلغ الى الرصيد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (352,141,'gl_ac_id_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (353,141,'gl_ac_id_opp_name','الحساب المقابل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (354,141,'gl_doc','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (355,141,'gl_qty','كمية - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (356,141,'gl_price','سعر - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (357,141,'gl_balance_currnecy','رصيد عملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (358,144,'auto_id','مسلسل',54,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (359,144,'ac_code','رمز الحساب',86,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (360,144,'ac_name','اسم الحساب',216,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,656,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (361,144,'ac_fullname','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (362,144,'gl_debit','مدين ارصدة',89,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (363,144,'gl_credit','دائن ارصدة',83,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (364,144,'sum_debit','مدين مجاميع',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (365,144,'sum_credit','دائن مجاميع',94,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (366,145,'ba_list_xid','الرقم العام',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (367,145,'ac_full_name','مركز الكلفة',139,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (368,145,'ba_list_number','رقم السند',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (369,145,'gl_source','النوع',118,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (370,145,'batch_date','التاريخ',72,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (371,145,'ac_code','رمز المركز',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (372,145,'ac_name','مركز الكلفة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (373,145,'gl_currency_debit_main','مدين',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (374,145,'gl_currency_credit_main','دائن',68,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (375,145,'gl_desc','البيان',182,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (376,145,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (377,145,'gl_debit','العملة مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (378,145,'gl_credit','العملة دائن',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (379,145,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (380,145,'gl_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (381,145,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (382,146,'ac_code','رمز الحساب',106,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (383,146,'ac_name','اسم الحساب',315,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (384,146,'ac_full_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (385,146,'debit','مدين',119,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (386,146,'credit','دائن',160,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (387,147,'in_list_number','رقم الفاتورة',53,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (388,147,'in_list_seq','متسلسل الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (389,147,'in_list_date','التاريخ',76,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (390,147,'in_type_name','النوع',82,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (391,147,'st_name','المستودع',97,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (392,147,'it_name','المادة',136,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (393,147,'un_name','الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (394,147,'in_det_qty_rec_in','كمية داخلة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (395,147,'in_det_qty_rec_out','كمية خارجة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (396,147,'in_det_price','السعر الافرادي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (397,147,'calc_total','السعر الاجمالي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (398,147,'in_det_gift','هدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (399,147,'in_list_reference','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (400,147,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (401,147,'cu_name','اسم العميل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (402,147,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (403,147,'in_det_qty','كمية اساسية',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (404,147,'item_balance','الرصيد',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (405,147,'in_list_time','الوقت',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (406,147,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (407,147,'in_det_ref','رقم مرجع الاصناف',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (408,147,'it_un_name','الوحدة الاساسية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (409,147,'in_det_qty_rec_in_main','كمية داخلة اساسية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (410,147,'in_det_qty_rec_out_main','كمية خارجة اساسية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (411,147,'in_det_price_main','سعر الوحدة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (412,147,'cur_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (413,147,'in_det_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (414,147,'currency_in_det_price','سعر افرادي - عملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (415,147,'currency_in_det_price_main','سعر الوحدة - عملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (416,147,'currency_calc_total','سعر اجمالي - عملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (417,150,'it_code','رمز المادة',59,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (418,150,'it_name','المادة',200,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (419,150,'un_name','الوحدة',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (420,150,'in_det_qty_in','كمية ادخال',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (421,150,'calc_total_in','قيمة ادخال',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (422,150,'in_det_gift_in','هدايا ادخال',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (423,150,'in_det_qty_out','كمية اخراج',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (424,150,'calc_total_out','قيمة اخراج',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (425,150,'in_det_def_qty','فرق كمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (426,150,'in_det_def_amount','فرق قيمة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (427,150,'it_buy','سعر شراء',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (428,150,'it_sell','سعر بيع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (429,150,'in_det_gift_out','هدايا اخراج',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (430,150,'in_det_in_price','سعر الادخال',64,1,2,'16575446','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (431,150,'in_det_out_price','سعر الاخراج',64,1,2,'14152180','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (432,150,'max_price_in','اعلى سعر ادخال',-1,0,2,'16575446','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (433,150,'min_price_in','ادنى سعر ادخال',-1,0,2,'16575446','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (434,150,'max_price_out','اعلى سعر اخراج',-1,0,2,'14152180','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (435,150,'min_price_out','ادنى سعر اخراج',-1,0,2,'14152180','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (436,150,'in_det_serials_in','الارقام التسلسلية - ادخال',-1,0,2,'16575446','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (437,150,'in_det_serials_out','الارقام التسلسلية - اخراج',-1,0,0,'14152180','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (438,151,'in_list_number','رقم الفاتورة',61,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (439,151,'in_list_seq','متسلسل الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (440,151,'in_list_date','التاريخ',80,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (441,151,'in_type_name','النوع',85,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (442,151,'st_name','المستودع',102,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (443,151,'it_name','المادة',127,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (444,151,'un_name','الوحدة',56,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (445,151,'in_det_qty_rec_in','كمية داخلة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (446,151,'in_det_qty_rec_out','كمية خارجة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (447,151,'in_det_price','السعر الافرادي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (448,151,'calc_total','السعر الاجمالي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (449,151,'in_list_reference','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (450,151,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (451,151,'cu_name','اسم العميل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (452,151,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (453,151,'in_det_qty','كمية اساسية',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (454,151,'item_balance','رصيد كمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (455,151,'item_balance_price','رصيد سعر',-1,0,0,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (456,151,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (457,152,'store_name','المادة',316,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (458,152,'it_un_name','الوحدة الاساسية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (459,152,'item_count_in','الكمية الداخلة',81,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (460,152,'item_count_out','الكمية الخارجة',86,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (461,152,'item_count','الكمية الحالية',77,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (462,152,'item_price','السعر الافرادي',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (463,152,'item_price_total','السعر الاجمالي',79,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (464,152,'item_count_undo_sell','مرتجع مبيع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (465,152,'item_count_undo_buy','مرتجع شراء',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (466,153,'in_list_number','رقم الفاتورة',57,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (467,153,'in_list_date','التاريخ',71,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (468,153,'in_type_name','النوع',112,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (469,153,'cu_name','اسم العميل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (470,153,'in_list_reference','الوثيقة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (471,153,'in_list_payment_type','طريقة الدفع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (472,153,'in_list_total','مجموع الفاتورة',77,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (473,153,'in_list_discount_total','حسم الفاتورة',69,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (474,153,'in_list_net','اجمالي الفاتورة',76,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (475,153,'item_sell_price','قيمة المبيع',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (476,153,'item_cost_price','التكلفة',67,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (477,153,'it_name','المادة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (478,153,'in_det_qty_rec','الكمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (479,153,'in_det_price','السعر الافرادي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (480,153,'in_det_discount','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (481,153,'discount_value','قيمة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (482,153,'calc_total','السعر الاجمالي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (483,153,'in_det_gift','هدايا',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (484,153,'in_det_notice','ملاحظة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (485,153,'un_name','الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (486,153,'win_value','الربح',55,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (487,153,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (488,153,'win_percent','نسبة الربح',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (489,154,'in_list_number','رقم الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (490,154,'in_list_seq','متسلسل الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (491,154,'in_list_date','التاريخ',-1,0,2,'12632256','Tahoma',8,0,-16777208,1,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (492,154,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (493,154,'in_type_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (494,154,'in_list_payment_type','طريقة الدفع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (495,154,'cu_name','اسم العميل',86,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (496,154,'in_list_reference','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (497,154,'in_list_total','مجموع الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (498,154,'in_list_discount_total','حسم الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (499,154,'in_list_net','اجمالي الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,0,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (500,154,'item_sell_price','قيمة المبيع',63,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,'');
COMMIT;

INSERT INTO tbl_grid_desgin_det (tc_id, tc_list_id, tc_field_name, tc_caption, tc_width, tc_visible, tc_title_align, tc_title_color, tc_title_font_name, tc_title_font_size, tc_title_font_style, tc_title_font_color, tc_align, tc_color, tc_font_name, tc_font_size, tc_font_style, tc_font_color, tc_assigned_values, tc_title_layout, tc_title_rot_angle, tc_title_word_warp, tc_title_bidimode, tc_title_transparent, tc_title_line_width, tc_title_line_color, tc_title_pos, tc_layout, tc_rot_angle, tc_word_warp, tc_bidimode, tc_transparent, tc_line_width, tc_line_color, tc_line_pos, tc_cond_color, tc_cond_font_name, tc_cond_font_size, tc_cond_font_style, tc_cond_font_color, tc_cond_condition) VALUES
  (501,154,'item_cost_price','التكلفة',63,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (502,154,'win_value','الربح',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (503,154,'in_det_win_perc','نسبة الربح',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (504,154,'it_name','المادة',122,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (505,154,'un_name','الوحدة',46,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (506,154,'in_det_qty_rec','الكمية',63,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (507,154,'in_det_price','السعر',63,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (508,154,'in_det_discount','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (509,154,'discount_value','قيمة الحسم',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (510,154,'calc_total','الاجمالي',63,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,656,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (511,154,'in_det_gift','هدايا',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (512,154,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,0,255,'Tahoma',8,1,-16777208,''),
  (513,155,'item_code','رمز المادة',76,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (514,155,'item_name','المادة',151,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (515,155,'in_ser_serial','السيريال',209,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (516,155,'in_list_number','رقم الفاتورة',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (517,155,'in_type_name','نوع الفاتورة',118,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (518,155,'un_name','الوحدة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (519,155,'class_name','الفئة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (520,155,'store_name','المستودع',67,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (521,156,'it_code','رمز المادة',92,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (522,156,'item_name','اسم المادة',148,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (523,156,'it_un_name','الوحدة',63,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (524,156,'cl_name','الفئة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (525,156,'st_name','المستودع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (526,156,'sum_item_in_count','الكمية المشتراة',55,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (527,156,'buy_date','تاريخ الشراء',61,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (528,156,'in_det_date_exp','تاريخ الصلاحية',61,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (529,156,'expiry_days','عدد الايام',52,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (530,156,'sum_current_balance','الكمية الحالية',54,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (531,156,'item_price','السعر',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (532,156,'sum_price','اجمالي السعر',55,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (533,157,'ac_full_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (534,157,'ac_code','رمز الحساب',80,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (535,157,'ac_name','اسم الحساب',152,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (536,157,'gl_balance','الرصيد',98,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,656,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (537,157,'balance_30','30 يوم',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (538,157,'balance_60','60 يوم',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (539,157,'balance_90','90',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (540,157,'balance_120','120 يوم',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (541,157,'balance_more','اكثر من 120',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (542,158,'store_name','المادة',400,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (543,158,'it_un_name','الوحدة الاساسية',88,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (544,158,'item_count','الكمية الحالية',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (545,158,'limit_value','الحد المطلوب',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (546,158,'wanted_amount','فرق الكمية',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (547,159,'cu_name','اسم العميل',159,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (548,159,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (549,159,'ins_date','التاريخ',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (550,159,'ins_time','الوقت',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (551,159,'ins_value','القسط',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (552,159,'ins_balance','الرصيد',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (553,159,'ins_notes','البيان',218,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (554,159,'account_name','اسم الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (555,159,'group_name','المجموعة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (556,159,'cu_company','الشركة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (557,159,'cu_work','العمل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (558,159,'cu_address','العنوان',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (559,159,'cu_country','الدولة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (560,159,'cu_city','المدينة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (561,159,'cu_region','المنطقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (562,159,'cu_street','الشارع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (563,159,'cu_country_zip','مفتاح الدولة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (564,159,'cu_city_key','مفتاح المدينة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (565,159,'cu_phone1','هاتف 1',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (566,159,'cu_phone2','هاتف 2',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (567,159,'cu_mobile1','جوال 1',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (568,159,'cu_mobile2','جوال 2',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (569,159,'cu_fax','فاكس',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (570,159,'cu_email','بريد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (571,159,'cu_web','ويب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (572,159,'cu_box','صندوق البريد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (573,159,'cu_type','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (574,159,'us_full_name','المستخدم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (575,159,'ins_post','تم القبض',82,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (576,159,'ins_cancel','تم الاهمال',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (577,160,'audit_sysdate','التاريخ و الوقت',134,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (578,160,'type_name','نوع العملية',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (579,160,'audit_user_id','المستخدم',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (580,160,'audit_computer','الكمبيوتر',95,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (581,160,'audit_form_caption','النافذة',120,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (582,160,'audit_comment','البيان',188,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (583,161,'audit_sysdate','التاريخ و الوقت',144,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (584,161,'audit_form_caption','النافذة',141,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (585,161,'audit_comment','البيان',420,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (586,162,'it_code','الرمز',127,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (587,162,'it_name','اسم المادة',262,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (588,162,'it_unit','الوحدة',52,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (589,162,'it_barcode','الباركود',-1,0,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (590,162,'it_class','الفئة',106,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (591,162,'it_un_equal','التعادل',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (592,162,'it_un_price_sell_a','سعر المبيع',64,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (593,162,'it_un_price_sell_b','سعر الجملة',-1,0,0,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (594,162,'it_un_price_sell_c','سعر ن/الجملة',-1,0,0,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (595,162,'it_un_price_sell_d','سعر التصدير',-1,0,0,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (596,162,'it_un_price_sell_e','سعر المستهلك',-1,0,0,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (597,162,'it_location','الموقع',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (598,162,'it_used_desc','استخدام المادة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (599,162,'it_warranty_desc','الكفالة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (600,162,'it_balance_qty','الكمية',64,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (601,163,'auto_id','#',40,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (602,163,'item_name','المادة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (603,163,'calc_item_code','رمز المادة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (604,163,'calc_item_name','اسم المادة',116,1,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (605,163,'un_name','الوحدة',44,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (606,163,'in_det_qty_rec','الكمية',58,1,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (607,163,'in_det_price','السعر الافرادي',87,1,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (608,163,'in_det_discount','نسبة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (609,163,'discount_value','قيمة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (610,163,'calc_total','السعر الاجمالي',101,1,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (611,163,'in_det_gift','هدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (612,163,'in_det_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (613,163,'in_det_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (614,163,'in_det_barcode','الباركود',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (615,163,'in_det_date_mfg','تاريخ الانتاج',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (616,163,'in_det_date_exp','تاريخ الصلاحية',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1432,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (617,163,'in_det_notice','ملاحظة',165,1,2,'12632256','Tahoma',8,0,-16777208,0,15329769,'Tahoma',8,0,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (618,165,'auto_id','م',61,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (619,165,'gl_account_name','الحساب',220,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (620,165,'gl_credit','مقبوضات',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (621,165,'gl_debit','مدفوعات',76,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (622,165,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (623,165,'gl_currency_val','التعادل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (624,165,'currency_total','قيمة العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (625,165,'gl_cost_center','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (626,165,'gl_desc','البيان',288,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (627,165,'gl_doc','وثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (628,165,'gl_qty','الكمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (629,165,'gl_price','السعر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (630,165,'gl_note_id','ورقة مالية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (631,165,'gl_orgin_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (632,166,'auto_id','م',60,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (633,166,'gl_account_name','الحساب',220,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (634,166,'gl_debit','مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (635,166,'gl_credit','المبلغ',130,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (636,166,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (637,166,'gl_currency_val','التعادل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (638,166,'currency_total','قيمة العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (639,166,'gl_cost_center','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (640,166,'gl_desc','البيان',301,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (641,166,'gl_doc','وثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (642,166,'gl_qty','الكمية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (643,166,'gl_price','السعر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (644,166,'gl_note_id','ورقة مالية',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (645,166,'gl_orgin_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (646,169,'note_type_name','نوع الورقة',90,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (647,169,'ac_full_name','الحساب',149,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (648,169,'note_det_ref1','الوثيقة',88,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (649,169,'note_det_ref2','الاشعار',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (650,169,'note_det_date','التاريخ',86,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (651,169,'note_det_value','قيمة الدفعة',77,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (652,169,'note_det_desc','البيان',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (653,169,'note_det_paid','مدفوعة',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (654,169,'note_det_paid_wait','مستحقة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (655,170,'auto_id','م',30,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (656,170,'note_det_ref1','الوثيقة',99,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (657,170,'note_det_ref2','الاشعار',99,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (658,170,'note_det_date','التاريخ',88,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (659,170,'note_det_value','قيمة الدفعة',72,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (660,170,'note_det_desc','ملاحظة',319,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (661,170,'note_det_paid','مسددة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (662,170,'note_det_paid_wait','مستحقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (663,180,'auto_id','#',25,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,1,-16777208,1944,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (664,180,'in_det_class_id','الفئة',156,1,2,'12632256','Tahoma',9,1,-16777208,0,0,'Tahoma',8,1,-16777208,924,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (665,180,'in_det_item_name','المادة',208,1,2,'12632256','Tahoma',9,1,-16777208,2,0,'Times New Roman',12,1,-16777208,924,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (666,180,'in_det_qty_rec','الكمية',41,1,2,'12632256','Tahoma',9,1,-16777208,2,0,'Tahoma',8,1,-16777208,924,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (667,180,'in_det_price','السعر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (668,180,'calc_total','الاجمالي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (669,180,'in_det_warranty','الكفالة',66,1,2,'12632256','Tahoma',8,1,-16777208,2,0,'Times New Roman',11,1,-16777208,924,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (670,180,'in_det_serial','السيريال',122,1,2,'12632256','Tahoma',8,1,-16777208,0,0,'Tahoma',10,1,-16777208,924,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (671,180,'in_det_notice','ملاحظة',100,1,2,'12632256','Tahoma',8,1,-16777208,2,0,'Tahoma',10,1,-16777208,924,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (672,182,'auto_id','#',28,1,2,'-16777201','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1720,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (673,182,'ord_det_item_code','رمز المادة',76,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (674,182,'ord_det_item_name','اسم المادة',178,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (675,182,'ord_det_item_unit','الوحدة',48,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (676,182,'ord_det_qty_rec','الكمية',64,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (677,182,'ord_det_price','السعر الافرادي',76,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (678,182,'ord_det_discount','نسبة الحسم',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (679,182,'ord_det_discount_val','قيمة الحسم',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (680,182,'ord_det_total_val','السعر الاجمالي',82,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (681,182,'ord_det_gift','هدايا',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (682,182,'ord_det_cost','تكلفة افرادية',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (683,182,'ord_det_cost_total','تكلفة اجمالية',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (684,182,'ord_det_barcode','الباركود',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (685,182,'ord_det_date_mfg','تاريخ الانتاج',-1,0,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (686,182,'ord_det_date_exp','تاريخ الصلاحية',-1,0,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (687,182,'ord_det_length','الطول',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (688,182,'ord_det_width','العرض',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (689,182,'ord_det_height','الارتفاع',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (690,182,'ord_det_win','الربح',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (691,182,'ord_det_notice','ملاحظة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (692,182,'ord_det_item_latin','الاسم اللاتيني',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (693,182,'ord_det_item_source','المصدر',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (694,182,'ord_det_item_company','الشركة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (695,182,'ord_det_qty_equal','التعادل',-1,0,0,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (696,182,'calc_it_location','الموقع',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (697,182,'calc_it_price_sell_e','سعر المستهلك',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (698,182,'calc_qty_delivery','الكمية المسلمة',77,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (699,182,'calc_qty_remain','الكمية المتبقية',82,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (700,183,'auto_id','#',29,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (701,183,'adv_prc_det_item_code','رمز المادة',77,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (702,183,'adv_prc_det_item_name','اسم المادة',172,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (703,183,'adv_prc_det_item_unit','الوحدة',63,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (704,183,'adv_prc_det_qty_rec','الكمية',62,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (705,183,'adv_prc_det_price','السعر الافرادي',78,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (706,183,'adv_prc_det_discount','نسبة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (707,183,'adv_prc_det_discount_val','قيمة الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (708,183,'adv_prc_det_total_val','السعر الاجمالي',80,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (709,183,'adv_prc_det_gift','هدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (710,183,'adv_prc_det_cost','تكلفة افرادية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (711,183,'adv_prc_det_cost_total','تكلفة اجمالية',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (712,183,'adv_prc_det_barcode','الباركود',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (713,183,'adv_prc_det_date_mfg','تاريخ الانتاج',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (714,183,'adv_prc_det_date_exp','تاريخ الصلاحية',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (715,183,'adv_prc_det_length','الطول',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (716,183,'adv_prc_det_width','العرض',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (717,183,'adv_prc_det_height','الارتفاع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (718,183,'adv_prc_det_win','الربح',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (719,183,'adv_prc_det_notice','ملاحظة',157,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (720,183,'adv_prc_det_item_latin','الاسم اللاتيني',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (721,183,'adv_prc_det_item_source','المصدر',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (722,183,'adv_prc_det_item_company','الشركة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (723,183,'adv_prc_det_qty_equal','التعادل',-1,0,0,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (724,183,'calc_it_location','الموقع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (725,183,'calc_it_price_sell_e','سعر المستهلك',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (726,185,'auto_id','#',34,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (727,185,'in_type_name','النوع',105,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (728,185,'adv_prc_list_checked','مدققة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (729,185,'adv_prc_list_checked_user_name','المدقق',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (730,185,'adv_prc_list_id','الرقم',56,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (731,185,'adv_prc_list_date','التاريخ',75,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (732,185,'adv_prc_list_time','الوقت',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (733,185,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (734,185,'cu_name','العميل',162,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (735,185,'adv_prc_list_total','المجموع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (736,185,'adv_prc_list_discount_total','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (737,185,'adv_prc_list_net','الصافي',78,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (738,185,'adv_prc_list_desc','البيان',193,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (739,185,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (740,185,'currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (741,185,'adv_prc_currency_val','تعادل العملة',-1,0,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (742,185,'adv_prc_list_reference','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (743,185,'us_full_name','المستخدم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (744,186,'auto_id','#',34,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (745,186,'in_type_name','النوع',106,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (746,186,'ord_list_checked','مدققة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (747,186,'ord_list_checked_user_name','المدقق',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (748,186,'ord_list_id','الرقم',64,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (749,186,'ord_list_date','التاريخ',64,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (750,186,'ord_list_time','الوقت',-1,0,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (751,186,'fld_day','اليوم',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (752,186,'ord_list_status','حالة الطلب',64,1,2,'-16777201','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (753,186,'cu_name','العميل',160,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (754,186,'ord_list_total','المجموع',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (755,186,'ord_list_discount_total','الحسم',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (756,186,'ord_list_net','الصافي',64,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (757,186,'ord_list_desc','البيان',148,1,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,696,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (758,186,'ag_name','المندوب',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (759,186,'ord_list_shipper_name','شركة الشحن',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (760,186,'currency_name','العملة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (761,186,'ord_currency_val','تعادل العملة',-1,0,0,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,176,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (762,186,'ord_list_reference','الوثيقة',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (763,186,'us_full_name','المستخدم',-1,0,2,'-16777201','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,184,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (764,187,'ord_list_number','الرقم',58,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (765,187,'ord_list_seq','متسلسل الفاتورة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (766,187,'ord_list_date','التاريخ',76,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (767,187,'ord_list_time','الوقت',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (768,187,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (769,187,'in_type_name','النوع',82,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (770,187,'st_name','المستودع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (771,187,'it_name','المادة',136,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (772,187,'un_name','الوحدة',38,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (773,187,'ord_det_qty_rec_in','كمية داخلة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (774,187,'ord_det_qty_rec_out','كمية خارجة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (775,187,'ord_det_price','السعر الافرادي',70,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (776,187,'calc_total','السعر الاجمالي',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (777,187,'ord_det_gift','هدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (778,187,'ord_list_reference','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (779,187,'ord_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (780,187,'cu_name','اسم العميل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (781,187,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (782,187,'ord_det_qty','كمية اساسية',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (783,187,'item_balance','الرصيد',60,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (784,188,'ba_list_xid','الرقم العام',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (785,188,'gl_source','النوع',107,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (786,188,'ba_list_date','التاريخ',72,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (787,188,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (788,188,'ac_code','رمز الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,1,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (789,188,'ac_name','اسم الحساب',142,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (790,188,'gl_currency_debit_main','مدين',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (791,188,'gl_currency_credit_main','دائن',68,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (792,188,'gl_doc','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (793,188,'gl_desc','البيان',182,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (794,188,'gl_debit','العملة مدين',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (795,188,'gl_credit','العملة دائن',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (796,188,'gl_qty','كمية - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (797,188,'gl_price','سعر - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (798,188,'gl_currency_name','العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (799,188,'ba_list_currency_val','تعادل العملة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (800,188,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (801,188,'ba_list_post','مرحلة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (802,188,'gl_orgin_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (803,190,'store_name','المادة',167,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (804,190,'it_un_name','الوحدة',55,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (805,190,'item_count_in','الكمية الداخلة',76,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (806,190,'item_count_out','الكمية الخارجة',78,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (807,190,'item_count_undo_sell','مرتجع مبيع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (808,190,'item_count_undo_buy','مرتجع شراء',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (809,190,'item_count','الكمية الحالية',79,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (810,190,'item_price','السعر الافرادي',78,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (811,190,'item_price_total','السعر',54,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (812,190,'invoice_count_in','فواتير الادخال',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (813,190,'invoice_count_out','فواتير الاخراج',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (814,191,'auto_id','#',38,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (815,191,'in_list_count','عدد الفواتير',61,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (816,191,'in_type_name','النوع',136,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (817,191,'in_list_total','المجموع',83,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (818,191,'in_list_discount_total','الحسم',79,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (819,191,'in_list_net','الصافي',100,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (820,191,'in_list_payment','دفعة',100,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (821,191,'in_list_remain','الباقي',100,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (822,191,'cu_name','العميل',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (823,191,'ag_name','المندوب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (824,191,'st_name','المستودع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (825,191,'us_full_name','المستخدم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (826,201,'auto_id','#',27,1,2,'12632256','Tahoma',8,0,-16777208,2,15329769,'Tahoma',8,0,-16777208,1688,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (827,201,'in_det_item_code','الرمز',74,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (828,201,'in_det_item_name','المادة',190,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (829,201,'in_det_item_unit','الوحدة',45,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (830,201,'in_det_qty_rec','الكمية الحالية',68,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (831,201,'in_det_qty_real','الكمية الفعلية',73,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (832,201,'in_det_qty_neg','كمية ادخال',55,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (833,201,'in_det_qty_pos','كمية اخراج',57,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (834,201,'in_det_price','السعر',56,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (835,201,'in_det_total','الاجمالي',63,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (836,201,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (837,202,'auto_id','#',43,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (838,202,'charge_acc_name','شركة الشحن',137,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (839,202,'cust_acc_name','العميل',142,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (840,202,'chr_det_value','المبلغ',75,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (841,202,'chr_det_doc','الاشعار',79,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (842,202,'chr_det_notice','البيان',230,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (843,203,'auto_id','#',29,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (844,203,'acc_name','الحساب',130,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (845,203,'exc_det_cur_name','العملة',50,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (846,203,'exc_det_cur_val','التعادل',42,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (847,203,'exc_det_value','المبلغ المحول',68,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (848,203,'exc_det_value_yield','المبلغ الناتج',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (849,203,'exc_det_cur_name_out','عملة التحويل',67,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (850,203,'exc_det_cur_val_out','سعر الصرف',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (851,203,'exc_det_doc','الوثيقة',67,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (852,203,'exc_det_notice','البيان',124,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (853,204,'batch_id','رقم السند',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (854,204,'ba_list_xid','الرقم العام',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (855,204,'gl_source','النوع',93,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (856,204,'ba_list_date','التاريخ',72,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (857,204,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (858,204,'gl_doc','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (859,204,'gl_desc','البيان',145,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (860,204,'gl_debit','العملة مدين',84,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (861,204,'gl_credit','العملة دائن',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (862,204,'gl_qty','كمية - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (863,204,'gl_price','سعر - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (864,204,'gl_balance_currnecy','رصيد عملة',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (865,204,'gl_currency_name','العملة',40,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (866,204,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (867,204,'percent_pay','%المبلغ الى الرصيد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (868,204,'gl_currency_val','تعادل العملة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (869,205,'batch_id','رقم السند',-1,0,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (870,205,'ba_list_xid','الرقم العام',64,1,0,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,144,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (871,205,'gl_source','النوع',93,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (872,205,'ba_list_date','التاريخ',72,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (873,205,'fld_day','اليوم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (874,205,'gl_doc','الوثيقة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (875,205,'gl_desc','البيان',139,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (876,205,'gl_debit','العملة مدين',84,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (877,205,'gl_credit','العملة دائن',87,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (878,205,'gl_qty','كمية - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (879,205,'gl_price','سعر - سند',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (880,205,'gl_balance_currnecy','رصيد عملة',73,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (881,205,'gl_currency_name','العملة',40,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (882,205,'gl_cost_center_name','مركز الكلفة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (883,205,'percent_pay','%المبلغ الى الرصيد',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (884,205,'in_det_item_name','اسم المادة',105,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (885,205,'in_det_unit_name','الوحدة',45,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (886,205,'in_det_qty_rec','الكمية',48,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (887,205,'in_det_price','السعر',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (888,205,'in_det_discount','الحسم',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (889,205,'in_det_total','المجموع',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (890,205,'in_det_notice','ملاحظة',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (891,205,'in_det_gift','الهدايا',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (892,205,'gl_currency_val','تعادل العملة',64,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (893,206,'ac_full_name','الحساب',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (894,206,'ac_code','رمز الحساب',82,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (895,206,'ac_name','اسم الحساب',164,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (896,206,'cur_name','العملة',55,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (897,206,'gl_currency_debit_main','مجموع مدين',96,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (898,206,'gl_currency_credit_main','مجموع دائن',99,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (899,206,'gl_debit_temp','مجموع رصيد مدين',93,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (900,206,'gl_credit_temp','مجموع رصيد دائن',108,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (901,207,'auto_id','#',35,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (902,207,'cheque_list_ac_cust_name','حساب العميل',115,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (903,207,'cheque_det_number','رقم الشيك',86,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (904,207,'cheque_det_date_deposit','تاريخ الشيك',73,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (905,207,'cheque_det_owner','اسم صاحب الشيك',116,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (906,207,'cheque_det_value','قيمة الشيك',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (907,207,'cu_name','عملة الشيك',60,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (908,207,'cheque_det_curr_val','سعر الصرف',57,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (909,207,'cheque_det_desc','البيان',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (910,207,'cheque_det_status','حالة الشيك',90,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (911,207,'note_type_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (912,208,'auto_id','#',35,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (913,208,'cheque_list_ac_cust_name','حساب العميل',128,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (914,208,'cheque_det_number','رقم الشيك',99,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (915,208,'cheque_det_date_deposit','تاريخ الشيك',89,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (916,208,'cheque_det_owner','اسم صاحب الشيك',116,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (917,208,'cheque_det_value','قيمة الشيك',66,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (918,208,'cu_name','عملة الشيك',60,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (919,208,'cheque_det_curr_val','سعر الصرف',57,1,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,664,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (920,208,'cheque_det_desc','البيان',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (921,208,'cheque_det_status','حالة الشيك',64,1,2,'12632256','Tahoma',8,0,-16777208,2,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,''),
  (922,208,'note_type_name','النوع',-1,0,2,'12632256','Tahoma',8,0,-16777208,0,0,'Tahoma',8,0,-16777208,152,1,0,1,1,0,1,0,15,1,0,1,1,1,1,0,15,255,'Tahoma',8,1,-16777208,'');
COMMIT;

INSERT INTO tbl_option (op_id, op_type, op_const, op_value, op_desc, op_computer, op_userid, op_datetime, op_blob) VALUES
  (1,1,'3DC2FF83-B451-44C4-A079-83AFA4BD3855','10CBF62A-39F5-4526-9756-A2242FCE6283','','',0,'2018-06-13 13:38:12',NULL);
COMMIT;

INSERT INTO tbl_quid (quid_id, quid_value) VALUES
  (1,'AE42FBA8-5413-4278-A126-F6CACC2369AC'),
  (2,'D35CD46E-0D53-4939-B387-9D42CC878C25'),
  (3,'6AEECDC5-2E3D-4153-9205-E831D1B7CD2E'),
  (4,'5B3B3035-BC11-4DCE-AAB2-48712264E474'),
  (5,'64C62B4E-3C9A-44E0-BADD-80CD71FB5201'),
  (6,'88125953-4DCE-421B-90F1-E34CFF8B5742'),
  (7,'8A6BB71F-C4DA-42A9-B3AF-FC20FE0467F0'),
  (8,'8CE32465-456A-40E1-8F70-9A226F100EDF'),
  (9,'2A68E1A3-72E6-4F0B-8118-4B67FE636C9D'),
  (10,'1D66910E-EA6A-4920-9267-006B55A9AEE5'),
  (11,'64D261C7-2AA8-4299-BF2F-B4D81B9C654A'),
  (12,'34C0B97D-63DF-40AB-842C-7E948869BFD3'),
  (13,'1555FC8F-ECFF-4A7B-8735-4790BCB9AB52'),
  (14,'A7E5134B-178D-4416-ADD9-B045223CC6A7'),
  (15,'C0FB81B7-DF9C-4C9F-8CE5-894AA5DAA8CE'),
  (16,'CB192452-CB17-4278-B041-014343AE37EF'),
  (17,'D5CCD423-391F-4AEE-A01E-D1B3C273D9DD'),
  (18,'276F007E-0B3E-42C1-B233-6DA8287E90DE'),
  (19,'7D2A4870-7127-402B-8C34-840C22411125'),
  (20,'873F2C1E-786D-40A5-8D0D-44D7D947181D'),
  (21,'A464728E-BCAD-40DC-88CE-2F0E15887183'),
  (22,'D7A07626-9E34-434B-9A8D-8F80A51AEE50'),
  (23,'1EEBD99E-74D3-4539-896A-0CCC42CB5721'),
  (24,'701591FE-3425-415A-8333-0A955B047D44'),
  (25,'E90ACD98-F362-44A5-AFDB-49BDB99D1EE1'),
  (26,'310E7B76-F21D-4347-AD7A-B144C7942CD8'),
  (27,'728F843A-9C9C-4CA0-8287-066FF6CB0221'),
  (28,'D04D189E-6358-40D4-A1A7-C1347FD7AF5E'),
  (29,'6C5B1CC1-D987-4772-93E4-92D68FD2C786'),
  (30,'3BFBFD70-C460-4E3C-8511-EBB63A4D3730'),
  (31,'FC2EA8D9-F876-4AAA-A54E-4B38F071D661'),
  (32,'5D7B21A2-6B5B-4480-8372-62B7F59FB651'),
  (33,'FAF94139-FDCC-48CD-827D-9A8B2298A1B6'),
  (34,'3586250E-778E-4529-AFDB-9304CF79BA63'),
  (35,'791A31BA-922A-4D16-BFDF-C289D67E2696'),
  (36,'DF0A2AD8-470F-4B32-9AD7-14299E28DA1F'),
  (37,'71C7476C-9D6E-4E0B-BC7E-4E7B258BD363'),
  (38,'3685DE16-659A-4BA3-A036-011C0726F419'),
  (39,'70A1E945-A3E2-4CD7-B814-3D45973D6E1A'),
  (40,'25673150-1D93-4D8A-8FEB-3B8C03D864F8'),
  (41,'8544556A-7C0C-4D76-8865-B62A1B63BF7B'),
  (42,'4A83EE93-01EF-45E9-9039-5029F7E8087F'),
  (43,'3479B450-ABD5-474B-B875-881C88D0DD00'),
  (44,'8C1C3647-47ED-4102-B647-9C76265610AC'),
  (45,'B058585F-49E1-4A29-9111-BB78274C746B'),
  (46,'C150D5EE-DC7D-432A-BB58-1C0C667A9486'),
  (47,'8450D120-A671-45F3-863E-88743BDCBA6E'),
  (48,'217E6BEB-8AA5-4393-BC1A-06151509C54D'),
  (49,'9552AD62-D092-4DB3-B96F-FE6E731A5500'),
  (50,'13EA104E-FF14-405E-8270-7ACBF3B16B9D'),
  (51,'C1CE82E2-2003-4892-B84C-4A07E5870665'),
  (52,'E92ABE9C-339E-4408-AE58-06D40B845D46'),
  (53,'B8FC68F3-BF44-4F88-9FAF-D6EEFD37D620'),
  (54,'14100F2F-5272-4238-AB8D-BCE3C9F13D36'),
  (55,'87639A04-246A-4249-8E17-474ECB3DB81B'),
  (56,'61345D57-AFC7-422A-9BF4-2B80F325BC77'),
  (57,'268135BA-7AB2-4D97-9B06-6A13BA33BA34'),
  (58,'CCCCA7E6-74D0-4740-8155-8783282B679A'),
  (59,'0396B9BC-1310-4067-9E76-AC4537C81C74'),
  (60,'00851281-6958-4503-A1F5-5F5D52EEE6EC'),
  (61,'1C60737B-4419-4569-8AD3-DDAFF2CEEE47'),
  (62,'7F5FEB69-8C03-4B9E-A951-6D779A3BE9E8'),
  (63,'3EA4300A-A9FF-458E-979D-43AD6E311453'),
  (64,'10426E9C-41AB-4399-B4C0-A43C27CCE263'),
  (65,'BC840A87-1D49-4D52-BE06-251226DCDC38'),
  (66,'30979546-5593-4C69-8B38-F45F982E6C3F'),
  (67,'DFFC82F0-B017-4603-BC71-91AB34F09369'),
  (68,'22BFA4FC-FCD9-477A-813A-1CC45DDB217D'),
  (69,'BC98F166-923A-4537-B614-1117F32B4134'),
  (70,'EE9698A2-3597-4884-A1AD-BC6043FFB548'),
  (71,'F82BC18F-DB62-4491-A865-EC898EC93C5C'),
  (72,'1D11FD9E-8A1F-4B42-8D1B-FD883C78B575'),
  (73,'04A96531-2401-47F1-831F-4D7FAD12ED63'),
  (74,'3741801F-4A43-483F-8B1E-9EC348390CED'),
  (75,'AF9C3F2F-122F-4836-AB26-F6660BC2B28F'),
  (76,'1BA4D96D-30C4-40A1-9070-64478A6BBED0'),
  (77,'AC589025-2C51-44F2-A0C2-6379922B93ED'),
  (78,'99E69603-6298-4037-8B7E-93E10625E7A8'),
  (79,'5F336F39-97A2-4C32-9559-63787536DE1B'),
  (80,'61301154-524C-40C8-8775-95E6332C9134'),
  (81,'3811099C-EEA3-4F9C-ACBD-6011962D264E'),
  (82,'E19219CB-621A-42F4-A47D-E069FEFF4706'),
  (83,'155A70AA-DA22-40FC-A732-6E2EA06EF6A7'),
  (84,'9A73D7A7-2A8F-4F6E-9DDA-AA1BD312DFF8'),
  (85,'C76C0AC6-EEA9-4FA9-B6DA-5D3CB20C41ED'),
  (86,'0E185BD8-1E79-4A60-ACB0-5491B801202F'),
  (87,'C13F7F9D-DDD8-4D4F-AD67-4098D5311D8C'),
  (88,'49D09830-9C4A-49F8-AEFC-AD79540A6FF4'),
  (89,'AE21FC5B-18D7-4BFC-8576-7A09E2E390C6'),
  (90,'C2E52881-6A46-488F-B26F-11CB23E33C3B'),
  (91,'D98BD8D8-F9E5-4D7B-B2CC-BC8B3CD1C298'),
  (92,'BF267E07-DF56-4D3F-960D-343720980C2F'),
  (93,'E0305343-7B5F-47F8-BE10-8CAF44404B52'),
  (94,'D5C59A26-3F12-4774-BBCE-62080003AD82'),
  (95,'5E5460AE-07EB-4235-94ED-79EBA7BD5073'),
  (96,'44F36A6F-5405-43E4-BFB8-90CC34FB9CCC'),
  (97,'E8BA7E54-BACB-4F2B-8FE2-A092F130EE7A'),
  (98,'B51173A2-CF3F-46A1-98AE-4A1DE42497A9'),
  (99,'0F125D90-9B49-4C9B-82D1-67521F0CA17F'),
  (100,'C43839A7-77D7-4ECA-9407-54E1FAA0D222'),
  (101,'CDCD4394-C96B-4798-888A-364054DA5378'),
  (102,'8B9B36B7-D89D-4B9D-ADAB-BAE2579D7842'),
  (103,'33EFAA61-E6C1-49D6-92C0-43E9605CFD10'),
  (104,'366F35E7-03E1-4A82-9FBA-769B5E7E43FD'),
  (105,'B4C8A3F6-FE43-4ACE-8ED3-15E21E0D37D6'),
  (106,'DEB8C14D-D222-4A1E-A864-AED2A601B48F'),
  (107,'65EE1692-26C9-4B4C-B93D-BADDBEDEE801'),
  (108,'317CFEA5-5769-4DAA-B9FA-8C93E29E406B'),
  (109,'77DEBFB5-7843-4226-99DC-F9E54DC53A78'),
  (110,'96D5049A-FC3E-4FF7-9D1E-B331C71BE6F7'),
  (111,'9D096A7D-CEB1-4FB3-877E-FF0503E25D41'),
  (112,'904A58F5-6AF8-4AB3-89B7-25FB2C8D8427'),
  (113,'A46D96C0-D5DA-496B-BE60-C6686C040CD5'),
  (114,'E68CC9AB-B145-4852-898A-AC2D952FF640'),
  (115,'1FE4680F-18B6-432E-A48B-FC48C0C1F578'),
  (116,'B50411F4-5B10-4C4B-99DD-7538CD3CD04B'),
  (117,'3A4572BE-2A4A-4687-BE98-A80125954647'),
  (118,'02797DC5-F55F-4E65-A394-8B334FF511D9'),
  (119,'FC1C65D2-C14F-4EF2-867E-545C4E13FC96'),
  (120,'E7DC4699-4033-4FA8-90B3-E94408833448'),
  (121,'09FA954C-5177-4999-A639-39A8F2FBC860'),
  (122,'8FCAC82C-1A7D-477F-B226-3DDA24A1D22D'),
  (123,'5B28CD8E-5F8A-4BCC-A2D6-B0D14F57BAAB'),
  (124,'309C0B30-8227-4320-8DD4-E8622FAFF282'),
  (125,'AC444669-A1EE-4262-ACFB-7D4EACEC1EBC'),
  (126,'78B7AB21-26E1-454C-8B63-317F7B34BFED'),
  (127,'186E20E9-6620-4620-BD36-38B81ADE5D27'),
  (128,'E5BCAAF8-F452-4184-9209-FA480E29F446'),
  (129,'D41FCB12-83B4-404A-ACC9-847AF57D91ED'),
  (130,'2C62B536-D8A7-4374-8CCB-2E1C7DD5A90B'),
  (131,'9F64CACE-1271-4A6A-A8C6-63D6DC23BB9A'),
  (132,'41DFD3C3-DA11-43A3-B7A3-8EA013288846'),
  (133,'62EC1B43-00B1-49F3-8A5C-18D0B2FD78DF'),
  (134,'BF25A48E-4428-4786-9191-FD41F82E2D4D'),
  (135,'FED7DF10-8262-4926-A95E-F41F0C8BC758'),
  (136,'D2DC20ED-05B2-45A9-997F-F220FF8C18DE'),
  (137,'146A7AB5-9C22-41E1-B7ED-F84CCAC39E8A'),
  (138,'0E7BD80C-8235-4226-93D1-BAC02220FFE5'),
  (139,'59A9826D-E0A7-4C14-999C-2F0C862053A8'),
  (140,'20045532-348B-4E3B-AF98-DF04DDFC8F66'),
  (141,'ECE40A89-BC7A-4CC8-AA33-4A628E6F82AB'),
  (142,'C11C42EE-B220-4E30-90F2-8C59286BF0E3'),
  (143,'DC607650-894D-48B1-9F7E-F1A3BFE891B2'),
  (144,'B1692C43-C267-410D-A2DF-946CDF20C005'),
  (145,'B3AC1CE0-0E12-46C1-92BA-9613F93FAFEB'),
  (146,'EE756E94-E05D-490B-A05F-4BDC7090C4A7'),
  (147,'F6B3AC3A-8B10-4B09-B8D8-E761D8760967'),
  (148,'EABEB829-BD03-4116-A893-6782AED4A6F2'),
  (149,'E5D9C0A3-FD96-466A-A7D3-A02360BDF94E'),
  (150,'7BE3B128-E2E5-4857-99AF-F2159E428BA4'),
  (151,'13365E90-F4E7-48CC-BBEC-5F49601FCCC3'),
  (152,'27C64FC0-EEE0-44CE-8168-47A7D70069A9'),
  (153,'83B85233-A89B-46A1-8717-624DE23B19DC'),
  (154,'0D49F3F8-1FD6-4E08-A886-C4C957EC88E3'),
  (155,'2FEF49B0-26BA-4EEE-92D9-A01CF2CA8F04'),
  (156,'436743B7-E0F8-4F32-9322-067835B2D468'),
  (157,'D08AE020-9F4E-4A27-A9BB-B65AD178DF8E'),
  (158,'9AD1DEA2-280A-410D-8F3C-9AC8913D3432'),
  (159,'6BE52C30-CE18-464F-AF96-B4B565915DF4'),
  (160,'11F90BA2-2191-4929-8BD3-B0E0251A4699'),
  (161,'84CE93F9-67A5-4AC0-9AB8-63A8A721B94E'),
  (162,'0F7727D2-F7F6-4DDF-97A0-B39DFECC19A7'),
  (163,'2FE73E39-428A-4EE2-B0AB-BFFF890E428B'),
  (164,'747C0B86-CC94-4765-BE29-29935EC85248'),
  (165,'09D7D174-D7DC-4BDE-861C-7EC552837B56'),
  (166,'E324AEB6-FFEE-4E1B-BF9C-2F810F3265C7'),
  (167,'001875D8-7EC9-4899-9E7E-78573D79FB5E'),
  (168,'05C66AC5-9650-40D2-B7E9-2DA1D7F60253'),
  (169,'750FB718-9821-4347-BB30-89DF18BF39D7'),
  (170,'94AFDAF9-53CB-42F9-A866-FF3D688D1FAA'),
  (171,'463FBC57-4217-4AD9-AB2B-A7E2B4B5791A'),
  (172,'72C509FD-B12C-4791-AB0A-E64B2D46460A'),
  (173,'1323AE4F-0B14-4F36-89D4-D821850A73BA'),
  (174,'F7F4770F-9A25-44FA-B220-3DF89BEFD4EA'),
  (175,'F7261760-2F63-4AF8-A465-82CE9CB7B291'),
  (176,'95C9F9CE-0D65-4A0B-9009-D7115BBB7CE1'),
  (177,'A7D3A3C4-B033-46F6-8E6F-BEEA291C0CFC'),
  (178,'CAE383DA-E986-4A39-BDDA-102F9A133D8F'),
  (179,'7581DF90-EFBA-4666-B160-2D612705007A'),
  (180,'8906879F-4B5D-4022-B101-6AB360E1AF10'),
  (181,'C75484EE-B375-48BC-A7F2-99D83D0409E5'),
  (182,'4A13AC8E-BACC-4DB2-8A78-6FEF0B03DBA5'),
  (183,'1F1D19D7-6E5D-40BE-ADD2-54907E916789'),
  (184,'AE4CA3ED-9A15-4FCE-B323-01D64C1605C5'),
  (185,'CCB9D20B-26A8-45E7-81FB-E49BAC1276B0'),
  (186,'8440C1F9-FD63-4AF6-8F31-AAB8CA39A772'),
  (187,'B593794F-04DE-4A8B-9CE5-A679D30F1998'),
  (188,'40D9069E-A1E1-43A9-84EB-34CC6228D89B'),
  (189,'A3A3F406-12AF-4B20-AEAD-A3B9A1E88696'),
  (190,'ED481B79-D164-4269-A112-44D5DB97B465'),
  (191,'17D33B51-468C-43B0-9369-2FDCE5119531'),
  (192,'7D51CFE1-1461-44EF-8BB2-BA60FDBD5615'),
  (193,'FB0DD339-55E8-4360-BEA1-3573822AF13A'),
  (194,'BC23D3BF-373C-467C-AFD8-95840FE11452'),
  (195,'AADEAF76-F94C-480B-92BD-379657583097'),
  (196,'3D8DF853-67A8-4B07-98C7-3CA6AB2B0BA9'),
  (197,'D648AE91-ACEF-4B07-9972-AC9283E31E9D'),
  (198,'712CD2EA-EA7C-471B-B4BC-DE18F30AB2A0'),
  (199,'EF28969A-D429-41BC-AFB9-CA72B64EC25A'),
  (200,'01D6C637-AD24-4A7B-A7FC-2E559A624C1D'),
  (201,'9F234BAA-49AB-4B37-B708-D6BDA8EAA2B8'),
  (202,'4C908C1E-8BEE-4CA0-90E9-971ED8D37D54'),
  (203,'359B9B5B-522A-49BB-9B19-001798839F54'),
  (204,'AEC50CAA-F827-44C8-836B-6B016A0F2A55'),
  (205,'ABEA34FF-2E41-4BC8-9599-1136759A47EC'),
  (206,'4A56C353-69CF-4B04-9605-C375903A8E64'),
  (207,'805B1B2F-3BC0-4D38-AE18-77F8DF43EAC3'),
  (208,'3EDF1514-C65C-41DF-80AC-0EA37432F76E'),
  (209,'4098C543-DFEB-4C77-9095-17CE3EFA525E'),
  (210,'5F23A53B-D084-486B-9B47-9BF2CCFDABA6'),
  (211,'7E5200E2-F989-4748-AD3B-3C60704F4D3D'),
  (212,'644AFCA1-CD1E-44EC-8A01-11671E582F0C'),
  (213,'EBA79311-327E-459A-9090-2A893EA5D8B4'),
  (214,'592A8509-3788-4E8B-9301-6DAE01641E2F'),
  (215,'940BCAE6-ED2D-42ED-A3E6-AF923B1ACB02'),
  (216,'1065FE92-A03D-4629-B26D-965B80380EF7'),
  (217,'B509D398-1DAB-41BA-B241-1AA56B53A5B5'),
  (218,'C4167E3A-A017-4102-985C-06F40C93B274'),
  (219,'33939F4D-D298-4DA1-A140-5ED40E2BB0EF'),
  (220,'83DDB15E-0E83-4FF9-A2A5-81E78EA8DB81'),
  (221,'B849402F-AA8C-46AD-9313-4BFFED5B21B9'),
  (222,'CAFA66C0-C337-4DCE-906D-3782C5014E8F'),
  (223,'3271C3D1-29EC-49AB-BE82-A96AEF805092'),
  (224,'09A3CB36-064A-460D-A5FF-B7394ADA1C07'),
  (225,'A60E2177-EE46-4527-BF7F-042D201B1A11'),
  (226,'C099A1F7-9F03-40D6-933F-B7195BB6C6BB'),
  (227,'DA1B3009-01E1-47B3-A9BB-F1FD8DB6E302'),
  (228,'D3174E4F-B760-4D50-9D9B-4011D868D3E2'),
  (229,'E3313D1F-E4F0-4E26-8B11-994F8D6E7434'),
  (230,'25760FA6-1613-4537-B1B3-460FF229B0BC'),
  (231,'12294A05-BDCA-486A-ABF8-79E149CD6EB5'),
  (232,'B219F8C3-9A83-4A1B-BDCA-9CAEC4B39FB3'),
  (233,'177D8D02-B58A-4423-A330-F371944311BB'),
  (234,'C81CBF87-E3C3-4D65-9923-EDC303CE0D82'),
  (235,'CEE089BA-7AB7-436E-98D2-9EE1C9A88807'),
  (236,'21E1713A-C042-4DD4-B60E-28E376543CC4'),
  (237,'DA012492-52C4-49B6-ABA3-C50227B27DF3'),
  (238,'EB409482-6956-447C-91AC-083DA73058FE'),
  (239,'ABCA0B22-E5A8-49A3-A07B-FD4676EC51C5'),
  (240,'99222339-0ADF-49E2-BD36-7E29F6398C51'),
  (241,'9FE68B5D-9544-48B8-A235-04D57A8C8449'),
  (242,'4A799732-AEE2-49C7-86FC-2E534899429E'),
  (243,'415F30BA-4CFF-4924-B0FA-8000B5869240'),
  (244,'A8F06ED9-F1DD-4904-88E1-1B6C904D7832'),
  (245,'0885452F-BA2D-40F5-AA8E-AB477FCA72A8'),
  (246,'A531B4F5-7395-4DA3-AB8E-35F31E6FBD03'),
  (247,'6F454414-CC2D-4C3D-B077-6CD26F23D869'),
  (248,'0567A675-3EC4-4F8E-B75C-6A5B1842BE0A'),
  (249,'FD37F621-000C-4826-8744-7C2426BD6CDE'),
  (250,'259AEB30-0343-41A3-85C5-FF0DC9C45464'),
  (251,'EB01D4F6-6AF8-4C00-ACA5-10C61FF331E4'),
  (252,'7E741B27-B46C-4669-BA25-E6B8E0B8BD01'),
  (253,'7E8A34D7-7716-4D86-9898-0359F640658F'),
  (254,'C0ADE1D8-F1A5-4CE9-9682-014245BB0D39'),
  (255,'62901515-A59D-4B5D-8095-48DDA9B41719'),
  (256,'80B71A3B-CA91-47BA-AC3B-4CF8D2DA82A1'),
  (257,'1D162BEB-33E5-4770-94F5-571110120770'),
  (258,'C0D95508-18D7-4FB6-BB6E-272A9742BE9E'),
  (259,'B78123D0-0C89-478C-AA5D-E0863EC9770D'),
  (260,'582C4121-0AF6-4698-B1A5-EAFBDA28FA7F'),
  (261,'8F826494-F129-4CC8-AECB-F1353B4D2B3D'),
  (262,'F733E4DA-1C4C-4FDE-A7CF-761319569DC3'),
  (263,'FC585310-1C95-47D9-835C-4CA5AC68B3C0'),
  (264,'60EA1F2E-EDAE-43CF-B547-147851F156D6'),
  (265,'23523900-70AB-412D-8DA8-DBCF6AA716A1'),
  (266,'CCF54059-6E5D-40FB-B7FA-0D3FC30108CB'),
  (267,'9A51CB06-E13A-43BC-87F0-CB4E5772B46E'),
  (268,'4D68B770-784A-4852-87F6-CDCB22BFC1FB'),
  (269,'1D185F60-0089-40B3-B54E-266B4E8E6A05'),
  (270,'A9988C46-2690-4A30-A73F-2EF089D46854'),
  (271,'D43E07A2-FBC2-41D4-A3B6-BEDC643AD74D'),
  (272,'D66C6B68-E867-47E9-BC89-79BF596C37F1'),
  (273,'297632DF-55FE-45C1-9753-2393D446C298'),
  (274,'9738B409-DF7E-4D91-BE5C-9AF814D61189'),
  (275,'8016CC8E-BDF1-4164-B27D-298690AA92F5'),
  (276,'01B859D5-998F-4E02-8AEC-20F076B08263'),
  (277,'B03F4D40-F0AA-4095-9038-66A07BA219A2'),
  (278,'5F2DA6B2-F109-4F09-BCD9-DD3123CAE96F'),
  (279,'A37C7999-2647-4ABF-A5EF-D3199C37BC6F'),
  (280,'CD233941-1097-4D3D-AA16-AD233AAA9B7D'),
  (281,'204DBD22-5BC0-40D9-A5ED-E9E64C4100B0'),
  (282,'2B978E96-7011-4B0D-89DD-1C37FEDA8695'),
  (283,'0CCB349A-F603-46CA-B33E-817D7288550A'),
  (284,'CB7DA1D6-F53D-4E1A-8225-58F050A51560'),
  (285,'601EF76D-33CC-437F-A199-4B9D8B708AAF'),
  (286,'0B60D728-26ED-49A2-A7E7-50F0DC7F4730'),
  (287,'CDD4E3C1-889E-4CF4-AA45-E6562A306952'),
  (288,'1CDE9BCE-DC14-4177-88DD-C8391F1403AA'),
  (289,'AD62BA0C-355F-4CCF-BC35-734314A31916'),
  (290,'19A13C97-C083-4285-9D18-50D66747ECB0'),
  (291,'8DE06B05-6832-48C4-9B3F-95033D5A9867'),
  (292,'401E8AE3-32F5-4E5E-982C-C98CBB5482A7'),
  (293,'ED86631C-200D-4243-964D-175AFB2FC078'),
  (294,'039823A5-F930-4938-A52D-2766F6479F5A'),
  (295,'91297736-5C79-4526-838F-571CA6F55C23'),
  (296,'792069DB-D7E4-4CC4-8268-FBB89F55FE23'),
  (297,'D936FC4C-0A95-4A06-BBE4-A562C6C924FB'),
  (298,'0F2833B2-0434-48CD-AB03-6330C960E981'),
  (299,'0D581229-7742-449B-96D7-03F3A17DB802'),
  (300,'37C956A3-3351-4ED4-96D3-82C5662FA999'),
  (301,'4EEDFC19-62FA-4ADE-BC00-CCCEE83F4C9F'),
  (302,'F2435714-1925-41D6-8BE3-583CE91F3582'),
  (303,'B9DAED2D-F1DF-40EF-8C68-AB5F38240D93'),
  (304,'693B9B67-3501-4724-B844-765204B06BEF'),
  (305,'42C995EE-71FC-4A6A-95DE-CCBA390DFA64'),
  (306,'741A0ABE-DC28-4668-9BBD-4F732A69B65A'),
  (307,'BCB344F6-C1C8-4094-AC1B-EEF1B9480B40'),
  (308,'2F1F700D-C504-47EF-8030-4120B36BCB5D'),
  (309,'C37A31DD-714F-4CA5-92F8-E58ABD3322CC'),
  (310,'4E75D4EF-E697-456B-B626-94D2BBF5F080'),
  (311,'D352BBED-03B1-4480-AD42-9E305E267DC4'),
  (312,'57642EFB-A8EF-4AAD-8CAE-C96A04EA5C30'),
  (313,'6D4A965B-4041-4DEE-856F-89DB16FB610D'),
  (314,'ADFEBDED-DEE1-4A56-8451-CBDEF40A68E7'),
  (315,'30697DC1-4B51-4C1C-801D-C81A60D7618D'),
  (316,'13E5386C-DD09-4A51-8283-C577A936F7D7'),
  (317,'221A9789-3FA0-40B8-B761-FC829073F022'),
  (318,'569722D7-4F64-4E6F-B96E-F24446817386'),
  (319,'C48485F1-F26D-45B9-B5B1-1B3509B18642'),
  (320,'2048F81C-DB75-4A9D-A91C-17CF691BA018'),
  (321,'BEABB604-235A-4EF0-91F9-B54918DDFBF8'),
  (322,'818F3D69-D080-48C7-BA28-3A50FBCB66DD'),
  (323,'D0A9A7FA-325B-4E21-B0EA-917DAAE43D66'),
  (324,'C9213CC0-2119-4EA2-B231-2C7E3C8B0303'),
  (325,'E30CD11D-0FFB-468B-BAFC-655B2B991F9A'),
  (326,'4E1196F3-FC09-420B-8232-4CF66D4F0BEE'),
  (327,'85153158-736E-4187-93A6-F47E4E281B46'),
  (328,'F31F0BA1-4345-4B32-92FF-124EDF84A35B'),
  (329,'E96B6FED-77E8-4059-853A-00E5A233EE60'),
  (330,'3ACB3425-CC0F-4F45-A202-94377B1A1E0A'),
  (331,'283E7C03-B5BF-4A06-8089-8219295C3937'),
  (332,'1E186882-8460-4BCD-A425-CCF93DB47AF6'),
  (333,'D0E1A668-D52A-48B6-9CBF-8756DAD47C06'),
  (334,'3F41AE8F-A7B1-40F8-9DA3-8127813A975B'),
  (335,'16C3DD4F-B18B-4FC3-B1EB-49DE1461A731'),
  (336,'3436CAC9-8424-4B92-8723-35730B934FFD'),
  (337,'8F942E6E-3E27-4E88-92EB-B8820EF1538B'),
  (338,'6FF98AAA-5C1F-4DE4-8FAE-25033330127E'),
  (339,'6AA5FFE9-89A6-4844-8E33-8EE5A871C9E0'),
  (340,'327484B1-229C-4F21-B222-99C37FFA79A4'),
  (341,'7197571D-1980-44C5-9D76-515A26D3F72B'),
  (342,'0999FC7A-64B2-475F-89C8-CE7D8ABC4845'),
  (343,'C2DAA59F-C8F5-4D7F-AD64-5C96921D1C4B'),
  (344,'A460A8C8-DBE2-481B-B4F3-5B1FEF6F35F3'),
  (345,'864EA492-275D-4A3A-A9CB-E2E9B7C59778'),
  (346,'9ACC402C-9BEB-4702-842F-4D67F47168DF'),
  (347,'0E0915A6-D5B4-4345-B1A7-AEB0E8EACEE1'),
  (348,'E54610DC-E956-49F4-B874-D8FAAC7B70C5'),
  (349,'4BCAE45F-32E3-42CF-818A-4D2648B6F428'),
  (350,'941B7C70-7CE1-409C-BCBA-0DB90436817A'),
  (351,'87FE863B-4BB4-48F3-BF94-BC8F5AF8D59C'),
  (352,'5F7621C0-973D-4CC8-8BD4-DDB8D551E298'),
  (353,'0B71D533-0BA7-4DAE-B04C-2CBD5C9C249A'),
  (354,'39FDBD9E-2CAD-4AB8-826A-77664D6250F8'),
  (355,'516557A8-34F3-44F6-9E03-3C12ACFE4251'),
  (356,'10BBC173-701F-4283-BE2D-94FFBCF200CB'),
  (357,'BBF2B08D-60DF-4481-B0BD-A5B4274C4DC5'),
  (358,'281A6F37-15B1-40C8-BB6D-235774682AC6'),
  (359,'095FA412-8AA5-4A76-AA26-A26D77251234'),
  (360,'882D4772-CFE2-40C0-96C2-2DFAC4256A6A'),
  (361,'1E0F3B11-6B9F-4446-A119-05A880B26E38'),
  (362,'BA53115B-8622-4EBE-8737-4841BC0A5237'),
  (363,'D4A8F777-C071-4479-BE09-F088D292164A'),
  (364,'48D5AB9E-14A4-4E51-9AFE-18108FC821A7'),
  (365,'418E309C-D9F4-4C5E-9FE1-7989A2F67C98'),
  (366,'1B8A5719-436C-4B28-83FB-3E37080CCF02'),
  (367,'C4DB587F-B486-49CA-8525-B7390C541378'),
  (368,'CE231B70-7768-44F8-BAC3-C3AF890A997A'),
  (369,'A52C0023-57C3-4090-A945-CBAD3765B6F4'),
  (370,'FEFAA569-02EF-48EB-B231-B95415EB39B4'),
  (371,'5D261D68-0135-4415-BAD1-7BE7DEACC5E6'),
  (372,'44361BE3-D0E9-489B-B78B-F67B2CD76F0E'),
  (373,'A3F8D2EF-C88F-49C3-AFDB-6EC5862425C2'),
  (374,'3BE6F74E-C11C-4533-ACCC-49D307476351'),
  (375,'90BBAA27-4193-4AAA-AE0B-0BBBD5718D02'),
  (376,'7AD4A319-F001-4B3B-90C3-F4B9B1C76A6F'),
  (377,'AAF78D46-859D-44DD-8AA3-46AB5E05F878'),
  (378,'558594E8-9C2F-4211-AB46-2CFC1F869177'),
  (379,'A4058C24-2B5A-4885-BEB7-28595F43AC9E'),
  (380,'C44A1335-5A1F-407E-97C3-4E22054B742A'),
  (381,'CD1D4F68-65B0-4169-BED3-292791F96635'),
  (382,'7CA3E461-C95D-4F9E-B597-3DC1D800553E'),
  (383,'55216AAD-EB36-4FD1-BC15-7CBA0C1DCF2E'),
  (384,'9647ECF1-F41C-43B8-BFA0-4B6498AF2AB3'),
  (385,'BB5A5FB4-890C-47F9-B196-D2420BF8A074'),
  (386,'2E52ED70-D274-4843-9647-A94E1A5B7DAA'),
  (387,'A72AD58D-E02E-4590-8BCC-8142E80C3ADA'),
  (388,'D45803B4-75B3-4BC5-AC99-85E1C101EBA7'),
  (389,'72F67579-251E-44C4-8704-081E3B343C57'),
  (390,'CA55F8FE-F798-4436-A9B5-9B9E97968738'),
  (391,'7151F28D-0D71-4DBE-9BD9-F9F832398E52'),
  (392,'386D8C3D-24D3-44BA-A62B-70A26CBBC81E'),
  (393,'A58825CE-C26A-4ECB-AD8C-BA44A01DEF25'),
  (394,'F5B1FBC6-A9AE-4E73-8BF8-47F0ECDD8C9D'),
  (395,'7082F684-53D7-403E-B59A-EACA9DF7BB18'),
  (396,'352A801B-1B41-498C-A4D8-8F36BFAE3B22'),
  (397,'8D63C9E5-61BB-475F-AFD8-BCAC487BC661'),
  (398,'36331C90-C883-4755-9D76-3C8AA2CF678F'),
  (399,'F2C52E6B-553F-448C-82AD-69F1691F2B8C'),
  (400,'1FB874D9-81F7-4B9B-8EC3-426987FA10B7'),
  (401,'7A3D8487-DA70-4622-8434-694ED4CC4015'),
  (402,'B7803C7E-9198-481B-B33E-17036AF28A96'),
  (403,'32D87C6C-38D0-4AC8-9364-9BAD82ECAD9A'),
  (404,'940C588C-F2D9-4C9F-8067-10F94DFE4E80'),
  (405,'4AD84F64-158A-483E-8F8C-97FC373FEE18'),
  (406,'54DA534C-3AEE-451D-8C01-DF20F80D009E'),
  (407,'D0108B90-D029-44EC-8E95-689E4311F5DF'),
  (408,'BD39DEC8-71C6-4ABE-966E-014D7D020B2C'),
  (409,'BE5F4E1A-E840-4793-B4E8-D90C17A420D8'),
  (410,'BB04F0FF-89BC-438C-BC7D-349C6AB313A0'),
  (411,'6E9234A8-3411-4CBA-A4E2-79ED81D652EF'),
  (412,'DD857F64-4D6B-4F05-AA1B-3EEA45D36AC1'),
  (413,'0E184453-B285-42A5-8213-5B6480C50D6F'),
  (414,'D27FE869-DCEA-43C1-8A16-5AAE52B917E9'),
  (415,'A409F728-24D2-43CA-9FC0-2DB1599DEA8F'),
  (416,'E8472C40-7723-45DC-AFBC-E092393F5217'),
  (417,'66974115-3463-4DC7-9AD2-AE5F6DDB9E19'),
  (418,'98859EC8-49E8-4536-98CC-EAD98EA90612'),
  (419,'92B63D41-5FC2-416C-A30B-10F1D2B2D86C'),
  (420,'C3BECD4E-97D3-4470-8646-FAD42873C4EA'),
  (421,'BF8155EE-D6D2-45B0-973C-9C414790644A'),
  (422,'53D884A0-1622-4970-BAE6-41E6A266047E'),
  (423,'3D05DAF3-8E99-48E8-B7DF-6DEBBD546F82'),
  (424,'1BFD5DA7-5D51-4806-8048-0370AB1D043F'),
  (425,'16881FBD-D78B-45A4-A2DA-1726023ABD52'),
  (426,'3DE7E705-0D04-4BB1-97E1-966C79B7938C'),
  (427,'8E5EC115-B7C2-4A1B-98A3-3150803A4F85'),
  (428,'FFF96F9E-4D9A-47BC-9503-AA26EA71C782'),
  (429,'C6FE0751-8D30-4680-9871-48341CF88CAE'),
  (430,'0E7E517F-1731-4CF7-8318-D5A029C6938F'),
  (431,'A111F5FB-96F8-47BB-9D1C-38037746FDE0'),
  (432,'627563C4-EB69-4C69-A67E-1CF48B389465'),
  (433,'AAE0553F-E974-4F97-9F5C-11033B38B5E7'),
  (434,'9E280323-C3D2-4162-B685-5C51B3CAED05'),
  (435,'560ABC14-D428-4DAB-9476-D541426E6089'),
  (436,'3ED0C27C-17D1-4DBA-B9E9-FDDF5B4A0E40'),
  (437,'18B9AD81-E869-4780-990A-1E98C73930F9'),
  (438,'B98BB175-E7FE-40EF-8546-E918BC0F485A'),
  (439,'8AE574C7-E275-4FA4-8446-A18418C5790F'),
  (440,'53BFEF9F-A7CF-4126-9336-8857D3FD33D8'),
  (441,'152D0811-E7D4-4C38-AEAC-D02E161EDD8F'),
  (442,'00B23B59-AAE4-4EDF-BC86-89DB286B4044'),
  (443,'2C75C0E1-B8BB-44FC-8E1C-319286C2461D'),
  (444,'620205B1-DB4E-427E-91B6-6A8AE7F46AF0'),
  (445,'B3359E49-58A3-40F4-B0ED-96D995BC00B0'),
  (446,'27D082BA-50C8-4CAA-B493-F1DE757E041D'),
  (447,'29E7BF95-164D-4A29-9CAF-1878E97AE07F'),
  (448,'BD479BE8-15E3-457E-B5C4-CF0221607043'),
  (449,'0DA8A6CF-E1A2-4DF4-B2DF-CAF1D1C2CC36'),
  (450,'17FFC81C-812E-447D-BFD6-6F294CF766F3'),
  (451,'979AEF9C-93D6-4587-BFA7-4FDB31ABB450'),
  (452,'76E6B61A-D00F-41ED-BEAF-977187645697'),
  (453,'582B2627-8B70-4055-AE5D-15B478CB6BD6'),
  (454,'317CB15D-07BB-45EC-A1F3-16D935866ECA'),
  (455,'06C0F4ED-2B03-4A04-9114-E7ED269FF584'),
  (456,'E2064C5A-80C7-4352-B0DF-7F67BC1AB49F'),
  (457,'CABECADA-C89C-4D56-9780-8B6EB432CB48'),
  (458,'CD2998A6-7E37-456A-9398-DEA65B0175BF'),
  (459,'A1910839-EC8C-4B2D-942A-21B3DB64AAB7'),
  (460,'3661FBA1-9B98-4987-85AA-331481B3FE64'),
  (461,'2859FF06-D651-4796-B53B-F05A64EDACDC'),
  (462,'B536CB5A-2280-4F06-BBF6-ED208388FC20'),
  (463,'CAC8D893-29A0-416D-924C-4CB92B89D6E8'),
  (464,'014DF6F2-5AF4-4CB3-A994-5150EF81B96F'),
  (465,'F9704391-BCB5-4DAE-A8AC-067EA01C1049'),
  (466,'6D57003A-A68F-443C-9D68-4260E0B7554D'),
  (467,'1E914A12-1D50-4CC4-80A8-E878AE1E7FB8'),
  (468,'3EF07E82-3063-4A98-A41B-11DE8BCDA7AD'),
  (469,'EFB73B7E-643D-4546-A51B-4AB99F2D3497'),
  (470,'7DBAF4A5-7193-4A7F-A925-6E7D7EBEE87D'),
  (471,'478D4E11-97E9-45C4-85A1-B1F47BF65CCF'),
  (472,'AE7C5A9F-0830-414D-AE13-3846BA02CA95'),
  (473,'C1082DFE-9E13-4E66-8D32-A819E4725940'),
  (474,'E13B27F0-DD77-4539-93CD-2C38B2AE982B'),
  (475,'267FFAB6-8B39-45C9-92F2-C5B2408EC5D9'),
  (476,'4C99E160-C132-4B2F-888F-15611AFBEE70'),
  (477,'8C512821-F314-45B0-9A19-B342AC51210A'),
  (478,'A878B0D5-B393-4FD9-B2A1-72C2F664354C'),
  (479,'4C1C2853-8A9C-4699-BF00-E09A10040C40'),
  (480,'40463FD8-7A3F-483B-BA4B-EC5E46FA5E33'),
  (481,'21968966-E17C-4405-A601-2E5BE1E6D67F'),
  (482,'44AE837F-387F-4957-852F-2BB58D671A9C'),
  (483,'29B89C83-F94A-40E7-A679-7A996AC728DF'),
  (484,'773C9116-D068-42FA-A6B4-BF14CCD19F01'),
  (485,'BDCAB510-24C6-405A-A404-5CEA5F523937'),
  (486,'4885B2DE-1367-4901-A9D9-4ACA4CF54F58'),
  (487,'7FEA947A-07A2-46FD-8481-731A48DCBBEB'),
  (488,'4A69B2CF-829B-4749-8924-D2699CA7B536'),
  (489,'127447E0-2DA3-420D-9C46-276912E69CA8'),
  (490,'ECE36E20-75D3-47AD-BD5C-517ED458E554'),
  (491,'77E2F1A6-6E91-47F5-8062-10675D3FB39E'),
  (492,'F49BAF83-1D57-4233-8B31-56182D2EB540'),
  (493,'244B0DEE-8B07-47A1-8F60-1FD6A98E941E'),
  (494,'297949F1-C1CE-4855-9845-4270EA3AE7C6'),
  (495,'19BC515E-E37C-405E-8F41-6FC2B7493F8A'),
  (496,'1BFF3AF3-8031-432F-83F1-850D3890E359'),
  (497,'DD78BF20-A94D-4A30-9549-A01372298580'),
  (498,'87FDFDB4-1A60-499F-BAD1-9630F5AE1307'),
  (499,'EC9F4AD0-C50A-46AB-A75B-0838DB27741A'),
  (500,'D14EB35C-49A5-4330-A2BE-96BFD4CEBC8B');
COMMIT;

INSERT INTO tbl_quid (quid_id, quid_value) VALUES
  (501,'5C14560D-86A5-4089-BBE2-D69659E03382'),
  (502,'52B2396D-2D0A-4313-8CB2-4082BB925F75'),
  (503,'7888F332-CFFF-45F2-B8A7-AF660F707E65'),
  (504,'2EB01170-DA71-415C-AF91-F6C561887F25'),
  (505,'71814A27-7D1B-4C03-9E35-B362F37676B1'),
  (506,'165BE188-9BC6-4E68-AEEC-63CE5C7E63F9'),
  (507,'2ABB52CA-81B0-4148-9C37-0D891D7179CA'),
  (508,'F046B2E2-1F71-4EFD-9F9B-F44E65FC525B'),
  (509,'9B05B3BE-E074-464B-B870-B4D9FA977BEA'),
  (510,'67CB5AB3-6839-4248-A944-17D9FDE79AF6'),
  (511,'6737A42C-0A4F-46B8-8902-E18952D730D1'),
  (512,'BFC1F39B-A93E-4765-A05E-4E00CDCECC08'),
  (513,'50A425C3-E33A-411E-9B85-BFDE4F19582F'),
  (514,'7F4D5107-9491-48CF-A7B0-4CF0898EF082'),
  (515,'7D7BC9B8-5F40-4A66-95B8-C1F2A2A20B9D'),
  (516,'7417BA89-3F10-4EF7-AF47-9E93F2AA5FDB'),
  (517,'7341C44D-7103-4890-91B0-524E3D15FB0C'),
  (518,'0E773635-6BFC-4B5A-B435-6E186880E78C'),
  (519,'566279FC-ACF3-49F3-BF34-069048A48088'),
  (520,'D16B503D-58F8-4CBE-9C7A-CE08A0AF8AD5'),
  (521,'7B3A7E9B-4391-434E-9B02-3C67793A6B76'),
  (522,'1EAEF9BB-3900-4B53-9854-78ABB5537BD2'),
  (523,'84032FFF-5018-4586-B9E2-D6EDB7BE592E'),
  (524,'37BACA10-39C9-4A6B-BAC5-45A654E025FB'),
  (525,'41E3B40B-E945-4AE1-B7E8-DED0250F3036'),
  (526,'09E6C4AC-C7BB-4B46-8AD7-177FECEB1074'),
  (527,'F1ECB4C1-55E3-4D58-8B64-771E33780351'),
  (528,'E093546B-F9E2-44ED-BEBA-F0BA57081120'),
  (529,'70FD89C1-62DF-4FCA-B379-F1A0877ECB2B'),
  (530,'E5B5D919-A25E-476D-A468-73630515D2F7'),
  (531,'EAB37295-C642-4CA3-BDD3-1ACF83E037A6'),
  (532,'6150DEA1-21E7-49D4-AEAD-937D1F1EAC0F'),
  (533,'0CA9C9B0-0695-447E-A155-995968119372'),
  (534,'607E9384-B6CD-4947-8656-4B064DF35A7D'),
  (535,'806153E7-E77F-460E-9818-446AAEC8F5B7'),
  (536,'7DCB189F-3D9C-4B4F-804E-0BC97CD02B45'),
  (537,'8FC055F0-B5E1-4132-A513-8A2C352A6AF5'),
  (538,'9C1C9699-3602-4852-A2AF-857D76CFB0BA'),
  (539,'94C3A6FB-19D8-4C5A-B461-51EA4CE59F94'),
  (540,'3422EF83-D343-4AE5-8D9D-18650FDABE97'),
  (541,'2BF7E3AF-0043-4469-94CE-6794998764B1'),
  (542,'9D2F1060-B40B-4AF2-BC53-0F2880D9E8EF'),
  (543,'35CB7D1D-B6AC-4AFE-9F84-90E384E79DD7'),
  (544,'1BE96424-48CF-4781-ADCF-CB1DD7AC4340'),
  (545,'65FC5881-8496-4FC6-8BB9-8E34113205C7'),
  (546,'C11A8F95-CB50-4257-92DB-D7C7B2D02F22'),
  (547,'27AD4401-B09C-49C0-9956-05FDA6C5F681'),
  (548,'37C86F37-CA04-4378-ACA4-FA9EDD684FD2'),
  (549,'7D1A806D-9238-4E40-B4E8-CCBAE34D956A'),
  (550,'A810D846-C487-4D7B-97E9-1A1A71CB68B5'),
  (551,'D4E72D65-CD44-4C34-ABD0-79C4587883B0'),
  (552,'E8199573-C1D5-4B57-A6A4-70244410C0E5'),
  (553,'FFA8EDF4-57C6-4303-94D8-A0C75B2C97CF'),
  (554,'A61448AD-1099-471B-8CD0-6A0ECA798EB1'),
  (555,'2AC01A75-D786-4460-864F-69C29F675F45'),
  (556,'1FCBBBE6-F7CC-43BA-BBBA-608FD92D7CEF'),
  (557,'158986C3-2677-450E-80E7-B51302ECFFAA'),
  (558,'909397C4-4D6D-471E-B7AE-BB1A12BC101B'),
  (559,'35DBB4D0-3BDF-486A-A08B-C288CB59FBE7'),
  (560,'13BA0CAC-F5F8-4F1B-848E-F6A7AD80B25C'),
  (561,'A4C8CC70-E47C-4450-934D-5F2B31A38440'),
  (562,'E0023524-BC5B-496B-8149-DD78D383A4D2'),
  (563,'2EDA4E2C-B065-42D7-B842-5402FB9B7001'),
  (564,'8E917D68-3097-48C8-9A42-2E62BEA99366'),
  (565,'AC2786D0-F9F0-45A8-AE1E-DF0F73613081'),
  (566,'2D09C4C8-BF1D-46F1-A274-BB03B7A50EE0'),
  (567,'86B1E6BE-3484-4E39-83BF-BFC8A42D34CA'),
  (568,'03D7669E-DCB6-4FDA-AF2E-C66A3940DDD4'),
  (569,'20F377E6-D4E6-4477-ACAC-9A7D11CDA011'),
  (570,'3FEE3820-FA99-4358-9007-128669739A88'),
  (571,'097A45C9-C2B1-486C-B877-141C0B2FDA4E'),
  (572,'F35B5572-F448-43E5-8559-1718C6C5A607'),
  (573,'180C59A0-D65D-4853-B967-B6B31EC1D29F'),
  (574,'1EB54E5E-FB05-4FB5-AF77-CD94A5A210F0'),
  (575,'69B45C82-5123-4ED6-B648-117FF5EAE01B'),
  (576,'58371F49-0367-4B33-8DC4-00CF20EB59C1'),
  (577,'8FC28C1D-A70B-45BF-B49E-C9E86713714D'),
  (578,'F8F71EF3-58E6-4A81-95F4-91BBF0FD28B4'),
  (579,'39BCEF05-2727-435E-AE3C-7967B17B05EA'),
  (580,'32348768-A2D3-47DD-986D-D4E3FB2737ED'),
  (581,'A50F1F9F-8E38-42C3-BE33-EAAE2D8D2514'),
  (582,'8D2A4493-E277-447F-B5B5-A8493239044A'),
  (583,'F67F0B8C-E8DD-4809-A37D-DDFE998CC4CE'),
  (584,'528CF2CF-FCC0-4B43-989D-AACA11E23220'),
  (585,'945F6681-6FFB-4D35-97EC-03F223E3586B'),
  (586,'3DB51E4D-CAC2-426C-952D-C6F261CDC138'),
  (587,'1EC5CA28-53E8-4336-9862-0FBFF23D3A72'),
  (588,'D7306868-53A6-462C-875E-CD3D488F788D'),
  (589,'9F3AF1CB-5ABF-445C-B627-1812843F7711'),
  (590,'B2793F1A-7B8C-4542-BFD4-9761F629411C'),
  (591,'A3B0CA4B-1920-4E3F-B5B1-325CEE9CCE43'),
  (592,'74BECDF2-7B10-4857-983B-79FA1C5C007E'),
  (593,'DA7AE626-F522-41DA-85C2-436314796D78'),
  (594,'36E9097C-ACA8-4317-9A3B-1114EA8CBA25'),
  (595,'CFE3CC47-13A2-4966-B525-B4AC673D0D5A'),
  (596,'CCF025B8-D314-4562-8D77-C4EF30E44F79'),
  (597,'90393AC3-9928-4B87-86B7-2C2A67EE27C2'),
  (598,'F97F62BE-7115-4223-A89C-83417E7A60D3'),
  (599,'C75AAAD7-7F4B-4CCD-8C88-D9CB29F700F5'),
  (600,'AF6914B4-B2D5-4A3D-AA1C-E25AA46F5A27'),
  (601,'C3D8C076-0B26-417F-B93F-7F5DC00892F9'),
  (602,'089776D1-1D73-42E7-BBE6-6EDDC20D5153'),
  (603,'157202EF-0003-4AA9-936F-9B05D561495C'),
  (604,'7E86071A-899F-4012-8671-E6C33638FA40'),
  (605,'413AA615-3C17-42CC-BF98-53FED039DCD1'),
  (606,'D84B89B1-9D8F-4C83-84EC-500EFEE09151'),
  (607,'06F8E7A8-E380-48B0-B0A1-4F8B6E59BE38'),
  (608,'415D8DC0-2FDC-4421-8413-611B916E041B'),
  (609,'30F01CEB-DF33-4FC8-8388-9633567F3CC3'),
  (610,'B58A5539-0AFD-465A-978B-7811FA7E4C1C'),
  (611,'BFD9613E-9A92-4076-96A2-6B1CFEE45D0D'),
  (612,'42315564-660A-41DB-ADF6-CADBFD8C0488'),
  (613,'9A46AB52-0588-4BE6-94D2-9E4135ACF3FB'),
  (614,'2275FB4B-1CC9-4601-85E9-D9E8F59A5C15'),
  (615,'4E4647DB-6696-4273-9533-28EF6C5E0472'),
  (616,'CB2B39C3-464D-4530-AC9F-22F0A4B0CCA4'),
  (617,'45EC164D-CF6C-4206-8AA6-9A92EA21D89D'),
  (618,'A5E94D87-8D58-416E-AAA7-CAEE2885D46B'),
  (619,'141CAE20-1065-44D8-9EE9-7585244A76A0'),
  (620,'9539783A-96C6-4422-9EDE-7EA351E166C6'),
  (621,'45BF661F-247D-4B37-80A6-E21D0D707D8F'),
  (622,'489DFBD6-F9D1-4C2A-8500-593C76405537'),
  (623,'F4927086-0915-4EE4-9A5F-2F8189E83FED'),
  (624,'46F7D4CD-AE34-48D5-A26C-0975CC513CB5'),
  (625,'1E1F4CF5-0159-4893-AA03-1CA7326269F8'),
  (626,'6DAC5A01-2FF3-41B4-BC2A-339E1292C720'),
  (627,'FDEB075D-AC72-4F96-AFA0-7FEA4B271B88'),
  (628,'A0B871F9-7A9C-4BF7-8646-A0510FAF0882'),
  (629,'5FDBE601-DDCF-4798-BA3B-A354B229DC1F'),
  (630,'418F9278-0AED-415C-BD58-BF24089CC9E0'),
  (631,'EE6D8C5D-CFA0-4D13-A27E-53365C9F8F9D'),
  (632,'42614EA2-5CE9-4F72-8340-7AA9CEDDAA3B'),
  (633,'963EA54F-309C-410E-A5D5-E81DA07CB4DA'),
  (634,'DCE4F742-BCF5-4D91-8352-26A9269AA6D5'),
  (635,'96DFCC20-4BF3-4EAD-836A-1B761AD64772'),
  (636,'1DE48006-8862-4905-9FAA-F96B0E462FC2'),
  (637,'6C38FDE3-EFAA-45B9-9E4D-D0491A99B67B'),
  (638,'5A9FA531-5D89-4D5D-95A8-C3A03007739C'),
  (639,'FF3BF404-AA99-4FE1-989C-D67DE28B6203'),
  (640,'38423088-6F32-4902-A729-003D54675B6B'),
  (641,'15D1AC5F-1E36-429D-81E8-49F0B2DE6DA4'),
  (642,'1678B051-2680-4FC1-BA31-E3D2066776C5'),
  (643,'966B3B03-1AE5-47D3-8080-B19F7B7DA176'),
  (644,'1D40F6D8-CD30-4C2E-A25C-040F0A55827F'),
  (645,'6840760F-7C51-487C-925A-4928AF079B92'),
  (646,'5668E3FB-3130-4B62-BD25-4CB01ACDF238'),
  (647,'B6814435-EEA0-4B1D-AD45-FCC83468FD7C'),
  (648,'3ACC0240-B2E1-48E4-8429-27B1955D3340'),
  (649,'8110DEDA-33C9-4469-B690-910950609490'),
  (650,'8A390658-B096-49EC-8CDC-C9D55C3C9B49'),
  (651,'08C80EB4-6829-49BF-8F30-5A3E75A04ED8'),
  (652,'73285472-1BE4-4734-9CBB-DD301676C61C'),
  (653,'3A8DA488-FB9B-4A13-9D48-915C7B0EE902'),
  (654,'4023EFC8-6EFD-4776-BCA5-FE1139AEDD4A'),
  (655,'5157C6A0-FB1E-4362-8212-9F3F499DE65F'),
  (656,'89DCDB0D-7076-4AD8-8F59-6C019A162BFB'),
  (657,'FF711B07-987B-476C-AC5A-9112A60600D3'),
  (658,'802C52C1-0E3F-42E7-88B4-D53A6D0108E4'),
  (659,'07F25095-C076-42C6-A3D9-EE4858BE64BF'),
  (660,'75DCBDB7-0274-42E6-9C53-3F406DFC69A4'),
  (661,'3352DAD2-ACD8-4714-A75D-A444E6978A0F'),
  (662,'D5E6B272-C9C4-442D-9CA7-632BB21BCC8A'),
  (663,'8F77FBDE-6A94-48D1-9B3D-F6CD7B9979DD'),
  (664,'65D96D2B-22B7-4B0F-8AEC-8BCDD3DB4985'),
  (665,'A2A60EA3-E409-4F77-B41F-D2C2C40541A2'),
  (666,'20132044-A13F-4EDF-997B-F8DBF898927A'),
  (667,'1312990B-7102-4281-A26D-0AD527A9ACC1'),
  (668,'6C06F5B2-7A51-4ED8-A0AC-F3EE1BAF26A6'),
  (669,'0F070BC8-4DFA-4042-85CA-B75AAFD9F1DD'),
  (670,'A1A3DA93-C759-4C84-9880-AA81A1965253'),
  (671,'4728088B-47D1-4F61-86CE-FE6222482342'),
  (672,'156BCAB3-44E4-4A90-82E2-57396F50F18B'),
  (673,'214AFF00-E0A0-4354-9A9C-5FAE52AD56A0'),
  (674,'459A5582-A887-44E3-AA82-864A54C2A1CA'),
  (675,'B5D8B3BF-9D15-4160-8F9D-674F0C07744C'),
  (676,'F7DDBB2D-FBFA-41FD-B463-5A6FE2F62911'),
  (677,'779E6B37-C32E-41FD-BE7D-4120E0E2644C'),
  (678,'F03C69F3-98CB-4688-852F-9B856956BD80'),
  (679,'409AF643-C95D-4053-BD5A-36E68A6D4F29'),
  (680,'1B15307F-C284-4582-A633-1F7A6A61EC42'),
  (681,'8B74B082-AB31-4475-A2A4-5C4F40F2D332'),
  (682,'57E1987B-D9D2-4D8C-92B2-18FDC2951A28'),
  (683,'7EFA0409-9061-45EE-BF11-6BADF9EEF869'),
  (684,'F1AEA317-052A-4FE5-91C2-F5D8C69E194D'),
  (685,'BCB1DBF0-AE38-4234-B976-3F4202794B2B'),
  (686,'34AFA236-BB78-40C8-8271-968ADF4C6845'),
  (687,'14381CCC-C919-4091-946D-A6D909EE6C3E'),
  (688,'8036B29F-B5BD-4B2B-8D65-7D26E02FC447'),
  (689,'EF1A596F-506A-44F7-AC13-97FD90850A96'),
  (690,'982B9D48-ECA7-4096-958C-5A0852F3CAA9'),
  (691,'70355977-3112-41BC-A076-D773C7A096EA'),
  (692,'1DD19387-E8A6-4E84-A15A-2BBA5B6A445E'),
  (693,'96D9B76E-39ED-4900-A7F3-F530762D8FBD'),
  (694,'19F0E0E5-8241-4E8D-A15B-4E39B27BA543'),
  (695,'5C486735-888E-49DB-AEFF-8EFF3E8E89F6'),
  (696,'6C7EDC27-11F3-480A-906D-2F65740BBFED'),
  (697,'3E5A9E7D-A804-4BBB-AD02-B258B36B4CCC'),
  (698,'0C9D8EF6-DC6F-4A18-8E7C-41E5E4A545C5'),
  (699,'BF454D2A-4B52-4C19-BF3F-5E83B039B3E5'),
  (700,'76F4290E-0B54-4627-B706-844A90057C94'),
  (701,'0175C19A-0182-4F9F-B40B-EAFE3327460C'),
  (702,'BE06E20E-E410-463E-B8D1-AF36A2A02DD6'),
  (703,'C1DE9A9A-934D-4428-AA68-19A595C8D3C2'),
  (704,'23188C88-080F-4964-AD74-467D3913AE24'),
  (705,'338633C7-A3F9-402E-AEC5-A555CFC09199'),
  (706,'9E70426E-6A64-4E39-A738-E655BFC1A98F'),
  (707,'DD4493AE-EC65-45B9-9F0D-E5E8A82D0E37'),
  (708,'3778D56F-3C79-4EFE-8A92-B4EFA3CB6CEE'),
  (709,'794CBECC-7160-47BD-BDCD-29ADA7102E3D'),
  (710,'EB8B8A8B-5324-4C88-B10B-0522F161ADB6'),
  (711,'B9922119-B273-4901-BFC0-BB480EFFADB9'),
  (712,'C029328E-423E-4532-941E-82DD692A2AF0'),
  (713,'4B478D1D-3262-4263-BCFF-63260B2C0A08'),
  (714,'0A88D0B1-9A54-4147-85B8-EFF0BCD9EF4C'),
  (715,'3FBE36E2-D715-4A29-B91B-90AB8D282A87'),
  (716,'10DEFE4D-143E-4534-909F-D2045166BFAF'),
  (717,'F96071F5-422A-4173-AADA-21E4E402EBB7'),
  (718,'246A0F3D-9F32-4875-A29E-384ADC07EF6F'),
  (719,'8A51A795-4108-4BE8-8599-423B694A3F97'),
  (720,'02B83499-D55E-4F39-A071-1A557BEA8EDC'),
  (721,'C025F85C-6563-4400-920F-5A4785B6EFEE'),
  (722,'A71AD72D-F46E-4BA9-ACA9-05818BB71896'),
  (723,'F9F00C7C-993A-4651-969C-897865588E21'),
  (724,'2028FC76-1119-4C5C-B9FA-EBC11BD68F31'),
  (725,'7618EC64-DF11-4753-A13A-63C834591D00'),
  (726,'46F4D1EF-AF9E-4FF7-91A2-1E8767CDF729'),
  (727,'95622296-1772-4D81-9ABA-419E1F593C5F'),
  (728,'FA21F75D-6768-462E-97EA-532FDE395B01'),
  (729,'631A796A-CAAA-4ACF-8020-7F517F05AB8D'),
  (730,'2577C7D5-977D-42A2-88A8-CDD9FC66B0B7'),
  (731,'B63C0614-20C9-4BAF-9AB8-5174B2863524'),
  (732,'F70DC335-141E-447A-9D61-97BBBE0315F2'),
  (733,'BE7018AE-FCBF-4CC3-80E3-1A01C90FC7BE'),
  (734,'DCF91922-678B-438A-935C-206FE064EBFB'),
  (735,'BE15BE47-25DB-46D7-B587-9EDB53CDB8E6'),
  (736,'497E3E73-956F-4511-B2F5-F883E6183EF7'),
  (737,'F4C3F006-CF76-4AAB-8EBD-962350D2FF17'),
  (738,'552CF43E-FBB8-45BB-813F-EA4974CBFAB0'),
  (739,'753B92CE-F16D-464F-9F22-51D9F41849C3'),
  (740,'8AAE03CD-6C82-409F-889E-B5E271992BC6'),
  (741,'E1B677FE-9DF8-474F-A3D7-84007D79F3C3'),
  (742,'4161BD8A-1954-479A-A6DE-B735EB1E65E2'),
  (743,'3DEAC1F4-9072-4E72-9E33-DB5E5F8BCF12'),
  (744,'50EF5A2F-E802-42EF-877C-748CCD756596'),
  (745,'5198A5FD-9822-4D95-94CA-2BA57659C5D4'),
  (746,'6723BA73-D46C-4797-BB93-DD615CC65E5B'),
  (747,'F2BB0263-6C71-46B0-831F-B15975AC8D13'),
  (748,'6FBC96DE-42E7-43CF-B5C8-9D258FE9BEAF'),
  (749,'1BA5CCD4-47BF-4713-B413-98655A58209F'),
  (750,'8486F2EE-2527-448D-B7CB-D02FCBF8D305'),
  (751,'7CE2E9B4-1DA5-481C-93B7-C14F4A2E6E61'),
  (752,'BECA14BC-B289-4DD2-998A-4007760FD4A6'),
  (753,'88F356B4-B714-4BBC-8154-ED3387CBC973'),
  (754,'55E94FC4-9704-447C-898F-D34FAA05ECA1'),
  (755,'7C3FBCC0-69E2-4DB1-A70A-DCA09E674498'),
  (756,'6911CC35-F5CB-487D-8DB4-549050D78490'),
  (757,'20EBCAF5-D746-454D-A5D4-568A8C463015'),
  (758,'89F9A510-F184-4D13-9CB2-10329F039DB5'),
  (759,'65FE0795-4D1E-4E2E-AC55-7D603032DDC4'),
  (760,'9624DA4F-CF56-4EEF-8AEF-EFC8EF43B5D6'),
  (761,'B21A7898-23BC-417E-92B6-AD92B4417A96'),
  (762,'D5B6246E-176C-4EA0-8F9C-B8C1B1D697B7'),
  (763,'735BB91B-DA96-4BF2-BD9D-7D47F754F2B2'),
  (764,'09705D89-87CC-4940-94F9-4E912A5D405A'),
  (765,'46F49582-CD9F-4B2A-AECD-354BC41C199C'),
  (766,'A5E662DE-AA00-4D28-AA64-46D72B7DCF73'),
  (767,'8A29E85E-A197-458F-8D4A-86EB9DF4F051'),
  (768,'EC591447-08EE-4F38-B03C-06CC5AE8ED1E'),
  (769,'4E3DBA86-95DE-4DEE-9D0B-FD545DC8E5E6'),
  (770,'564C2879-3CC8-4E3D-BF45-7F6123C04D42'),
  (771,'AF3050D2-5F1E-42C5-ACBC-D9B224382C01'),
  (772,'032B1771-EBCD-46BC-9DA8-08331190567C'),
  (773,'CB3417D3-E249-41D1-B6DA-ECB91BD0B98E'),
  (774,'0CD66AD4-BF29-4029-A8FD-3EE9606A6299'),
  (775,'28942A8F-597D-4D2A-8E54-B00E5B38ABC4'),
  (776,'0B49F800-F70B-4715-A4C7-E781660C0B34'),
  (777,'B048A7D6-D266-473A-8DCD-4F8CD6207F15'),
  (778,'F1AB445E-5C57-408C-8F74-67F9B1DFB11A'),
  (779,'4DAFCD5E-8C25-4BC5-9D6A-4E855A98F278'),
  (780,'A94D7A42-45E3-4823-BE66-AA7DFE54B57B'),
  (781,'3D52F579-B182-4314-A325-340C97570B3F'),
  (782,'055A3CD7-D58B-475C-8F1C-7F1065FF98EE'),
  (783,'0442F608-2F34-4760-A7C4-0A1F3C0F3574'),
  (784,'635AAAC0-1E97-4B28-8A8A-D1B3250E29FD'),
  (785,'4089403E-393F-497E-AA21-B7F44667B2B8'),
  (786,'64975D96-0F52-4008-8177-189D4C7E4B95'),
  (787,'2857B26D-E9D2-4502-BC30-E25A130B4690'),
  (788,'1BF238CB-4B3D-410B-94F8-B628D68A5083'),
  (789,'4E39D4FA-0526-4D9A-A4E3-E73926792431'),
  (790,'454F1E34-568F-44F5-ADA3-568797C2D103'),
  (791,'D2AB9B05-8672-48BC-A032-A2CDDFF28590'),
  (792,'0EDC50A9-20DC-4219-AFE4-DD0FD866BBFF'),
  (793,'7849A709-8EE2-44AB-9925-286D0BB32C40'),
  (794,'BCD67097-3B4E-40CC-A81D-84F6C1A26D42'),
  (795,'C2CE1497-822A-4290-9A9A-1A41328A7A94'),
  (796,'B18161DD-7F30-405D-AE5F-53B15A7FEF4E'),
  (797,'E65C656D-4358-4D7D-A486-161AD26CFA56'),
  (798,'A3070E0E-38AA-44F7-A44F-A08D7DA8C59E'),
  (799,'0D938B00-2986-49B4-921E-F6C0C130ADB2'),
  (800,'CF7338A9-2134-4033-8F46-9B23FAC18870'),
  (801,'9D4E5DDA-E092-455C-B2E9-2A8D284ECFE6'),
  (802,'8DB8A806-23C5-4A54-BDFA-9E438F202F11'),
  (803,'BBD2C0DB-0A36-4FBB-AEE6-1B24F200C77D'),
  (804,'7A518FF7-FA0B-42E1-975F-38FF3CE18673'),
  (805,'3DEC323E-D2F6-4985-A734-07886AEA17E8'),
  (806,'A24BB451-7244-48C4-BF0D-462FB5D315E2'),
  (807,'8D0B50BB-96F1-4C3F-86DF-D438CEE36412'),
  (808,'B073D1CE-50EA-43A5-A784-9169D9F3D31C'),
  (809,'FC4A2071-D599-434C-AA73-3CE6037D315B'),
  (810,'FAB8F82B-D894-4F68-BC42-4F6485847FDB'),
  (811,'A9800A34-26BF-472B-9131-AFC4788421D1'),
  (812,'2C4EB5F1-A9AB-4DCD-A268-9CDDA5535093'),
  (813,'51A1FCA5-C6E4-4118-82E2-2C723E9A81F3'),
  (814,'C829C9D9-128F-46B3-AB8F-D21120A59CF5'),
  (815,'07230E08-FBA0-4C1D-B54A-F854F0667FC5'),
  (816,'B177557B-B527-4CE6-B092-49E0CA7AF016'),
  (817,'CA8EA5BD-5C22-4D0D-85BA-6B0AC35CACE3'),
  (818,'958C9FDE-B905-48C0-A05E-898F58E7CE6A'),
  (819,'4B620544-74B3-40EC-BD9D-C78C79B51066'),
  (820,'E59BB6FE-CF5C-4F3B-9290-543305CCC593'),
  (821,'94569B11-4462-4367-8C2A-A30DE4E6142D'),
  (822,'709F8527-BC7F-4945-8B1F-3F6E0B29BB12'),
  (823,'2D0AA8B7-D2A6-45E5-A818-A4F6D771E30E'),
  (824,'EB97EE6A-D983-4C0C-AA01-38FE531628DD'),
  (825,'17F7DA0A-BE41-44C9-9590-B65DDAE6483D'),
  (826,'AA6BEAB0-5F28-4E40-961B-AB057ADA6117'),
  (827,'C4449035-62C8-439A-9FCF-37C56F57DD7F'),
  (828,'2A3830EA-1AE3-4CF2-827B-348894498505'),
  (829,'B0F4F06C-5355-405C-B387-B0A734775054'),
  (830,'05A9DC61-76C4-4599-8A5F-969336BB332E'),
  (831,'AE9C6959-AAC1-4510-9610-E02086C43850'),
  (832,'D966CD0C-B11F-44DE-91A1-FBC7AB1B6082'),
  (833,'6B109D8A-8ACC-4CFA-8290-3E79A4A27A8F'),
  (834,'157D5F3F-00B1-4F42-8B40-4BD808896593'),
  (835,'093D26E6-9946-4156-A466-A44A84197CAF'),
  (836,'0FC10E7B-0937-46AC-8568-B1CF85E68A8F'),
  (837,'0ECDF951-83DE-4E1A-8045-F6D154013ECE'),
  (838,'486470DC-41EA-452A-B480-3B959BD681E1'),
  (839,'7491BB15-1618-40E8-BEF4-CA841F367594'),
  (840,'0D6C8309-BC6C-481E-B107-CCA72AEDAC7E'),
  (841,'507649BD-5BEC-4FB6-84BE-D9737731C0A2'),
  (842,'36C87650-E760-41BD-BEB2-86BB6930B741'),
  (843,'452C803B-5775-4845-ACE1-679CDF1AF262'),
  (844,'382AF2A6-A754-468B-84B5-88AD0CE92BC5'),
  (845,'30C9938F-44B8-491D-B897-8E3B62E4DCE3'),
  (846,'D3E38AD4-C573-4A89-9C77-95EFA5AC9F62'),
  (847,'41E03A81-3FD9-42FF-8004-0CDC5BD1F272'),
  (848,'230A57EC-58C6-4FE5-A7CB-8FE9D637D816'),
  (849,'10315105-3CAA-4E8C-AD78-2949D446560B'),
  (850,'ADA3B61E-DC00-4DC0-8CEE-FD58C50BC37C'),
  (851,'963B3CF6-7808-4515-A494-0E65EDCA6F51'),
  (852,'38A030BD-9C32-4C7C-A89C-1387150F9A22'),
  (853,'384A58C4-0372-499C-A6F5-E8D468C649F4'),
  (854,'3D4DE903-7014-477D-AABF-7CACF06AD154'),
  (855,'792BD034-1945-4A58-BA84-EC76173783EF'),
  (856,'5E097AD6-2D5C-4849-B1FF-2001937CD6CC'),
  (857,'7963C0AF-A541-4390-A887-355E044CFCAD'),
  (858,'2F2D0C60-1739-4596-9667-1F3BB4A8F760'),
  (859,'748EA55A-E724-4FD9-9A05-1E9B1BF622F9'),
  (860,'C081F0D4-60D5-43BE-A6D0-F02B24A6153C'),
  (861,'B8B59E3E-DB3E-4BBF-94C1-3FF0C9FE6681'),
  (862,'5AEDCF2F-D2EE-48A5-AC88-B972F723393E'),
  (863,'E33811C7-B5A4-4721-823E-5D9B9EAA2EF7'),
  (864,'28CA1496-4483-4C8E-A76E-A4B7A648CDAF'),
  (865,'24C42BD9-8F48-45A7-B239-A42869926169'),
  (866,'B60B5295-1B2F-4D41-82ED-185D6937B336'),
  (867,'8476E6A5-DAA2-4D06-8E9C-D6766D05D804'),
  (868,'38D06813-ACDB-433C-8924-0DC504CEDC72'),
  (869,'CBD1CECE-979E-422C-9EDE-686C8372A80D'),
  (870,'841CA96A-DD94-4080-A3E1-886239E7C6F3'),
  (871,'F07376A4-FC8B-4635-89E4-670A57CE784E'),
  (872,'9F840B7E-025F-4767-BBC0-C7020C400561'),
  (873,'4611EAFD-A43F-4BBF-BD54-08ECC71E5494'),
  (874,'BD29CE70-B865-4387-880D-CE75D624217A'),
  (875,'A2010E75-D8F9-4507-BB26-1BF046E1B360'),
  (876,'44ECF72E-D849-4FF2-9B7A-C6D5EB9EF4D0'),
  (877,'1875812D-BCCC-4269-A100-3D7F2342A1E1'),
  (878,'AE90124E-51AC-4362-8451-D064074954F4'),
  (879,'6CEBBD26-7B76-40F0-94B6-462843837D64'),
  (880,'2F89A48B-6726-4773-8369-968F15946E5C'),
  (881,'7C252F19-F204-46F9-B7B3-CB65B1A93288'),
  (882,'7F606EE7-62E2-477F-884F-AC9E7644BA83'),
  (883,'161B805D-E041-4743-AF23-EDF3E9F12693'),
  (884,'F138D278-D6BD-4D3A-9C5E-7F2C6F774219'),
  (885,'D320DB53-03B8-463C-A040-0DB106C17141'),
  (886,'C9F375C8-6FA8-4F3D-90F7-831E68934A66'),
  (887,'9B9BB218-5586-4C72-A229-03AF5B4E8C1C'),
  (888,'32142F5F-357D-498A-B88D-801A5C45FF39'),
  (889,'F73C62C9-A874-4A9B-979F-837139FCC6C0'),
  (890,'83E61070-FB9F-493A-A059-10F715A885F6'),
  (891,'05FF1B87-6FDD-492F-A68A-2A3BF438C738'),
  (892,'80E50BB4-038F-41D5-B5D4-F684E367D325'),
  (893,'EDC5BFAB-5BE5-450C-9B62-04118E236AAE'),
  (894,'D14D444A-8637-4F5F-8309-D35E0696DBDD'),
  (895,'F6272BBF-59F9-4784-8799-C442C19A892E'),
  (896,'6AE033BE-C2B7-46A3-96F3-E6F75ADFA56B'),
  (897,'D59B7831-48FD-42FA-8A09-D480ECA83A07'),
  (898,'8AE77266-7A78-4C1F-B2A0-C88BD0FF99A0'),
  (899,'0E23EF7C-DB7E-4141-B9FA-83ED46D3C473'),
  (900,'085591BC-4398-4689-ADE0-008AA2A3DB1D'),
  (901,'6362A441-79E7-4FF0-BDD9-BC00799358D6'),
  (902,'6CBE0C24-8BC8-49AF-8446-2C9E132BFB6E'),
  (903,'E548BB83-B4FA-4A7C-BE45-5F0E7E509034'),
  (904,'FE573FB6-A329-4E7A-95BB-BDF17E289CDB'),
  (905,'ED93366A-A656-40C0-93DF-E7C56125A5A1'),
  (906,'9B65F440-B10D-451E-B318-79EEEA784538'),
  (907,'170FA12E-52CD-4B01-8EB9-015A68336FC9'),
  (908,'5706DBE5-790A-42C1-AC77-6C125AA10760'),
  (909,'E74EB36E-9429-410F-BF43-ABEFFDF3E8E7'),
  (910,'DAE426B8-FC63-4AB5-B3BF-23E05ECC6872'),
  (911,'28731A2B-66C6-45AB-B24E-26A0336E4F67'),
  (912,'0A8F0390-7076-4D4E-B694-917211EBB407'),
  (913,'D6F120AC-4492-4610-A67C-D2016F1BE877'),
  (914,'5F29361B-1077-4A60-968E-B5E228A25AA6'),
  (915,'3EC0EA70-3984-4755-A961-C7A02B2F73DC'),
  (916,'E47A8F75-BFA3-4470-A16E-F2873B8B7D6C'),
  (917,'88E87C20-80E6-4B93-90B8-084E502E1CC5'),
  (918,'F9F08026-64DE-45EB-AABE-E0AAA0AD224B'),
  (919,'A084FCBF-ED61-4CA4-A02A-01A17DC90D37'),
  (920,'0FB36F5B-D541-4A88-AED2-60F68AC2348D'),
  (921,'4E8FB3F9-8AE9-4A6E-8926-040BA585883D'),
  (922,'6F57878A-7E01-4E48-9D1B-67F4F359832F'),
  (923,'BE173C16-5C74-4147-9F08-2BDC1D0AC132'),
  (924,'71A899AF-C898-418D-BEBE-9F336A4A5DCD'),
  (925,'28FC517C-9F83-434E-9CB1-A2F89D04A9D1'),
  (926,'B2CA124F-B954-43FA-A40D-740E4F52DDFF'),
  (927,'BD07F1E3-D33A-4419-9E1E-01D46CCE0FD1'),
  (928,'836EAE36-D79A-46FF-85AD-85DADD67B8DF'),
  (929,'A0B70A9B-A8F9-4E16-B137-275198B489A4'),
  (930,'A895B9D5-4CDC-4CC2-A836-DEA4CBE9CC6F'),
  (931,'EE4C8A26-8A71-4A4A-BE90-706F0AEDFDD4'),
  (932,'A1A2B8C1-17DD-4135-88B2-22F250DC94D1'),
  (933,'FED02739-A012-4065-A10F-DA758AB1AB8C'),
  (934,'541EBD7E-761E-4C7C-B0AB-A950F650D396'),
  (935,'39ED6629-5ACA-41C8-BC6A-59C0161BB4BC'),
  (936,'D03C337C-48D1-4183-9D06-E02D7CD9DDAB'),
  (937,'988DF1CB-B2AD-4749-B350-FFD531D37E35'),
  (938,'B4DC804A-B9FE-4D5A-AABE-0BDAE2693370'),
  (939,'DF05F90F-8CF0-4260-8D61-E3AA384F2F09'),
  (940,'ED31E8DD-3E83-4D04-B4AA-7496A37EF499'),
  (941,'2474907E-1559-44F4-A8B4-D0EAFCB04E10'),
  (942,'EC138E44-4DCF-40CD-B5D5-BF3A407205D8'),
  (943,'065A769B-9440-4058-BC2A-F16D4DCC32A0'),
  (944,'7335D319-EF66-4720-B71A-DBCA40116E1E'),
  (945,'8200D9B6-404B-46CA-9852-6DA7605BCA05'),
  (946,'002A26B3-0579-4145-9EA7-55C31416B851'),
  (947,'B7AD382F-F7BC-4FAD-9B67-5CC39C445CE9'),
  (948,'1C257121-B881-4B67-9CED-70C0B3C62124'),
  (949,'0E895951-6D0B-4C79-BF20-330F6EA05A9F'),
  (950,'AF62E68F-1CC4-4D4B-98CA-F30D4781D592'),
  (951,'FE021B68-5842-4581-8856-20969A7CA58C'),
  (952,'FCEF1ADD-F5CE-4D81-9D37-879F49FCE562'),
  (953,'F86E0110-932C-47BE-83F7-3BAD53B927DC'),
  (954,'3663B674-8305-4DA0-9166-A05F20D38E09'),
  (955,'DD027224-3ACE-44B2-BE91-D9AD8463D2C2'),
  (956,'A82B9ED0-4430-43DA-9104-B0DB48B5090B'),
  (957,'E333A2C8-BCA0-49B5-8A5E-1722A2306E90'),
  (958,'1254068C-9561-4B11-95FC-64E7657075A8'),
  (959,'76577112-22DC-417F-A82F-6D4C929C0919'),
  (960,'EF201720-9741-4F6D-800A-2C739FAB6DAE'),
  (961,'332071BB-F79A-40FA-8AE5-820677E59F31'),
  (962,'E1D0C979-D6F4-47C8-BFB4-699205764E1D'),
  (963,'97EEB2B2-58D0-4EB1-9C68-9C8F96EC3D56'),
  (964,'F33ED416-EB37-4A86-844B-DEB901642C03'),
  (965,'7DC6C438-1E4C-4BD4-BD7C-223726B64AB0'),
  (966,'C8EA5F18-D175-402C-9E26-3EA6EB6D84AE'),
  (967,'F5BA64F8-7E51-4F75-8378-54C37A7D9B29'),
  (968,'1FF855A9-6F24-42BD-B590-5CE83D5D75E3'),
  (969,'4FA52A88-60CB-4864-9FF2-7A72D016DC4F'),
  (970,'12FC1A68-88BF-4992-8BA2-50DB77DF54B2'),
  (971,'EB23661F-073E-4626-9EFD-A509DC09851A'),
  (972,'0C5BAF68-4DF3-46C4-B379-6B05498686D9'),
  (973,'7B7C9212-BBA2-4CD6-B1DD-B81FF4B74425'),
  (974,'80ABD65A-7251-4758-B010-3BC3A4099FF7'),
  (975,'14E7807B-D849-4FE7-B22B-A3C71A70BEF2'),
  (976,'3A813580-1421-479A-9897-CF15934D75D6'),
  (977,'17D4570A-E5CF-448E-AF08-1FE974EF280C'),
  (978,'4EC90D8D-55C1-44D8-98D5-5BC9F988A1A8'),
  (979,'0940FCE6-CA15-47AB-8800-198926DB5E9A'),
  (980,'436527BC-9A85-472B-8B5E-E23985719D83'),
  (981,'2FEBB92D-613F-49AC-82F9-350182B1EA5C'),
  (982,'BF16BB92-BB7D-488D-AAEC-47CE0DDD634D'),
  (983,'A435ADEA-0D12-4D7E-941D-40ECEB6AF9B4'),
  (984,'ED5AC4E8-1E3A-4AFE-907D-CBDEDCE74A1F'),
  (985,'7EADEE06-5E30-4DA4-AFCF-0207CE805763'),
  (986,'CB37F80A-680F-4DC6-9B7D-E7F59B9B8631'),
  (987,'0CD05BB8-73CF-4EE3-BDF2-19F921B6BF65'),
  (988,'CB39E1EF-86E7-4490-831E-187204814C3E'),
  (989,'8CE27F75-AE20-42FF-9B8A-1BBAEFA013E9'),
  (990,'3329EF43-4D2B-45E1-920A-104E742A10DE'),
  (991,'ED8FC22D-9E5B-4662-92BD-981D8B2FA5A5'),
  (992,'3EDAE179-AD29-4513-9F5A-A4C09BFBB219'),
  (993,'D489489A-2413-4C06-AC0D-982897FF07B3'),
  (994,'A6CF46B5-F71C-4C15-A451-45F20AB941B5'),
  (995,'B764C8F3-CC29-466C-B5E4-B3BEDB4AF03E'),
  (996,'262A1088-214D-466B-9EC7-02F5D0A58DEC'),
  (997,'5114C3D9-92CE-4194-94F8-636CDE7D8B1A'),
  (998,'42FC619C-77B5-47E0-83F9-40882607CD6D'),
  (999,'A0404889-C1E3-424C-96CB-65B64EB341FC'),
  (1000,'A11A201D-EBCC-435F-BE07-B93EFC4C3AB1');
COMMIT;

INSERT INTO tbl_report_controls (rc_id, rc_list_id, rc_parent, rc_type, rc_name, rc_guid, rc_left, rc_top, rc_width, rc_height, rc_align, rc_printable, rc_value_text, rc_value_int, rc_back_color, rc_border_color, rc_border_sides, rc_border_width, rc_text_font, rc_text_size, rc_text_style, rc_text_color, rc_text_h_alig, rc_text_v_align, rc_text_bidi, rc_text_rotation, rc_text_warp, rc_autosize, rc_data_field_1, rc_data_field_2, rc_table_sync, rc_image_center, rc_image_proportion, rc_image_stretch, rc_arraw_cap, rc_arraw_tail, rc_arraw_size, rc_arraw_tilt, rc_line_style, rc_fill_style, rc_corner_angle, rc_show_caption, rc_style) VALUES
  (1,121,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (2,121,0,3,'TRepDynamicLabel','EE269FB3-90AD-4E17-B4A9-F9A5CE275349',543,68,93,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_number','رقم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (3,121,0,3,'TRepDynamicLabel','834122AF-3719-40A5-AA65-34FDA4785894',543,92,93,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (4,121,0,3,'TRepDynamicLabel','0419ABB8-75C7-47CD-A879-CA99563357AF',551,116,85,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_date','تاريخ الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (5,121,0,3,'TRepDynamicLabel','F13FD5C2-FAED-40C0-900C-40F39BA9D3DA',34,91,65,17,0,1,'آجل',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_pay_type','طريقة الدفع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (6,121,0,3,'TRepDynamicLabel','DE15921F-8C90-4E0E-91F3-E0E5D69D624A',11,139,625,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (7,121,0,1,'TRepLabel','',101,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (8,121,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',34,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (9,121,0,1,'TRepLabel','',372,91,73,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (10,121,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',184,91,186,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (11,121,0,1,'TRepLabel','',637,68,65,17,0,1,'رقم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (12,121,0,1,'TRepLabel','',637,92,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (13,121,0,1,'TRepLabel','',637,116,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (14,121,0,1,'TRepLabel','',637,139,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (15,121,0,1,'TRepLabel','',101,91,65,17,0,1,'طريقة الدفع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (16,121,0,3,'TRepDynamicLabel','C368BBD8-2B93-4340-8384-3F5FBF034D59',183,114,186,17,0,1,'مدير',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_user_name','منظم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (17,121,0,1,'TRepLabel','',372,114,73,17,0,1,'منظم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (18,121,0,3,'TRepDynamicLabel','0BFC491F-E211-4705-948B-4DBB234F19FF',183,68,186,17,0,1,'ابنية و اراضي',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','حساب العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (19,121,0,1,'TRepLabel','',372,68,73,17,0,1,'اسم العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (20,121,0,3,'TRepDynamicLabel','5E8BF6CA-013D-4034-B5D6-7795F5AE6AB0',485,116,65,17,0,1,'20:11:19',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_time','وقت الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (21,121,1,3,'TRepDynamicLabel','7D238777-7376-4634-889B-C33B4FA3D5DD',549,34,85,17,0,1,'10.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total_count','مجموع الكمية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (22,121,1,3,'TRepDynamicLabel','477E6E55-94E2-4EBC-93BC-549B15898994',549,58,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total','اجمالي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (23,121,1,3,'TRepDynamicLabel','8B877C81-B4EE-4DCC-8388-590031CD686E',549,10,85,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_record_count','عدد الاقلام',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (24,121,1,3,'TRepDynamicLabel','759AB118-35EA-4F2E-8ED1-34ECD2D4053F',266,10,85,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_discount_total','الحسم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (25,121,1,3,'TRepDynamicLabel','C00FBDFD-F107-4CC9-9A0D-D7826ADF3624',267,56,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_net','صافي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (26,121,1,3,'TRepDynamicLabel','2B42683F-CAEC-4921-B529-DB733E87F692',184,81,449,17,0,1,'الف ليرة سورية',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_net_tafkit','المبلغ تفقيط',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (27,121,1,3,'TRepDynamicLabel','3486D900-BADE-48AF-A18B-6F4D6907247F',15,9,85,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_payment','دفعة نقدية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (28,121,1,3,'TRepDynamicLabel','29A1A55A-2A3E-4835-BFEA-DB4424D138FD',15,33,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'tbl_remain_value','باقي للدفع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (29,121,1,3,'TRepDynamicLabel','BB69EF67-3D7B-4F61-B0B6-DA9ACDE4CEFF',15,56,85,17,0,1,'0.00 ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_previous_balance','الرصيد السابق للعميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (30,121,1,3,'TRepDynamicLabel','4554B055-4658-450D-8FBD-083A09467E1A',15,81,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_current_balance','الرصيد الحالي للعميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (31,121,1,1,'TRepLabel','',637,10,75,17,0,1,'عدد الاقلام:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (32,121,1,1,'TRepLabel','',637,34,75,17,0,1,'مجموع الكمية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (33,121,1,1,'TRepLabel','',637,58,75,17,0,1,'اجمالي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (34,121,1,1,'TRepLabel','',637,81,72,17,0,1,'المبلغ تفقيط:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (35,121,1,1,'TRepLabel','',354,56,73,17,0,1,'صافي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (36,121,1,1,'TRepLabel','',354,33,73,17,0,1,'الضريبة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (37,121,1,1,'TRepLabel','',354,10,73,17,0,1,'الحسم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (38,121,1,1,'TRepLabel','',102,33,65,17,0,1,'باقي للدفع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (39,121,1,1,'TRepLabel','',102,56,65,17,0,1,'رصيد سابق:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (40,121,1,1,'TRepLabel','',102,10,65,17,0,1,'دفعة نقدية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (41,121,1,3,'TRepDynamicLabel','8B24830A-DEFA-4A40-B24D-7CD37271D6B4',266,33,85,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_vat_value','الضريبة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (42,121,1,1,'TRepLabel','',102,81,65,17,0,1,'رصيد حالي:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (47,124,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (48,124,0,1,'TRepLabel','',637,68,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (49,124,0,1,'TRepLabel','',637,91,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (50,124,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (51,124,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (52,124,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (53,124,0,1,'TRepLabel','',270,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (54,124,0,1,'TRepLabel','',471,68,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (55,124,0,3,'TRepDynamicLabel','2B43029B-CD4E-493B-8599-E8E9B93E70A6',363,68,105,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (56,124,0,3,'TRepDynamicLabel','3D6BEC34-FCA8-4428-87DB-038A52ECA396',568,68,65,17,0,1,'7',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_number','رقم السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (57,124,0,3,'TRepDynamicLabel','368F53EF-F6BE-48D6-AD3B-1DAB6B9F329A',184,68,81,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_date','تاريخ السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (58,124,0,3,'TRepDynamicLabel','7D6EFE7B-2FF5-4D78-A0D8-6B7D365E1BB4',43,90,591,17,0,1,'[جدول الرواتب]',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (59,124,1,3,'TRepDynamicLabel','73749CC6-3344-4CBC-9560-46450B7BD479',413,4,76,17,0,1,'1,500.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_debit','مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (60,124,1,3,'TRepDynamicLabel','612993FF-6A9F-408B-94C2-7BCCE9AB3C63',338,4,75,17,0,1,'1,500.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit','دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (65,125,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (70,126,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (71,126,0,1,'TRepLabel','',637,68,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (72,126,0,1,'TRepLabel','',637,91,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (73,126,0,1,'TRepLabel','',471,68,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (74,126,0,1,'TRepLabel','',270,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (75,126,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (76,126,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (77,126,0,1,'TRepLabel','',638,115,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (78,126,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',364,91,271,17,0,1,'الصندوق',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (79,126,0,3,'TRepDynamicLabel','68DC558F-9A84-45F1-AD3F-1CD99BB0F74B',30,113,605,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (80,126,0,3,'TRepDynamicLabel','483FCBE5-B571-47E6-929A-D461FE6129CD',183,68,85,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_date','تاريخ السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (81,126,0,3,'TRepDynamicLabel','4EB9E840-339B-47F6-BF3E-2AA75690BFC5',367,67,101,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (82,126,0,3,'TRepDynamicLabel','478E8241-C59E-45D2-B113-15CAEB2500FA',546,68,89,17,0,1,'10',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_number','رقم السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (83,126,1,3,'TRepDynamicLabel','48E36F2C-8BDD-4FF4-8F05-93FF74D0E46E',369,4,76,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_debit','مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (84,126,1,3,'TRepDynamicLabel','E895D2DD-D43F-4CC7-88F4-2FDBF2067450',294,4,75,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit','دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (89,127,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (90,127,0,1,'TRepLabel','',637,67,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (91,127,0,1,'TRepLabel','',637,101,65,17,0,1,'السيد',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (92,127,0,1,'TRepLabel','',270,67,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (93,127,0,1,'TRepLabel','',102,67,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (94,127,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,67,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (95,127,0,3,'TRepDynamicLabel','2A119446-53CE-4C40-9C26-B5A50E452BDA',363,67,85,17,0,1,'5,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_value','المبلغ',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (96,127,0,3,'TRepDynamicLabel','665DEF07-FB15-4DC4-8DEF-7197912148F4',295,155,373,17,0,1,'خمسة آلاف ليرة سورية',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_tafkit','المبلغ تفقيط',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (97,127,0,3,'TRepDynamicLabel','242A2813-0BEF-4931-AA1B-50BEA4FB8C15',45,183,553,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (98,127,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',495,101,137,17,0,1,'عميل نقدي ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (99,127,0,3,'TRepDynamicLabel','4B89EFA2-29A3-409F-A25E-C45AA9BF282C',178,67,89,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_date','تاريخ السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (100,127,0,3,'TRepDynamicLabel','5D17EEE1-F2E2-4365-A9EE-7FBCBBFA86DD',567,67,65,17,0,1,'14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_number','رقم السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (101,127,0,1,'TRepLabel','',453,67,65,17,0,1,'المبلغ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (102,127,0,1,'TRepLabel','',425,101,65,17,0,1,'المحترم',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (103,127,0,1,'TRepLabel','',295,129,373,17,0,1,'نعلمكم باننا قيدنا عليكم دفعة بالمبلغ المدون اعلاه و قدره فق',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (104,127,0,1,'TRepLabel','',393,227,85,17,0,1,'توقيع المستلم',0,16777215,0,0,1,'Tahoma',8,0,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (105,127,0,1,'TRepLabel','',603,183,65,17,0,1,'و ذلك لقاء',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (106,127,0,1,'TRepLabel','',141,228,89,17,0,1,'امين الصندوق',0,16777215,0,0,1,'Tahoma',8,0,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (111,128,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (112,128,0,1,'TRepLabel','',637,67,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (113,128,0,1,'TRepLabel','',637,101,65,17,0,1,'السيد',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (114,128,0,1,'TRepLabel','',270,67,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (115,128,0,1,'TRepLabel','',102,67,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (116,128,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,67,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (117,128,0,3,'TRepDynamicLabel','2A119446-53CE-4C40-9C26-B5A50E452BDA',363,67,85,17,0,1,'5,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_value','المبلغ',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (118,128,0,3,'TRepDynamicLabel','665DEF07-FB15-4DC4-8DEF-7197912148F4',295,155,373,17,0,1,'خمسة آلاف ليرة سورية',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_tafkit','المبلغ تفقيط',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (119,128,0,3,'TRepDynamicLabel','242A2813-0BEF-4931-AA1B-50BEA4FB8C15',45,183,553,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (120,128,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',495,101,137,17,0,1,'عميل نقدي ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (121,128,0,3,'TRepDynamicLabel','4B89EFA2-29A3-409F-A25E-C45AA9BF282C',178,67,89,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_date','تاريخ السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (122,128,0,3,'TRepDynamicLabel','5D17EEE1-F2E2-4365-A9EE-7FBCBBFA86DD',567,67,65,17,0,1,'14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_number','رقم السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (123,128,0,1,'TRepLabel','',453,67,65,17,0,1,'المبلغ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (124,128,0,1,'TRepLabel','',425,101,65,17,0,1,'المحترم',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (125,128,0,1,'TRepLabel','',295,129,373,17,0,1,'نعلمكم باننا قيدنا لكم دفعة بالمبلغ المدون اعلاه و قدره فقط:',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (126,128,0,1,'TRepLabel','',393,227,85,17,0,1,'توقيع المستلم',0,16777215,0,0,1,'Tahoma',8,0,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (127,128,0,1,'TRepLabel','',603,183,65,17,0,1,'و ذلك لقاء',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (128,128,0,1,'TRepLabel','',141,228,89,17,0,1,'امين الصندوق',0,16777215,0,0,1,'Tahoma',8,0,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (133,134,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (134,134,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (135,134,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (136,134,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (137,134,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (138,134,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (139,134,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',263,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (140,134,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',263,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (141,134,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (142,134,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (143,134,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',50,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (144,134,0,1,'TRepLabel','',181,91,65,17,0,1,'طريقة الدفع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (145,134,0,3,'TRepDynamicLabel','553E58F2-A786-4201-8078-24F525CE0252',50,91,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_pay_type','طريقة الدفع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (150,135,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,286,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (151,135,0,3,'TRepDynamicLabel','EE269FB3-90AD-4E17-B4A9-F9A5CE275349',153,64,60,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_number','رقم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (152,135,0,3,'TRepDynamicLabel','0419ABB8-75C7-47CD-A879-CA99563357AF',51,64,63,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_date','تاريخ الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (153,135,0,1,'TRepLabel','',216,64,65,17,0,1,'رقم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (154,135,0,1,'TRepLabel','',114,64,36,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (155,135,0,3,'TRepDynamicLabel','0BFC491F-E211-4705-948B-4DBB234F19FF',20,88,194,17,0,1,'ابنية و اراضي',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','حساب العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (156,135,0,1,'TRepLabel','',216,88,65,17,0,1,'اسم العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (157,135,0,3,'TRepDynamicLabel','5E8BF6CA-013D-4034-B5D6-7795F5AE6AB0',1,64,49,17,0,1,'13:56:55',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_time','وقت الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (158,135,1,3,'TRepDynamicLabel','7D238777-7376-4634-889B-C33B4FA3D5DD',127,34,79,17,0,1,'10.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total_count','مجموع الكمية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (159,135,1,3,'TRepDynamicLabel','477E6E55-94E2-4EBC-93BC-549B15898994',127,58,79,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total','اجمالي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (160,135,1,3,'TRepDynamicLabel','8B877C81-B4EE-4DCC-8388-590031CD686E',127,10,79,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_record_count','عدد الاقلام',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (161,135,1,3,'TRepDynamicLabel','759AB118-35EA-4F2E-8ED1-34ECD2D4053F',2,10,73,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_discount_total','الحسم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (162,135,1,3,'TRepDynamicLabel','C00FBDFD-F107-4CC9-9A0D-D7826ADF3624',2,56,73,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_net','صافي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (163,135,1,3,'TRepDynamicLabel','2B42683F-CAEC-4921-B529-DB733E87F692',4,104,203,45,0,1,'الف ليرة سورية',0,16777215,0,0,1,'Tahoma',8,0,0,0,0,1,0,0,0,'fld_net_tafkit','المبلغ تفقيط',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (164,135,1,3,'TRepDynamicLabel','3486D900-BADE-48AF-A18B-6F4D6907247F',127,81,79,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_payment','دفعة نقدية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (165,135,1,3,'TRepDynamicLabel','29A1A55A-2A3E-4835-BFEA-DB4424D138FD',2,81,73,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'tbl_remain_value','باقي للدفع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (166,135,1,1,'TRepLabel','',209,10,77,17,0,1,'عدد الاقلام:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (167,135,1,1,'TRepLabel','',209,34,77,17,0,1,'مجموع الكمية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (168,135,1,1,'TRepLabel','',209,58,77,17,0,1,'اجمالي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (169,135,1,1,'TRepLabel','',209,105,77,17,0,1,'المبلغ تفقيط:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (170,135,1,1,'TRepLabel','',77,56,47,17,0,1,'الصافي:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (171,135,1,1,'TRepLabel','',77,33,47,17,0,1,'الضريبة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (172,135,1,1,'TRepLabel','',77,10,47,17,0,1,'الحسم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (173,135,1,1,'TRepLabel','',77,81,47,17,0,1,'الباقي:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (174,135,1,1,'TRepLabel','',210,82,75,17,0,1,'دفعة نقدية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (175,135,1,3,'TRepDynamicLabel','8B24830A-DEFA-4A40-B24D-7CD37271D6B4',2,33,73,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_vat_value','الضريبة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (180,136,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (181,136,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (182,136,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (183,136,0,1,'TRepLabel','',637,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (184,136,0,1,'TRepLabel','',637,91,65,17,0,1,'مصدر الدفع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (185,136,0,3,'TRepDynamicLabel','551EBA12-6B16-4B01-97B5-8971E3E3A449',465,91,169,17,0,1,'الصندوق',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','مصدر الدفع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (186,136,0,3,'TRepDynamicLabel','856F2AC0-EF85-4DC7-94E6-D6F18A597DFA',465,66,169,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_payroll_date','التاريخ',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (187,136,1,3,'TRepDynamicLabel','20CFFBC5-119B-43E6-B39B-239F450AF905',371,4,64,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'emp_payroll_det_salary','مجموع الرواتب',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (188,136,1,3,'TRepDynamicLabel','65EB10A5-EE2F-4FCD-B872-39A27D4605B4',307,4,64,17,0,1,'500.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'emp_payroll_det_advance','مجموع السلف',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (189,136,1,3,'TRepDynamicLabel','F5412496-D0DB-492E-809C-22EFB2D555B6',243,4,64,17,0,1,'500.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'emp_payroll_det_paid','صافي الرواتب',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (194,137,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (195,137,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (196,137,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (197,137,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (198,137,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (199,137,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (200,137,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (201,137,1,3,'TRepDynamicLabel','DBC2B613-D10E-47C2-9755-69C046B74C0C',251,4,80,17,0,1,'3,022.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (202,137,1,3,'TRepDynamicLabel','1B1E5AE7-A8B9-48FB-B48D-A6E580BD0542',171,4,80,17,0,1,'3,022.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (207,138,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (208,138,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',516,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (209,138,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',516,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (210,138,0,1,'TRepLabel','',633,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (211,138,0,1,'TRepLabel','',633,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (212,138,0,1,'TRepLabel','',445,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (213,138,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',305,68,137,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (214,138,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (215,138,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (216,138,1,3,'TRepDynamicLabel','1F6A2BB7-534E-4225-B934-947965C91FF8',213,4,67,17,0,1,'24,528,135.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (217,138,1,3,'TRepDynamicLabel','1D2C4920-86B0-408E-B728-F2F1A7130776',148,4,65,17,0,1,'24,528,135.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (222,139,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (223,139,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (224,139,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (225,139,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (226,139,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (227,139,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (228,139,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (229,139,0,1,'TRepLabel','',449,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (230,139,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',273,68,169,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (231,139,1,3,'TRepDynamicLabel','096AEF64-06E8-4C9F-B8CF-9CD3A9C15E32',296,4,90,17,0,1,'1,250.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (232,139,1,3,'TRepDynamicLabel','DF1AA2F0-DD0A-4777-8FF3-904845019A54',206,4,90,17,0,1,'1,250.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (233,139,1,3,'TRepDynamicLabel','B21F364A-2A0C-4440-8D60-E41E726332CE',116,4,90,17,0,1,'1,260.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_debit_temp','رصيد مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (234,139,1,3,'TRepDynamicLabel','B2C72DDD-3FD2-47F3-BEA7-4F905B850394',26,4,90,17,0,1,'1,260.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit_temp','رصيد دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (239,140,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (240,140,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',532,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (241,140,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',532,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (242,140,0,1,'TRepLabel','',649,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (243,140,0,1,'TRepLabel','',649,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (244,140,0,1,'TRepLabel','',465,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (245,140,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',281,68,181,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (246,140,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (247,140,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (248,140,0,1,'TRepLabel','',465,91,65,17,0,1,'الرصيد:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (249,140,0,3,'TRepDynamicLabel','6025B8E7-7DBD-427A-8D66-DED21BD154CF',287,91,156,17,0,1,'24,326,053.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_value','الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (250,140,0,3,'TRepDynamicLabel','DED7FE8B-50A0-4F2A-B319-E1A020920F2A',443,91,20,17,0,1,' لنا',0,16777215,0,0,1,'Tahoma',8,1,0,0,1,1,0,0,0,'fld_balance_type','نوع الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (251,140,0,3,'TRepDynamicLabel','CB71C19C-BABE-4F93-80A6-2152342E16C2',10,115,453,17,0,1,'اربعة و عشرون مليوناً و ثلاثمائة و ستة و عشرون الفاً و ثلاث ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_tafkit','القيمة تفقيطاً',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (252,140,1,3,'TRepDynamicLabel','11286B36-374A-46B6-9E1F-2AC21B5373F2',366,4,66,17,0,1,'24,420,183.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (253,140,1,3,'TRepDynamicLabel','1C5499AB-2F0A-44B4-B3F9-BDE5FEA74A7F',298,4,68,17,0,1,'94,130.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (258,141,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,1047,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (259,141,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',852,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (260,141,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',852,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (261,141,0,1,'TRepLabel','',969,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (262,141,0,1,'TRepLabel','',969,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (263,141,0,1,'TRepLabel','',781,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (264,141,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',641,68,137,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (265,141,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (266,141,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (267,141,0,1,'TRepLabel','',781,91,65,17,0,1,'الرصيد:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (268,141,0,3,'TRepDynamicLabel','6025B8E7-7DBD-427A-8D66-DED21BD154CF',650,91,97,17,4,1,'24,326,053.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_value','الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (269,141,0,3,'TRepDynamicLabel','DED7FE8B-50A0-4F2A-B319-E1A020920F2A',746,91,33,17,0,1,' لنا',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_type','نوع الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (270,141,0,3,'TRepDynamicLabel','CB71C19C-BABE-4F93-80A6-2152342E16C2',34,91,609,17,0,1,'اربعة و عشرون مليوناً و ثلاثمائة و ستة و عشرون الفاً و ثلاث ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_tafkit','القيمة تفقيطاً',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (271,141,1,3,'TRepDynamicLabel','11286B36-374A-46B6-9E1F-2AC21B5373F2',680,4,78,17,0,1,'24,420,183.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (272,141,1,3,'TRepDynamicLabel','1C5499AB-2F0A-44B4-B3F9-BDE5FEA74A7F',610,4,70,17,0,1,'94,130.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (277,144,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (278,144,0,1,'TRepLabel','',637,68,113,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (279,144,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (280,144,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (281,144,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (282,144,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (283,144,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (284,144,1,3,'TRepDynamicLabel','1361EDA6-42BF-4D6D-86E0-C499451160BB',273,4,89,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_debit','مدين ارصدة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (285,144,1,3,'TRepDynamicLabel','09A76BA7-AD8D-4AA9-A1A7-34F7CED556D2',190,4,83,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit','دائن ارصدة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (286,144,1,3,'TRepDynamicLabel','8C881ECC-29F0-426C-8B0D-9F7726906EAD',103,4,87,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'sum_debit','مدين مجاميع',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (287,144,1,3,'TRepDynamicLabel','954708D8-8684-42F4-AA03-E6992BDB08DC',9,4,94,17,0,1,'1,260.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'sum_credit','دائن مجاميع',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (292,145,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (293,145,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (294,145,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (295,145,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (296,145,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (297,145,0,1,'TRepLabel','',441,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (298,145,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (299,145,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (300,145,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',230,68,208,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (301,145,0,1,'TRepLabel','',441,92,65,17,0,1,'المركز:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (302,145,0,3,'TRepDynamicLabel','5A16F330-2FC2-4585-9E71-36B97BD846C8',233,91,205,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_costcenter_name','مركز الكلفة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (303,145,1,3,'TRepDynamicLabel','4812E8B6-E80D-4680-B8EE-97810436F358',261,4,64,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (304,145,1,3,'TRepDynamicLabel','EFA30EA9-E382-43CC-8B4C-2E2E07564B33',193,4,68,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (309,146,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (310,146,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (311,146,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (312,146,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (313,146,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (314,146,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (315,146,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (316,146,0,1,'TRepLabel','',357,68,73,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (317,146,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',190,68,165,17,0,1,'الميزانية العامة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (318,146,1,3,'TRepDynamicLabel','9E759306-6A4B-4EF3-ABBF-21CF6CA14ACB',178,4,119,17,0,1,'22,198,746.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'debit','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (319,146,1,3,'TRepDynamicLabel','08EF0E41-7E70-4D58-94E8-54B7E40021BC',18,4,160,17,0,1,'22,198,746.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'credit','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (320,146,1,3,'TRepDynamicLabel','9943F3AE-3454-424B-A73D-A48357E09C37',178,27,119,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'debit','فرق مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (321,146,1,3,'TRepDynamicLabel','B41A8E98-2C74-4D57-B476-2429504F02D4',18,27,160,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'credit','فرق دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (326,147,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (327,147,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (328,147,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (329,147,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (330,147,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (331,147,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (332,147,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (333,147,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (334,147,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',48,91,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (335,147,0,1,'TRepLabel','',181,91,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (336,147,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (337,147,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',261,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (338,147,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (339,147,1,3,'TRepDynamicLabel','8DC799F8-D879-4930-8080-CE3A1B1E0D53',71,4,75,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_det_qty','رصيد كمية',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (344,150,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (345,150,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (346,150,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (347,150,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (348,150,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (349,150,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (350,150,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (351,150,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',261,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (352,150,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (353,150,0,1,'TRepLabel','',181,91,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (354,150,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (355,150,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (356,150,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',48,91,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','الفئة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (357,150,1,3,'TRepDynamicLabel','DC2B3B5A-CECE-46BA-9776-5A7CDBF22F82',329,4,64,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'total_qty_in','كمية داخلة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (358,150,1,3,'TRepDynamicLabel','F4C7E150-D5B5-4754-B44A-C7D354686C43',201,4,64,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'total_qty_out','كمية خارجة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (359,150,1,3,'TRepDynamicLabel','B8527AF0-6341-4C1B-ADFC-C6AE9591E0ED',265,4,64,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'total_amount_in','قيمة ادخال',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (360,150,1,3,'TRepDynamicLabel','757EAB11-A09D-4D43-865C-C8CB80E08A23',137,4,64,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'total_amount_out','قيمة اخراج',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (365,151,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (366,151,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (367,151,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (368,151,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (369,151,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (370,151,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (371,151,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (372,151,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (373,151,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',261,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (374,151,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (375,151,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (380,152,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (381,152,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (382,152,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (383,152,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (384,152,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (385,152,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (386,152,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (387,152,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',261,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (388,152,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (389,152,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (390,152,0,1,'TRepLabel','',181,91,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (391,152,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (392,152,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',48,91,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','الفئة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (393,152,1,3,'TRepDynamicLabel','D11C4860-0919-4CB1-81AF-3BFECB769EF2',321,4,81,17,0,1,'10.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_count_in','الكمية الداخلة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (394,152,1,3,'TRepDynamicLabel','DE2D8AC8-5FC1-4583-B25C-64AB0F69DD03',235,4,86,17,0,1,'7.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_count_out','الكمية الخارجة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (395,152,1,3,'TRepDynamicLabel','580C9701-DD21-4724-AAD1-F5A6E8B07052',158,4,77,17,0,1,'3.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_count','الكمية الحالية',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (396,152,1,3,'TRepDynamicLabel','008D88BF-EAEE-4C95-93F2-E8EB246CED0F',5,4,79,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'total_price','القيمة الاجمالية',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (401,153,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (402,153,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (403,153,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (404,153,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (405,153,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (406,153,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (407,153,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (408,153,1,3,'TRepDynamicLabel','43EBF1E1-F376-4450-944F-A62D50917F42',119,4,67,17,0,1,'500.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_cost_price','مجموع الكلفة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (409,153,1,3,'TRepDynamicLabel','67EB4C7A-792B-4DBF-ABBD-4124D0A5F81A',186,4,70,17,0,1,'250.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_sell_price','مجموع الفواتير',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (410,153,1,3,'TRepDynamicLabel','FFFDDCC2-9E36-4EAA-83E4-E34A700B8698',64,4,55,17,0,1,'-250.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'win_value','مجموع الربح',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (415,154,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (416,154,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (417,154,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',48,91,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','الفئة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (418,154,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (419,154,0,1,'TRepLabel','',181,91,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (420,154,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',261,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (421,154,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (422,154,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (423,154,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (424,154,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (425,154,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (426,154,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (427,154,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (428,154,1,3,'TRepDynamicLabel','94C794C5-1D16-47B0-A9D2-F5DA8EEF3A40',506,4,63,17,0,1,'500.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_cost_price','التكلفة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (429,154,1,3,'TRepDynamicLabel','33E9FF40-99CC-40F5-A192-9A792BF8F00D',436,4,70,17,0,1,'-260.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'win_value','الربح',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (430,154,1,3,'TRepDynamicLabel','74D3D097-E3B3-4C58-AE84-A24E7A727BBB',569,4,63,17,0,1,'240.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'item_sell_price','قيمة المبيع',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (435,155,0,1,'TRepLabel','',654,68,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (436,155,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',465,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (437,155,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (438,155,0,1,'TRepLabel','',393,68,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (439,155,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',260,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (440,155,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (441,155,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (446,156,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (447,156,0,1,'TRepLabel','',645,68,55,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (448,156,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',456,68,184,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (449,156,0,1,'TRepLabel','',385,68,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (450,156,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (451,156,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (452,156,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',252,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','الفئة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (453,156,1,3,'TRepDynamicLabel','9DD60326-FF2A-43FD-B94B-A56A866962E6',132,4,54,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'sum_current_balance','الكمية الحالية',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (454,156,1,3,'TRepDynamicLabel','CDCB01DC-65A1-4604-B4C6-56EE978543B8',360,4,55,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'sum_item_in_count','الكمية المشتراة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (455,156,1,3,'TRepDynamicLabel','7A842CA5-C5E1-4177-9881-47CDA8492B39',13,4,55,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'sum_price','اجمالي السعر',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (460,157,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (461,157,0,1,'TRepLabel','',637,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (462,157,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',482,68,149,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (463,157,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (464,157,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (465,157,1,3,'TRepDynamicLabel','57F11DA6-69CE-4000-B42D-D7A68C70C9FA',313,4,75,17,0,1,'-25,410.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'balance_30','30 يوم',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (466,157,1,3,'TRepDynamicLabel','51715465-ADD8-4C9C-9D27-1C23DE7748E2',238,4,75,17,0,1,'-24,420,582.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'balance_60','60 يوم',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (467,157,1,3,'TRepDynamicLabel','8DCD49D5-7BFE-4CA1-99D2-D47C0A1BFE20',163,4,75,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'balance_90','90 يوم',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (468,157,1,3,'TRepDynamicLabel','89D0E055-C247-4F45-8C09-8A19D85E03BD',88,4,75,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'balance_120','120 يوم',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (469,157,1,3,'TRepDynamicLabel','58779830-9C1B-42DE-86DB-AD5FDB17C00E',13,4,75,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'balance_more','اكثر من 120',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (474,158,0,1,'TRepLabel','',654,68,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (475,158,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',465,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (476,158,0,1,'TRepLabel','',393,68,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (477,158,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',260,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','الفئة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (478,158,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (479,158,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (480,158,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (481,158,1,3,'TRepDynamicLabel','EE6501FE-3ECE-4ACC-A41D-9C018174FE1B',161,4,65,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'current_count','الكمية الحالية',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (482,158,1,3,'TRepDynamicLabel','73D344CD-EB4F-49CD-8258-749CD6C4A00D',90,5,70,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'limit_value','حد الطلب',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (483,158,1,3,'TRepDynamicLabel','C1AED09B-97FB-4E30-A99A-2329F5221BB3',20,5,70,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'wanted_count','الكمية المطلوبة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (488,159,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (493,160,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (494,160,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (495,160,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (496,160,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (497,160,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (498,160,0,1,'TRepLabel','',210,68,65,17,0,1,'المستخدم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (499,160,0,3,'TRepDynamicLabel','9ED508D7-6E23-43E6-9132-63BF98997B2F',36,68,169,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_user_name','المستخدم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (504,161,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (509,162,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (514,163,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (515,163,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (516,163,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (517,163,0,1,'TRepLabel','',637,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (518,163,0,1,'TRepLabel','',637,91,65,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (519,163,0,3,'TRepDynamicLabel','811B91E8-A169-47C7-ADC1-85BBF5AE9D1D',530,68,105,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_date','تاريخ العرض',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (520,163,0,3,'TRepDynamicLabel','2115B387-D0F6-4190-B010-D8CB98B8EB87',362,91,273,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','حساب العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (521,163,0,1,'TRepLabel','',637,115,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (522,163,0,3,'TRepDynamicLabel','818C32F4-D656-4306-81AF-5795F646E0E3',34,115,601,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (523,163,1,3,'TRepDynamicLabel','98E552A0-222B-4BF6-B2DD-1B658DAC3BF7',178,4,101,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_net','صافي الفاتورة',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (524,163,1,3,'TRepDynamicLabel','83723CBD-2D0E-475B-A8DC-7AFC5EE278FF',366,4,58,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total_count','مجموع الكمية',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (525,163,1,3,'TRepDynamicLabel','A9816994-217F-41E8-AD72-E2487A28ED85',678,4,40,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,2,1,1,0,0,0,'auto_id','عدد الاقلام',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (530,165,0,1,'TRepLabel','',638,115,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (531,165,0,3,'TRepDynamicLabel','68DC558F-9A84-45F1-AD3F-1CD99BB0F74B',30,113,605,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (532,165,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',364,91,271,17,0,1,'الصندوق',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (533,165,0,1,'TRepLabel','',637,91,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (534,165,0,1,'TRepLabel','',637,68,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (535,165,0,3,'TRepDynamicLabel','478E8241-C59E-45D2-B113-15CAEB2500FA',546,68,89,17,0,1,'10',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_number','رقم السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (536,165,0,1,'TRepLabel','',471,68,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (537,165,0,3,'TRepDynamicLabel','4EB9E840-339B-47F6-BF3E-2AA75690BFC5',367,67,101,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (538,165,0,1,'TRepLabel','',270,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (539,165,0,3,'TRepDynamicLabel','483FCBE5-B571-47E6-929A-D461FE6129CD',183,68,85,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_date','تاريخ السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (540,165,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (541,165,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (542,165,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (543,165,1,3,'TRepDynamicLabel','48E36F2C-8BDD-4FF4-8F05-93FF74D0E46E',291,5,76,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_debit','مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (544,165,1,3,'TRepDynamicLabel','E895D2DD-D43F-4CC7-88F4-2FDBF2067450',367,4,70,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit','دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (549,166,0,1,'TRepLabel','',638,115,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (550,166,0,3,'TRepDynamicLabel','68DC558F-9A84-45F1-AD3F-1CD99BB0F74B',30,113,605,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (551,166,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',364,91,271,17,0,1,'الصندوق',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (552,166,0,1,'TRepLabel','',637,91,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (553,166,0,1,'TRepLabel','',637,68,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (554,166,0,3,'TRepDynamicLabel','478E8241-C59E-45D2-B113-15CAEB2500FA',546,68,89,17,0,1,'10',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_number','رقم السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (555,166,0,1,'TRepLabel','',471,68,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (556,166,0,3,'TRepDynamicLabel','4EB9E840-339B-47F6-BF3E-2AA75690BFC5',367,67,101,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (557,166,0,1,'TRepLabel','',270,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (558,166,0,3,'TRepDynamicLabel','483FCBE5-B571-47E6-929A-D461FE6129CD',183,68,85,17,0,1,'2010-01-15',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_batch_date','تاريخ السند',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (559,166,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (560,166,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (561,166,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (562,166,1,3,'TRepDynamicLabel','E895D2DD-D43F-4CC7-88F4-2FDBF2067450',308,4,130,17,0,1,'5,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit','دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (567,169,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (568,169,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (569,169,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (570,169,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (571,169,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (572,169,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (573,169,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (574,169,0,1,'TRepLabel','',410,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (575,169,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',213,68,195,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (576,169,0,3,'TRepDynamicLabel','4A45F5BB-E3B8-4939-9E9D-63E319DB2B75',215,89,193,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'note_det_value','الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (577,169,0,1,'TRepLabel','',410,89,65,17,0,1,'الرصيد:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (582,170,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (583,170,0,1,'TRepLabel','',637,68,65,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (584,170,0,1,'TRepLabel','',637,90,65,17,0,1,'اسم العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (585,170,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (586,170,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (587,170,0,1,'TRepLabel','',270,68,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (588,170,0,1,'TRepLabel','',270,90,85,17,0,1,'القيمة الاجمالية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (589,170,0,3,'TRepDynamicLabel','68BAE14A-72C3-4E14-B512-9A1AB4962E79',566,68,69,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_note_number','الرقم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (590,170,0,3,'TRepDynamicLabel','14EA25CB-B525-4FA1-ABB0-BAA966417DAA',188,68,81,17,0,1,'2010-01-16',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_note_date','التاريخ',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (591,170,0,3,'TRepDynamicLabel','16BC16E8-89E2-44C8-983D-811625DA29E5',474,90,161,17,0,1,'161001 - عميل نقدي ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name_cust','حساب العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (592,170,0,3,'TRepDynamicLabel','F115D80F-0154-4755-A8BE-8A2A1972EDE5',204,90,65,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'note_list_value','القيمة الاجمالية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (593,170,0,1,'TRepLabel','',101,90,65,17,0,1,'قيمة الدفعة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (594,170,0,3,'TRepDynamicLabel','259C1833-1C55-479B-96A8-8FC55FBDED1B',34,90,65,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'note_list_payment','قيمة الدفعة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (595,170,1,2,'TRepAggregateLabel','Aggregate',326,4,65,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'4','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (600,180,0,1,'TRepLabel','',630,149,73,17,0,1,'رقم الهاتف:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (601,180,0,1,'TRepLabel','',135,126,79,17,0,1,'رقم المرجع:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (602,180,0,1,'TRepLabel','',135,150,79,17,0,1,'تاريخ المباشرة:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (603,180,0,1,'TRepLabel','',135,174,79,17,0,1,'تاريخ التسليم:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (604,180,0,1,'TRepLabel','',631,210,79,17,0,1,'البيان:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (605,180,0,1,'TRepLabel','',630,177,73,17,0,1,'المندوب:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (606,180,0,1,'TRepLabel','',630,122,73,17,0,1,'اسم العميل:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (607,180,0,3,'TRepDynamicLabel','818C32F4-D656-4306-81AF-5795F646E0E3',12,210,617,45,0,1,'محمد شيخ عبود',0,16777215,0,0,1,'TIME NEW ROMANS',14,1,0,0,0,1,0,0,0,'fld_invoice_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (608,180,0,3,'TRepDynamicLabel','9F4BA56A-F1B3-46DA-B110-0EE19850DF36',16,150,117,17,0,1,'2010-02-07',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,0,1,1,0,0,0,'fld_invoice_date_start','تاريخ المباشرة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (609,180,0,3,'TRepDynamicLabel','4FC2EA98-26E0-4B43-8683-23BB32996693',16,174,117,17,0,1,'2010-02-07',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,0,1,1,0,0,0,'fld_invoice_date_end','تاريخ التسليم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (610,180,0,3,'TRepDynamicLabel','E5CDC9B7-D3A6-45A9-B0C4-DDFF70044995',439,149,189,21,0,1,'0992726861',0,16777215,0,0,1,'TIME NEW ROMANS',13,1,0,0,1,1,0,0,0,'fld_cust_phone','رقم الهاتف',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (611,180,0,3,'TRepDynamicLabel','2115B387-D0F6-4190-B010-D8CB98B8EB87',439,118,189,26,0,1,'صبحي صحان',0,16777215,0,0,1,'TIME NEW ROMANS',14,1,0,0,1,1,0,0,0,'fld_cust_name','اسم العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (612,180,0,3,'TRepDynamicLabel','DEB1D3CB-C240-4150-91B8-B1FD0C26AF4E',16,126,117,17,0,1,'2010006150',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,0,1,1,0,0,0,'fld_invoice_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (613,180,0,1,'TRepLabel','',1,0,718,95,6,1,'شركة \\r\\nالافندي و صباهي للكمبيوتر',0,16777215,0,0,1,'TIME NEW ROMANS',30,1,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (614,180,0,3,'TRepDynamicLabel','68E3A005-1582-4EB9-8760-DEA38089E49A',438,176,189,21,0,1,'',0,16777215,0,0,1,'TIME NEW ROMANS',13,1,0,0,1,1,0,0,0,'fld_agent_name','المندوب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (615,180,1,1,'TRepLabel','',381,11,75,17,0,1,'المجموع:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (616,180,1,1,'TRepLabel','',381,44,75,17,0,1,'دفعة نقدية:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (617,180,1,1,'TRepLabel','',381,71,75,17,0,1,'باقي للدفع:',0,16777215,0,0,1,'TIME NEW ROMANS',11,1,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (618,180,1,3,'TRepDynamicLabel','98E552A0-222B-4BF6-B2DD-1B658DAC3BF7',266,10,111,18,0,1,'0.00',0,16777215,0,0,1,'TIME NEW ROMANS',13,1,0,0,1,1,0,0,0,'in_list_net','صافي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (619,180,1,3,'TRepDynamicLabel','4DDABB54-86E1-4789-9774-B42C8695661D',265,44,113,17,0,1,'12,300.00',0,16777215,0,0,1,'TIME NEW ROMANS',13,1,0,0,1,1,0,0,0,'in_list_payment','دفعة مقدمة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (620,180,1,3,'TRepDynamicLabel','15B3EA78-5991-4DA0-B647-6077187AA3AA',265,71,113,17,0,1,'-12,300.00',0,16777215,0,0,1,'TIME NEW ROMANS',13,1,0,0,1,1,0,0,0,'in_list_remain','باقي للدفع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (621,180,3,1,'TRepLabel','',1,0,718,37,6,1,'الشركة غير مسؤول عن اي عذر ناتج عن ( سوء الاستخدام - ضرب كهر',0,16777215,0,0,1,'TIME NEW ROMANS',14,1,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (622,180,3,1,'TRepLabel','',1,44,718,37,6,1,'سوريا - حلب - سنتر اسكندرون   -  هاتف رباعي : 2093  س ت 1659',0,16777215,0,0,1,'TIME NEW ROMANS',15,1,0,2,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (627,182,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (628,182,0,3,'TRepDynamicLabel','EE269FB3-90AD-4E17-B4A9-F9A5CE275349',543,68,93,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_number','رقم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (629,182,0,3,'TRepDynamicLabel','834122AF-3719-40A5-AA65-34FDA4785894',543,92,93,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (630,182,0,3,'TRepDynamicLabel','0419ABB8-75C7-47CD-A879-CA99563357AF',551,116,85,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_date','تاريخ الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (631,182,0,3,'TRepDynamicLabel','DE15921F-8C90-4E0E-91F3-E0E5D69D624A',11,139,625,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (632,182,0,1,'TRepLabel','',101,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (633,182,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',34,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (634,182,0,1,'TRepLabel','',637,68,65,17,0,1,'رقم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (635,182,0,1,'TRepLabel','',637,92,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (636,182,0,1,'TRepLabel','',637,116,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (637,182,0,1,'TRepLabel','',637,139,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (638,182,0,3,'TRepDynamicLabel','C368BBD8-2B93-4340-8384-3F5FBF034D59',183,92,186,17,0,1,'مدير',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_user_name','منظم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (639,182,0,1,'TRepLabel','',372,92,73,17,0,1,'منظم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (640,182,0,3,'TRepDynamicLabel','0BFC491F-E211-4705-948B-4DBB234F19FF',183,68,186,17,0,1,'ابنية و اراضي',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','حساب العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (641,182,0,1,'TRepLabel','',372,68,73,17,0,1,'اسم العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (642,182,0,3,'TRepDynamicLabel','5E8BF6CA-013D-4034-B5D6-7795F5AE6AB0',485,116,65,17,0,1,'20:11:19',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_time','وقت الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (643,182,1,3,'TRepDynamicLabel','7D238777-7376-4634-889B-C33B4FA3D5DD',33,30,85,17,0,1,'10.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total_count','مجموع الكمية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (644,182,1,3,'TRepDynamicLabel','477E6E55-94E2-4EBC-93BC-549B15898994',551,4,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total','اجمالي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (645,182,1,3,'TRepDynamicLabel','8B877C81-B4EE-4DCC-8388-590031CD686E',33,6,85,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_record_count','عدد الاقلام',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (646,182,1,3,'TRepDynamicLabel','759AB118-35EA-4F2E-8ED1-34ECD2D4053F',550,25,85,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_discount_total','الحسم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (647,182,1,3,'TRepDynamicLabel','C00FBDFD-F107-4CC9-9A0D-D7826ADF3624',551,47,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_net','صافي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (648,182,1,3,'TRepDynamicLabel','2B42683F-CAEC-4921-B529-DB733E87F692',32,70,601,17,0,1,'الف ليرة سورية',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_net_tafkit','المبلغ تفقيط',0,0,0,0,0,0,0,0,0,1,0,0,0);
COMMIT;

INSERT INTO tbl_report_controls (rc_id, rc_list_id, rc_parent, rc_type, rc_name, rc_guid, rc_left, rc_top, rc_width, rc_height, rc_align, rc_printable, rc_value_text, rc_value_int, rc_back_color, rc_border_color, rc_border_sides, rc_border_width, rc_text_font, rc_text_size, rc_text_style, rc_text_color, rc_text_h_alig, rc_text_v_align, rc_text_bidi, rc_text_rotation, rc_text_warp, rc_autosize, rc_data_field_1, rc_data_field_2, rc_table_sync, rc_image_center, rc_image_proportion, rc_image_stretch, rc_arraw_cap, rc_arraw_tail, rc_arraw_size, rc_arraw_tilt, rc_line_style, rc_fill_style, rc_corner_angle, rc_show_caption, rc_style) VALUES
  (649,182,1,1,'TRepLabel','',121,6,75,17,0,1,'عدد الاقلام:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (650,182,1,1,'TRepLabel','',121,30,75,17,0,1,'مجموع الكمية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (651,182,1,1,'TRepLabel','',639,4,75,17,0,1,'اجمالي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (652,182,1,1,'TRepLabel','',637,70,72,17,0,1,'المبلغ تفقيط:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (653,182,1,1,'TRepLabel','',638,47,73,17,0,1,'صافي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (654,182,1,1,'TRepLabel','',638,25,73,17,0,1,'الحسم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (659,183,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (660,183,0,3,'TRepDynamicLabel','EE269FB3-90AD-4E17-B4A9-F9A5CE275349',543,68,93,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_number','رقم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (661,183,0,3,'TRepDynamicLabel','834122AF-3719-40A5-AA65-34FDA4785894',543,92,93,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_reference','رقم المرجع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (662,183,0,3,'TRepDynamicLabel','0419ABB8-75C7-47CD-A879-CA99563357AF',551,116,85,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_date','تاريخ الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (663,183,0,3,'TRepDynamicLabel','DE15921F-8C90-4E0E-91F3-E0E5D69D624A',11,139,625,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_desc','البيان',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (664,183,0,1,'TRepLabel','',101,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (665,183,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',34,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (666,183,0,1,'TRepLabel','',637,68,65,17,0,1,'رقم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (667,183,0,1,'TRepLabel','',637,92,65,17,0,1,'المرجع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (668,183,0,1,'TRepLabel','',637,116,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (669,183,0,1,'TRepLabel','',637,139,65,17,0,1,'البيان:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (670,183,0,3,'TRepDynamicLabel','C368BBD8-2B93-4340-8384-3F5FBF034D59',183,92,186,17,0,1,'مدير',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_user_name','منظم الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (671,183,0,1,'TRepLabel','',372,92,73,17,0,1,'منظم الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (672,183,0,3,'TRepDynamicLabel','0BFC491F-E211-4705-948B-4DBB234F19FF',183,68,186,17,0,1,'ابنية و اراضي',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','حساب العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (673,183,0,1,'TRepLabel','',372,68,73,17,0,1,'اسم العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (674,183,0,3,'TRepDynamicLabel','5E8BF6CA-013D-4034-B5D6-7795F5AE6AB0',485,116,65,17,0,1,'20:11:19',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_invoice_time','وقت الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (675,183,1,3,'TRepDynamicLabel','7D238777-7376-4634-889B-C33B4FA3D5DD',33,30,85,17,0,1,'10.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total_count','مجموع الكمية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (676,183,1,3,'TRepDynamicLabel','477E6E55-94E2-4EBC-93BC-549B15898994',551,4,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_total','اجمالي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (677,183,1,3,'TRepDynamicLabel','8B877C81-B4EE-4DCC-8388-590031CD686E',33,6,85,17,0,1,'1',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_record_count','عدد الاقلام',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (678,183,1,3,'TRepDynamicLabel','759AB118-35EA-4F2E-8ED1-34ECD2D4053F',550,25,85,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_discount_total','الحسم',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (679,183,1,3,'TRepDynamicLabel','C00FBDFD-F107-4CC9-9A0D-D7826ADF3624',551,47,85,17,0,1,'1,000.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'in_list_net','صافي الفاتورة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (680,183,1,3,'TRepDynamicLabel','2B42683F-CAEC-4921-B529-DB733E87F692',32,70,601,17,0,1,'الف ليرة سورية',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_net_tafkit','المبلغ تفقيط',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (681,183,1,1,'TRepLabel','',121,6,75,17,0,1,'عدد الاقلام:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (682,183,1,1,'TRepLabel','',121,30,75,17,0,1,'مجموع الكمية:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (683,183,1,1,'TRepLabel','',639,4,75,17,0,1,'اجمالي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (684,183,1,1,'TRepLabel','',637,70,72,17,0,1,'المبلغ تفقيط:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (685,183,1,1,'TRepLabel','',638,47,73,17,0,1,'صافي الفاتورة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (686,183,1,1,'TRepLabel','',638,25,73,17,0,1,'الحسم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (691,185,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (692,185,0,1,'TRepLabel','',637,68,65,17,0,1,'من تاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (693,185,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',508,68,125,17,0,1,'2011-01-28',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (694,185,0,1,'TRepLabel','',637,90,65,17,0,1,'إلى تاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (695,185,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',509,89,125,17,0,1,'2011-12-31',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (696,185,0,1,'TRepLabel','',413,67,65,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (697,185,0,1,'TRepLabel','',413,89,65,17,0,1,'المندوب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (698,185,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',224,67,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (699,185,0,3,'TRepDynamicLabel','68E3A005-1582-4EB9-8760-DEA38089E49A',225,88,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_agent_name','المندوب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (700,185,1,2,'TRepAggregateLabel','Aggregate',208,5,78,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'11','',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (705,186,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (706,186,0,1,'TRepLabel','',637,68,65,17,0,1,'من تاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (707,186,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',508,68,125,17,0,1,'2011-01-28',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (708,186,0,1,'TRepLabel','',637,90,65,17,0,1,'إلى تاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (709,186,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',509,89,125,17,0,1,'2011-12-31',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (710,186,0,1,'TRepLabel','',413,67,65,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (711,186,0,1,'TRepLabel','',413,89,65,17,0,1,'المندوب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (712,186,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',224,67,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (713,186,0,3,'TRepDynamicLabel','68E3A005-1582-4EB9-8760-DEA38089E49A',225,88,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_agent_name','المندوب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (714,186,1,2,'TRepAggregateLabel','Aggregate',162,5,64,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'12','',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (719,187,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (720,187,0,1,'TRepLabel','',637,68,65,17,0,1,'من تاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (721,187,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',508,68,125,17,0,1,'2011-01-28',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (722,187,0,1,'TRepLabel','',637,90,65,17,0,1,'إلى تاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (723,187,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',509,89,125,17,0,1,'2011-12-31',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (728,188,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (729,188,0,1,'TRepLabel','',637,60,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (730,188,0,1,'TRepLabel','',637,83,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (731,188,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,60,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (732,188,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,83,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (737,190,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (738,190,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (739,190,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (740,190,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (741,190,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (742,190,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (743,190,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (744,190,0,3,'TRepDynamicLabel','125EE81B-A189-4A95-AADA-D40934F30966',261,91,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_item_name','المادة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (745,190,0,1,'TRepLabel','',450,91,56,17,0,1,'المادة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (746,190,0,1,'TRepLabel','',181,91,66,17,0,1,'الفئة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (747,190,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (748,190,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (749,190,0,3,'TRepDynamicLabel','C4612633-7283-4F01-B559-752629F5AFC6',48,91,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_class_name','الفئة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (754,191,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (755,191,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (756,191,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (757,191,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (758,191,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (759,191,0,1,'TRepLabel','',450,68,57,17,0,1,'العميل:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (760,191,0,3,'TRepDynamicLabel','7F38AD5C-4CA8-4C1B-8DAC-F60D665756F9',261,68,185,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_cust_name','العميل',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (761,191,0,1,'TRepLabel','',181,68,65,17,0,1,'المستودع:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (762,191,0,3,'TRepDynamicLabel','BCFAF475-7187-4117-ACC0-AB01E3A2260F',48,68,129,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_store_name','المستودع',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (767,201,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (772,202,0,1,'TRepLabel','',637,79,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (773,202,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (774,202,0,1,'TRepLabel','',638,55,57,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (775,202,0,3,'TRepDynamicLabel','129754EF-C55F-4D52-A70F-262F4D2A65C2',521,78,113,17,0,1,'2011-01-28',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_Charger_date','التاريخ',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (776,202,0,3,'TRepDynamicLabel','2A7083F7-0477-4B5B-B11F-6188E1AA611C',524,54,109,17,0,1,'0',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_Charger_number','رقم العملية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (777,202,0,1,'TRepLabel','',90,60,57,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (778,202,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',20,59,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (779,202,1,2,'TRepAggregateLabel','Aggregate',321,3,75,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'3','',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (784,203,2,1,'TRepLabel','',637,79,65,17,0,1,'التاريخ:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (785,203,2,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (786,203,2,1,'TRepLabel','',638,55,57,17,0,1,'الرقم:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (787,203,2,3,'TRepDynamicLabel','129754EF-C55F-4D52-A70F-262F4D2A65C2',521,78,113,17,0,1,'2011-01-28',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_Charger_date','التاريخ',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (788,203,2,1,'TRepLabel','',90,60,57,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (789,203,2,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',20,59,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (790,203,2,3,'TRepDynamicLabel','2A7083F7-0477-4B5B-B11F-6188E1AA611C',522,54,112,17,0,1,'0',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_exchanger_number','رقم العملية',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (795,204,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (796,204,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',532,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (797,204,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',532,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (798,204,0,1,'TRepLabel','',649,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (799,204,0,1,'TRepLabel','',649,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (800,204,0,1,'TRepLabel','',465,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (801,204,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',281,68,181,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (802,204,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (803,204,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (804,204,0,1,'TRepLabel','',465,91,65,17,0,1,'الرصيد:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (805,204,0,3,'TRepDynamicLabel','6025B8E7-7DBD-427A-8D66-DED21BD154CF',287,91,156,17,0,1,'24,326,053.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_value','الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (806,204,0,3,'TRepDynamicLabel','DED7FE8B-50A0-4F2A-B319-E1A020920F2A',443,91,20,17,0,1,' لنا',0,16777215,0,0,1,'Tahoma',8,1,0,0,1,1,0,0,0,'fld_balance_type','نوع الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (807,204,0,3,'TRepDynamicLabel','CB71C19C-BABE-4F93-80A6-2152342E16C2',10,115,453,17,0,1,'اربعة و عشرون مليوناً و ثلاثمائة و ستة و عشرون الفاً و ثلاث ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_tafkit','القيمة تفقيطاً',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (808,204,1,3,'TRepDynamicLabel','11286B36-374A-46B6-9E1F-2AC21B5373F2',266,5,65,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (809,204,1,3,'TRepDynamicLabel','1C5499AB-2F0A-44B4-B3F9-BDE5FEA74A7F',196,3,65,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (814,205,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,1047,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (815,205,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',852,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (816,205,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',852,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (817,205,0,1,'TRepLabel','',969,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (818,205,0,1,'TRepLabel','',969,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (819,205,0,1,'TRepLabel','',781,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (820,205,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',641,68,137,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (821,205,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (822,205,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (823,205,0,1,'TRepLabel','',781,91,65,17,0,1,'الرصيد:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (824,205,0,3,'TRepDynamicLabel','6025B8E7-7DBD-427A-8D66-DED21BD154CF',650,91,97,17,4,1,'24,326,053.60',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_value','الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (825,205,0,3,'TRepDynamicLabel','DED7FE8B-50A0-4F2A-B319-E1A020920F2A',746,91,33,17,0,1,' لنا',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_type','نوع الرصيد',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (826,205,0,3,'TRepDynamicLabel','CB71C19C-BABE-4F93-80A6-2152342E16C2',34,91,609,17,0,1,'اربعة و عشرون مليوناً و ثلاثمائة و ستة و عشرون الفاً و ثلاث ',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_balance_tafkit','القيمة تفقيطاً',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (827,205,1,3,'TRepDynamicLabel','11286B36-374A-46B6-9E1F-2AC21B5373F2',611,3,77,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (828,205,1,3,'TRepDynamicLabel','1C5499AB-2F0A-44B4-B3F9-BDE5FEA74A7F',524,2,77,17,0,1,'0.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (833,206,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (834,206,0,1,'TRepLabel','',637,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (835,206,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',520,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (836,206,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',520,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (837,206,0,1,'TRepLabel','',637,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (838,206,0,1,'TRepLabel','',102,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (839,206,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (840,206,0,1,'TRepLabel','',449,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (841,206,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',273,68,169,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (842,206,1,3,'TRepDynamicLabel','096AEF64-06E8-4C9F-B8CF-9CD3A9C15E32',321,4,96,17,0,1,'1,250.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_debit_main','مجموع مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (843,206,1,3,'TRepDynamicLabel','DF1AA2F0-DD0A-4777-8FF3-904845019A54',222,4,99,17,0,1,'1,250.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_currency_credit_main','مجموع دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (844,206,1,3,'TRepDynamicLabel','B21F364A-2A0C-4440-8D60-E41E726332CE',129,4,93,17,0,1,'1,260.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_debit_temp','رصيد مدين',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (845,206,1,3,'TRepDynamicLabel','B2C72DDD-3FD2-47F3-BEA7-4F905B850394',21,4,108,17,0,1,'1,260.00',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'gl_credit_temp','رصيد دائن',1,0,0,0,0,0,0,0,0,1,0,0,0),
  (850,207,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (851,207,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',532,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (852,207,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',532,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (853,207,0,1,'TRepLabel','',649,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (854,207,0,1,'TRepLabel','',649,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (855,207,0,1,'TRepLabel','',465,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (856,207,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (857,207,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (858,207,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',244,68,217,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (863,208,0,3,'TRepDynamicLabel','DA1C13D1-EF5F-457F-ABC4-E53D1E938F63',1,1,718,50,1,1,'دفتر اليومية',0,16777215,0,0,1,'TIMES NEW ROMAN',22,1,0,2,1,1,0,0,0,'fld_report_title','عنوان التقرير',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (864,208,0,3,'TRepDynamicLabel','8414B526-6C94-4923-A062-F8A288E20F9E',532,68,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_start','تاريخ البدء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (865,208,0,3,'TRepDynamicLabel','27EF81D8-A61A-4D29-A651-7C4B10B9D8E1',532,91,115,17,0,1,'2010-01-14',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_date_end','تاريخ الانتهاء',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (866,208,0,1,'TRepLabel','',649,68,65,17,0,1,'تاريخ البدء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (867,208,0,1,'TRepLabel','',649,91,65,17,0,1,'تاريخ الانتهاء:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (868,208,0,1,'TRepLabel','',465,68,65,17,0,1,'الحساب:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (869,208,0,1,'TRepLabel','',98,68,65,17,0,1,'العملة:',0,16777215,0,0,1,'Tahoma',8,0,0,1,1,1,0,0,0,'','',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (870,208,0,3,'TRepDynamicLabel','5F9670AE-97E0-4895-82F5-DA8BD5360022',35,68,65,17,0,1,'ليرة',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_currency_name','العملة',0,0,0,0,0,0,0,0,0,1,0,0,0),
  (871,208,0,3,'TRepDynamicLabel','9A7EFD70-89F8-472B-9643-9C874ADFABEA',244,68,217,17,0,1,'',0,16777215,0,0,1,'Tahoma',8,0,0,0,1,1,0,0,0,'fld_account_name','الحساب',0,0,0,0,0,0,0,0,0,1,0,0,0);
COMMIT;

INSERT INTO tbl_reports_list (r_id, r_type_const, r_type_id, r_lang_id, r_lang_trans, r_reset, r_name, r_global_header, r_rep_header, r_rep_footer, r_page_header, r_page_footer, r_rep_detail, r_rep_barcode_column, r_page_color, r_page_image_style, r_page_image_print, r_rep_roll_print, r_rep_details_height, r_rep_header_height, r_rep_footer_height, r_page_header_height, r_page_footer_height, r_page_margine, r_page_margine_left, r_page_margine_top, r_page_margine_right, r_page_margine_bottom, r_page_direction, r_page_size, r_page_size_width, r_page_size_height) VALUES
  (121,1,0,1,1,0,'Bill',1,1,1,0,0,0,0,16777215,0,0,0,81,191,132,100,100,0,10,10,10,10,0,9,210,297),
  (124,2,0,1,1,0,'Batch',1,1,1,0,0,0,0,16777215,0,0,0,158,145,54,100,100,0,10,10,10,10,0,9,210,297),
  (125,28,0,1,1,0,'Employee List',1,1,0,0,0,0,0,16777215,0,0,0,87,86,26,26,26,0,10,10,10,10,0,9,210,297),
  (126,3,0,1,1,0,'Batch Daily',1,1,1,0,0,0,0,16053492,0,0,0,158,164,54,100,100,0,10,10,10,10,0,9,210,297),
  (127,62,0,1,1,0,'Batch Rec',1,1,0,0,0,2,0,16777215,0,0,0,132,312,100,100,100,0,10,10,10,10,0,9,210,297),
  (128,62,0,1,1,0,'Batch Pay',1,1,0,0,0,2,0,16777215,0,0,0,132,320,100,100,100,0,10,10,10,10,0,9,210,297),
  (134,34,0,1,1,0,'Bill Process',1,1,0,0,0,0,0,16777215,0,0,0,99,145,54,100,100,0,10,10,10,10,0,9,210,297),
  (135,1,0,1,1,0,'Pos',0,1,1,0,0,0,0,16777215,0,0,0,103,137,178,26,26,0,2,2,2,2,0,256,80,297),
  (136,36,0,1,1,0,'Payroll',1,1,1,0,0,0,0,16777215,0,0,0,92,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (137,7,0,1,1,0,'Rep Journal',1,1,1,0,0,0,0,16777215,0,0,0,158,145,54,100,100,0,10,10,10,10,0,9,210,297),
  (138,9,0,1,1,0,'Rep Ledger',1,1,1,0,0,0,0,16777215,0,0,0,158,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (139,18,0,1,1,0,'Rep Acc Balance',1,1,1,0,0,0,0,16777215,0,0,0,91,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (140,20,0,1,1,0,'Rep Acc Statement',1,1,1,0,0,0,0,16777215,0,0,0,158,165,54,100,100,0,10,10,10,10,0,9,210,297),
  (141,33,0,1,1,0,'Rep Acc Details',1,1,1,0,0,0,0,16777215,0,0,0,158,145,54,26,26,0,10,10,10,10,1,9,297,210),
  (144,4,0,1,1,0,'Rep Trial Balance',1,1,1,0,0,0,0,16777215,0,0,0,85,145,54,100,100,0,10,10,10,10,0,9,210,297),
  (145,13,0,1,1,0,'Rep Cost Center',1,1,1,0,0,0,0,16777215,0,0,0,99,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (146,8,0,1,1,0,'Rep Budget',1,1,1,0,0,0,0,16777215,0,0,0,158,145,78,26,100,0,10,10,10,10,0,9,210,297),
  (147,29,0,1,1,0,'Rep Item Movement',1,1,1,0,0,0,0,16777215,0,0,0,110,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (150,40,0,1,1,0,'Rep Item Movement Sum',1,1,1,0,0,0,0,16777215,0,0,0,95,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (151,32,0,1,1,0,'Rep Gift Movement',1,1,1,0,0,0,0,16777215,0,0,0,74,145,66,100,100,0,10,10,10,10,0,9,210,297),
  (152,6,0,1,1,0,'Rep Inventory',1,1,1,0,0,0,0,16777215,0,0,0,78,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (153,19,0,1,1,0,'Rep Bill Win',1,1,1,0,0,0,0,16777215,0,0,0,100,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (154,48,0,1,1,0,'Rep Item Win',1,1,1,0,0,0,0,16777215,0,0,0,93,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (155,12,0,1,1,0,'Rep Serials',1,1,0,0,0,0,0,16777215,0,0,0,101,117,26,26,26,0,10,10,10,10,0,9,210,297),
  (156,37,0,1,1,0,'Rep Expirty',1,1,1,0,0,0,0,16777215,0,0,0,88,117,54,26,26,0,10,10,10,10,0,9,210,297),
  (157,44,0,1,1,0,'Rep Debit Age',1,1,1,0,0,0,0,16777215,0,0,0,103,119,53,26,26,0,10,10,10,10,0,9,210,297),
  (158,5,0,1,1,0,'Rep Exceeded Limit',1,1,1,0,0,0,0,16777215,0,0,0,88,120,54,26,26,0,10,10,10,10,0,9,210,297),
  (159,23,0,1,1,0,'Rep Installment',1,1,0,0,0,0,0,16053492,0,0,0,75,84,100,100,100,0,10,10,10,10,0,256,210,297),
  (160,25,0,1,1,0,'Rep Audit',1,1,0,0,0,0,0,16777215,0,0,0,158,145,100,100,100,0,10,10,10,10,0,256,210,297),
  (161,26,0,1,1,0,'Rep Recycle Bin',1,1,0,0,0,0,0,16777215,0,0,0,158,85,100,100,100,0,10,10,10,10,0,256,210,297),
  (162,27,0,1,1,0,'Pick Item',1,1,0,0,0,0,0,16777215,0,0,0,100,75,26,26,26,0,10,10,10,10,0,9,210,297),
  (163,30,0,1,1,0,'Price View',1,1,1,0,0,0,0,16777215,0,0,0,97,164,54,100,100,0,10,10,10,10,0,256,210,297),
  (165,3,0,1,1,0,'Batch Cash Daily',1,1,1,0,0,0,0,16777215,0,0,0,81,165,54,26,26,0,10,10,10,10,0,9,210,297),
  (166,3,0,1,1,0,'Batch Cash Rec',1,1,1,0,0,0,0,16777215,0,0,0,73,167,54,26,26,0,10,10,10,10,0,9,210,297),
  (169,46,0,1,1,0,'Rep Notes',1,1,0,0,0,0,0,16777215,0,0,0,158,145,100,100,100,0,10,10,10,10,0,256,210,297),
  (170,45,0,1,1,0,'Notes',1,1,1,0,0,0,0,16777215,0,0,0,96,145,54,100,100,0,10,10,10,10,0,256,210,297),
  (180,900,0,1,1,0,'cpu price view',0,1,1,0,1,0,0,16777215,0,0,0,135,281,124,100,110,0,10,10,10,10,0,256,210,297),
  (182,73,0,1,1,0,'Order',1,1,1,0,0,0,0,16777215,0,0,0,115,191,132,100,100,0,10,10,10,10,0,9,210,297),
  (183,71,0,1,1,0,'AdvPriceView',1,1,1,0,0,0,0,16777215,0,0,0,81,191,132,100,100,0,10,10,10,10,0,9,210,297),
  (185,72,0,1,1,0,'Adv Process',1,1,1,0,0,0,0,16777215,0,0,0,115,145,61,100,100,0,10,10,10,10,0,9,210,297),
  (186,74,0,1,1,0,'Order Process',1,1,1,0,0,0,0,16777215,0,0,0,115,145,61,100,100,0,10,10,10,10,0,9,210,297),
  (187,77,0,1,1,0,'Order Item Process',1,1,0,0,0,0,0,16777215,0,0,0,115,145,61,100,100,0,10,10,10,10,0,9,210,297),
  (188,93,0,1,1,0,'Batch Process',1,1,0,0,0,0,0,16777215,0,0,0,130,133,26,26,26,0,10,10,10,10,0,9,210,297),
  (190,102,0,1,1,0,'Item Inactive',1,1,0,0,0,0,0,16777215,0,0,0,95,145,26,26,26,0,10,10,10,10,0,9,210,297),
  (191,99,0,1,1,0,'Invoice Rep Sum',1,1,0,0,0,0,0,16777215,0,0,0,95,145,26,26,26,0,10,10,10,10,0,9,210,297),
  (201,69,0,1,1,0,'Adjustment Compare',0,1,0,0,0,0,0,16777215,0,0,0,88,100,100,26,100,0,10,10,10,10,0,9,210,297),
  (202,63,0,1,1,0,'Charge Adjustment',1,1,1,0,0,0,0,16777215,0,0,0,83,123,52,26,26,0,10,10,10,10,0,9,210,297),
  (203,65,0,1,1,0,'Currency Exchanger',0,0,0,1,0,0,0,16777215,0,0,0,77,100,26,125,26,0,10,10,10,10,0,9,210,297),
  (204,70,0,1,1,0,'Rep Acc Statement Curr',1,1,1,0,0,0,0,16777215,0,0,0,96,165,54,26,100,0,10,10,10,10,0,9,210,297),
  (205,85,0,1,1,0,'Rep Acc Details Curr',1,1,1,0,0,0,0,16777215,0,0,0,89,145,54,26,26,0,10,10,10,10,1,9,297,210),
  (206,94,0,1,1,0,'Rep Acc Balance Curr',1,1,1,0,0,0,0,16777215,0,0,0,91,145,54,26,26,0,10,10,10,10,0,9,210,297),
  (207,98,0,1,1,0,'Cheque In Process',1,1,0,0,0,0,0,16777215,0,0,0,80,142,54,26,100,0,10,10,10,10,0,9,210,297),
  (208,103,0,1,1,0,'Cheque Out Process',1,1,0,0,0,0,0,16777215,0,0,0,73,142,54,26,100,0,10,10,10,10,0,9,210,297);
COMMIT;

INSERT INTO tbl_update_config (up_id, up_number, up_name, up_date) VALUES
  (1,1,'','2008-10-15 13:28:07'),
  (2,2,'','2008-10-15 13:28:08'),
  (3,3,'','2008-10-15 13:28:08'),
  (4,4,'','2008-10-15 13:28:11'),
  (5,5,'','2008-10-15 13:28:11'),
  (6,6,'','2008-10-15 13:28:14'),
  (7,7,'','2008-10-15 13:28:15'),
  (8,8,'','2008-10-15 13:28:31'),
  (9,9,'','2009-01-11 05:14:07'),
  (10,10,'','2009-01-11 05:14:07'),
  (12,11,'','2009-01-29 06:37:09'),
  (13,12,'','2009-03-30 00:30:24'),
  (14,13,'','2009-11-13 02:14:46'),
  (15,14,'','2010-01-16 18:18:15'),
  (16,15,'','2010-01-16 18:18:15'),
  (17,16,'','2010-02-24 19:06:48'),
  (18,17,'','2010-04-24 22:00:36'),
  (19,18,'','2010-06-02 19:08:01'),
  (20,19,'','2010-06-07 16:16:15'),
  (21,20,'','2010-06-07 16:16:15'),
  (22,21,'','2010-06-23 18:07:21'),
  (23,22,'','2010-06-23 18:07:21'),
  (24,23,'','2010-06-30 17:11:42'),
  (25,24,'','2010-06-30 17:11:42'),
  (26,25,'','2010-06-30 17:11:42'),
  (27,26,'','2010-11-07 21:03:16'),
  (28,27,'','2010-11-07 21:03:16'),
  (29,28,'','2010-11-07 21:03:16'),
  (30,29,'','2010-11-07 21:03:16'),
  (31,30,'','2010-11-07 21:03:17'),
  (32,31,'','2010-11-07 21:03:17'),
  (33,32,'','2011-09-21 15:50:42'),
  (34,33,'','2011-09-21 15:50:42'),
  (35,34,'','2011-09-21 15:50:42'),
  (36,35,'','2011-09-21 15:50:42'),
  (37,36,'','2011-09-21 15:50:42'),
  (38,37,'','2011-09-21 15:50:42'),
  (39,38,'','2011-09-21 15:50:42'),
  (40,39,'','2011-09-21 15:50:42'),
  (41,40,'','2012-05-21 13:01:47'),
  (42,41,'','2012-05-21 13:01:47'),
  (43,42,'','2012-05-21 13:01:47'),
  (44,43,'','2012-05-21 13:01:47'),
  (45,44,'','2012-05-21 13:01:47'),
  (46,45,'','2012-05-21 13:01:47'),
  (48,46,'','2012-10-14 23:55:28'),
  (49,47,'','2018-06-13 13:38:12'),
  (50,48,'','2018-06-13 13:38:12'),
  (51,49,'','2018-06-13 13:38:12'),
  (52,50,'','2018-06-13 13:38:12'),
  (53,51,'','2018-06-13 13:38:12'),
  (54,52,'','2018-06-13 13:38:12'),
  (55,53,'','2018-06-13 13:38:12'),
  (56,54,'','2018-06-13 13:38:12'),
  (57,55,'','2018-06-13 13:38:12');
COMMIT;

INSERT INTO tbl_update_config_crystal (up_id, up_number, up_name, up_date) VALUES
  (1,1,'','2018-06-13 13:38:17'),
  (2,2,'','2018-06-13 13:38:17'),
  (3,3,'','2018-06-13 13:38:17'),
  (4,4,'','2018-06-13 13:38:18'),
  (5,5,'','2018-06-13 13:38:18'),
  (6,6,'','2018-06-13 13:38:18'),
  (7,7,'','2018-06-13 13:38:18'),
  (8,8,'','2018-06-13 13:38:18'),
  (9,9,'','2018-06-13 13:38:18'),
  (10,10,'','2018-06-13 13:38:18'),
  (11,11,'','2018-06-13 13:38:20'),
  (12,12,'','2018-06-13 13:38:20'),
  (13,13,'','2018-06-13 13:38:20'),
  (14,14,'','2018-06-13 13:38:20'),
  (15,15,'','2018-06-13 13:38:20'),
  (16,16,'','2018-06-13 13:38:20'),
  (17,17,'','2018-06-13 13:38:20'),
  (18,18,'','2018-06-13 13:38:20'),
  (19,19,'','2018-06-13 13:38:20'),
  (20,20,'','2018-06-13 13:38:20'),
  (21,21,'','2018-06-13 13:38:20'),
  (22,22,'','2018-06-13 13:38:20'),
  (23,23,'','2018-06-13 13:38:20'),
  (24,24,'','2018-06-13 13:38:39'),
  (25,25,'','2018-06-13 13:38:39'),
  (26,26,'','2018-06-13 13:38:39'),
  (27,27,'','2018-06-13 13:38:39'),
  (28,28,'','2018-06-13 13:38:39'),
  (29,29,'','2018-06-13 13:38:39'),
  (30,30,'','2018-06-13 13:38:39'),
  (31,31,'','2018-06-13 13:38:39'),
  (32,32,'','2018-06-13 13:38:40'),
  (33,33,'','2018-06-13 13:38:40'),
  (34,34,'','2018-06-13 13:38:40'),
  (35,35,'','2018-06-13 13:38:40'),
  (36,36,'','2018-06-13 13:38:40'),
  (37,37,'','2018-06-13 13:38:40');
COMMIT;

